/*
 * Decompiled with CFR 0.152.
 */
package pedersen.movement.absolute;

import java.awt.geom.Point2D;
import pedersen.movement.MovementMethod;
import pedersen.movement.absolute.MovementMethodAbsoluteBase;
import pedersen.physics.Direction;
import pedersen.physics.HasDirection;
import pedersen.physics.HasPosition;
import pedersen.physics.Position;
import pedersen.physics.Snapshot;
import pedersen.physics.Vehicle;
import pedersen.physics.constant.PhysicsConstants;
import pedersen.physics.constant.PositionImpl;
import pedersen.physics.constant.VehicleImpl;
import pedersen.util.Arena;
import pedersen.util.Constraints;

public class MovementMethodUnpinImpl
extends MovementMethodAbsoluteBase
implements MovementMethod {
    private static final MovementMethod singleton = new MovementMethodUnpinImpl();

    @Override
    public Vehicle getDestination() {
        double leeway = 36.0;
        Vehicle vehicleChassis = null;
        Vehicle combatant = super.getCombatantSnapshot();
        if (combatant == null) {
            this.checkpoint("combatant is null");
        }
        Snapshot opponent = super.getTargetSnapshot();
        Position center = Arena.getCenter();
        if (opponent == null) {
            Direction tangent = combatant.getPosition().getBearing(center).getTangentAngle();
            vehicleChassis = new VehicleImpl((HasPosition)combatant, (HasDirection)tangent, PhysicsConstants.zeroVelocity);
        } else {
            Point2D.Double a = combatant.getPosition().getPoint2D();
            Point2D.Double b = opponent.getPosition().getPoint2D();
            Point2D.Double c = center.getPoint2D();
            vehicleChassis = !(!Constraints.isInRange(a.y - leeway, b.y, c.y) && !Constraints.isInRange(c.y, b.y, a.y + leeway) || !Constraints.isInRange(a.x - leeway, b.x, c.x) && !Constraints.isInRange(c.x, b.x, a.x + leeway)) ? this.getUnpinDestination(combatant, a, b, c) : this.getOptimalDestination(opponent, center);
        }
        return vehicleChassis;
    }

    private Vehicle getUnpinDestination(Vehicle combatant, Point2D.Double a, Point2D.Double b, Point2D.Double c) {
        PositionImpl destination = Math.abs(a.x - b.x) > Math.abs(a.y - b.y) ? new PositionImpl(a.x, c.y) : new PositionImpl(c.x, a.y);
        Direction bearing = combatant.getPosition().getBearing(destination);
        VehicleImpl result = new VehicleImpl((HasPosition)destination, (HasDirection)bearing, combatant.getDirection().equalsDirection(bearing) ? Constraints.maxAbsVehicleVelocity : PhysicsConstants.zeroVelocity);
        return result;
    }

    private Vehicle getOptimalDestination(Snapshot b, Position c) {
        double distance = Math.max(b.getPosition().getDistance(c).distance(), MovementMethod.safeDistance.distance());
        Direction bearing = b.getPosition().getBearing(c);
        Position destination = b.getPosition().addVector((HasDirection)bearing, distance);
        return new VehicleImpl((HasPosition)destination, (HasDirection)bearing, Constraints.maxAbsVehicleVelocity);
    }

    public static MovementMethod getInstance() {
        return singleton;
    }
}

