/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics.constant;

import pedersen.debug.DebuggableBase;
import pedersen.physics.Direction;
import pedersen.physics.HasDirection;
import pedersen.physics.constant.PhysicsConstants;
import pedersen.util.Constraints;

public class DirectionImpl
extends DebuggableBase
implements Direction {
    private final double direction;

    public DirectionImpl(double radians) {
        this.direction = radians;
    }

    public DirectionImpl(HasDirection other) {
        this(other.getDirection().getAbsoluteRadians());
    }

    @Override
    public Direction getDirection() {
        return this;
    }

    @Override
    public double getAbsoluteRadians() {
        return Constraints.getZeroToTwoPi(this.direction);
    }

    @Override
    public double getRelativeRadians() {
        return Constraints.getNegativePiToPi(this.direction);
    }

    @Override
    public boolean equalsDirection(HasDirection other) {
        return Constraints.areEqual(this.getAbsoluteRadians(), other.getDirection().getAbsoluteRadians());
    }

    @Override
    public Direction addRadians(double radians) {
        return new DirectionImpl(this.direction + radians);
    }

    @Override
    public Direction getRelativeDirection(HasDirection other) {
        return other.getDirection().addRadians(-this.direction);
    }

    @Override
    public Direction getTangentAngle() {
        return this.addRadians(1.5707963267948966);
    }

    @Override
    public Direction getOpposedAngle() {
        return this.addRadians(PhysicsConstants.halfCircle.getAbsoluteRadians());
    }

    @Override
    public String description() {
        return "( " + super.trim(this.direction) + " )";
    }
}

