/*
 * Decompiled with CFR 0.152.
 */
package brainfade.melee;

import brainfade.melee.utils.Enemy;
import brainfade.melee.utils.MeleePM;
import brainfade.melee.utils.Shoot;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class Genghis
extends AdvancedRobot {
    Hashtable targets = new Hashtable();
    static HashMap patterns = new HashMap();
    Enemy target = new Enemy();
    static MeleePM me = new MeleePM();
    static Hashtable dxs = new Hashtable();
    static Hashtable dys = new Hashtable();
    final double pi = Math.PI;
    int direction = 1;
    double firePower = 3.0;
    double midpointstrength = 0.0;
    int midpointcount = 0;
    Point2D position = new Point2D.Double();
    Point2D whereToGo = new Point2D.Double();
    double bulletSpeed = 11.0;
    static int bulletsFired = 0;
    static int bulletsHit = 0;
    boolean found = false;
    boolean readyToFire = false;
    long radarSpinTime = -10L;

    public void run() {
        this.setColors(Color.yellow, Color.black, Color.white);
        this.out.println(patterns.size());
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.turnRadarRightRadians(Math.PI * 2);
        while (true) {
            this.position.setLocation(this.getX(), this.getY());
            if (Math.abs(this.getDistanceRemaining()) < 2.0) {
                this.doMove();
            }
            this.doGun();
            this.doRadar();
            this.execute();
            me.updateInfo(this.getTime(), this.getX(), this.getY(), this.target.bearing + Math.PI, this.target.distance, this.getEnergy());
        }
    }

    public void doGun() {
        if (this.getGunHeat() / this.getGunCoolingRate() < 3.0) {
            this.position.setLocation(this.getX(), this.getY());
            MeleePM pm = (MeleePM)patterns.get(this.target.name);
            this.firePower = Math.min(Math.min(this.target.energy / 4.0, 3.0), this.getEnergy() / 3.0);
            double enemyBearing = this.absoluteBearing(this.position, this.target.position);
            double gunAngle = this.absoluteBearing(this.position, pm.predictAngle(this.getX(), this.getY(), this.firePower, this.getTime()));
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(gunAngle - this.getGunHeadingRadians())));
            this.addCustomEvent(new Shoot(this, this.target.name, this.getTime()));
        }
    }

    public void doMove() {
        double time = Math.min(this.target.distance / 11.0, 30.0);
        double bestCount = 1.0E21;
        int bestVal = 0;
        for (int i = 0; i < 32; ++i) {
            Polygon me = this.getPolygon((double)i * Math.PI / 16.0, time);
            double intersections = this.getRisk(this.vectorToLocation((double)i * Math.PI / 16.0, time * 8.0, this.position), time);
            if (!(intersections < bestCount)) continue;
            bestCount = intersections;
            bestVal = i;
        }
        time = this.getOthers() == 1 ? (1.0 - Math.random() * 0.7) * time : time;
        double velocity = 8.0;
        Point2D temp1 = this.vectorToLocation((double)bestVal * Math.PI / 16.0, time * 8.0, this.position);
        Point2D temp2 = this.vectorToLocation((double)bestVal * Math.PI / 16.0, -time * 8.0, this.position);
        velocity = this.getGravity(temp1) > this.getGravity(temp2) ? -8.0 : 8.0;
        while (this.countIntersects(this.makePolygon((double)bestVal * Math.PI / 16.0, (time -= 1.0) * velocity, this.position), time) > 0 && !(time < 0.0)) {
        }
        this.goTo(this.vectorToLocation((double)bestVal * Math.PI / 16.0, time * velocity, this.position));
    }

    public int countIntersects(Polygon me, double time) {
        int[] xpos = me.xpoints;
        int[] ypos = me.ypoints;
        Enumeration e = new Vector(this.targets.values()).elements();
        int count = 0;
        double energy = 0.0;
        while (e.hasMoreElements()) {
            Enemy temp = (Enemy)e.nextElement();
            Polygon enemy = temp.getPolygon(time);
            if (!this.intersects(me, enemy)) continue;
            ++count;
        }
        return count;
    }

    public Polygon getPolygon(double heading, double time) {
        Point2D p2;
        Point2D p1;
        double xOffset = Math.cos(heading) * (100.0 - this.getEnergy());
        double yOffset = Math.sin(heading) * (100.0 - this.getEnergy());
        Point2D destination = this.vectorToLocation(heading, time * 8.0 * (double)this.sign(this.getVelocity()), this.position);
        int[] xpos = new int[4];
        int[] ypos = new int[4];
        if (this.position.getY() > destination.getY()) {
            p1 = this.position;
            p2 = destination;
        } else {
            p2 = this.position;
            p1 = destination;
        }
        xpos[0] = (int)(p1.getX() - xOffset);
        xpos[1] = (int)(p1.getX() + xOffset);
        xpos[2] = (int)(p2.getX() + xOffset);
        xpos[3] = (int)(p2.getX() - xOffset);
        ypos[0] = (int)(p1.getY() - yOffset);
        ypos[1] = (int)(p1.getY() - yOffset);
        ypos[2] = (int)(p2.getY() + yOffset);
        ypos[3] = (int)(p2.getY() + yOffset);
        return new Polygon(xpos, ypos, 4);
    }

    public Polygon makePolygon(double heading, double distance, Point2D source) {
        Point2D p2;
        Point2D p1;
        double xOffset = Math.cos(heading) * 18.0;
        double yOffset = Math.sin(heading) * 18.0;
        Point2D destination = this.vectorToLocation(heading, distance, source);
        int[] xpos = new int[4];
        int[] ypos = new int[4];
        if (this.position.getY() > destination.getY()) {
            p1 = source;
            p2 = destination;
        } else {
            p2 = source;
            p1 = destination;
        }
        xpos[0] = (int)(p1.getX() - xOffset);
        xpos[1] = (int)(p1.getX() + xOffset);
        xpos[2] = (int)(p2.getX() + xOffset);
        xpos[3] = (int)(p2.getX() - xOffset);
        ypos[0] = (int)(p1.getY() - yOffset);
        ypos[1] = (int)(p1.getY() - yOffset);
        ypos[2] = (int)(p2.getY() + yOffset);
        ypos[3] = (int)(p2.getY() + yOffset);
        return new Polygon(xpos, ypos, 4);
    }

    public boolean intersects(Polygon poly1, Polygon poly2) {
        int[] xpos = poly1.xpoints;
        int[] ypos = poly1.ypoints;
        for (int i = 0; i < 4; ++i) {
            if (poly2.contains(xpos[i], ypos[i])) continue;
            return false;
        }
        return true;
    }

    public double getRisk(Point2D destination, double time) {
        if (!this.fieldRectangle(50.0).contains(destination)) {
            return 9.999999999E9;
        }
        double risk = 1.0;
        Enumeration e = this.targets.elements();
        Ellipse2D.Double circle = new Ellipse2D.Double(this.position.getX(), this.position.getY(), time * 16.0, time * 16.0);
        while (e.hasMoreElements()) {
            Enemy temp = (Enemy)e.nextElement();
            double thisRisk = (temp.whosClosest(this.targets) ? 1.0 + temp.getMyAdvancingVelocity(this.position, destination) : 1.0) * temp.getGravity(destination);
            if (!temp.isAlive) continue;
            risk += thisRisk;
        }
        return risk * (double)(1 + this.countIntersects(this.getPolygon(this.absoluteBearing(this.position, destination), time), time));
    }

    public double getGravity(Point2D destination) {
        if (!this.fieldRectangle(50.0).contains(destination)) {
            return 999999.0;
        }
        double risk = 1.0;
        Enumeration e = this.targets.elements();
        Point2D predict = me.predictAngle(this.target.position.getX(), this.target.position.getY(), 3.0, this.getTime());
        risk += 100.0 / Math.pow(this.position.distance(predict.getX(), predict.getX()), 2.0);
        while (e.hasMoreElements()) {
            Enemy temp = (Enemy)e.nextElement();
            if (!temp.isAlive) continue;
            risk += temp.getGravity(destination) * Math.abs(this.target.getAdvancingVelocity(destination));
        }
        return risk += 50.0 / Math.pow(this.position.distance(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0), 2.0);
    }

    void goTo(Point2D destination) {
        double angle = Utils.normalRelativeAngle((double)(this.absoluteBearing(this.position, destination) - this.getHeadingRadians()));
        double turnAngle = Math.atan(Math.tan(angle));
        this.setTurnRightRadians(turnAngle);
        this.setAhead(this.position.distance(destination) * (double)(angle == turnAngle ? 1 : -1));
    }

    public void doRadar() {
        this.setTurnRadarRightRadians(Math.PI * 2);
    }

    public Rectangle2D fieldRectangle(double margin) {
        return new Rectangle2D.Double(margin, margin, this.getBattleFieldWidth() - margin * 2.0, this.getBattleFieldHeight() - margin * 2.0);
    }

    public Point2D vectorToLocation(double angle, double length, Point2D sourceLocation) {
        return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
    }

    public double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    public void onCustomEvent(CustomEvent e) {
        if (e.getCondition() instanceof Shoot) {
            Shoot temp = (Shoot)e.getCondition();
            this.setFire(this.firePower);
        }
    }

    public int sign(double value) {
        if (value < 0.0) {
            return -1;
        }
        return 1;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Enemy en;
        this.found = true;
        if (this.targets.containsKey(e.getName())) {
            en = (Enemy)this.targets.get(e.getName());
        } else {
            en = new Enemy();
            this.targets.put(e.getName(), en);
            if (!patterns.containsKey(e.getName())) {
                patterns.put(e.getName(), new MeleePM());
            }
        }
        en.update(e, this);
        MeleePM pm = (MeleePM)patterns.get(en.name);
        pm.updateInfo(en);
        if (!this.target.isAlive || en.distance < 0.9 * this.target.distance) {
            this.target = en;
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        ++bulletsHit;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.target.bulletVelocity = e.getVelocity();
    }

    public void onRobotDeath(RobotDeathEvent e) {
        Enemy en = (Enemy)this.targets.get(e.getName());
        en.isAlive = false;
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        this.out.println("skipped");
    }

    public void onWin(WinEvent e) {
        this.atEnd();
    }

    public void onDeath(DeathEvent e) {
        this.atEnd();
    }

    public void atEnd() {
        Object temp;
        Enumeration e = new Vector(patterns.values()).elements();
        Genghis.me.next_sample_time = 0.0;
        while (e.hasMoreElements()) {
            temp = (MeleePM)e.nextElement();
            ((MeleePM)temp).next_sample_time = 0.0;
            patterns.put(((MeleePM)temp).name, temp);
        }
        e = this.targets.elements();
        while (e.hasMoreElements()) {
            temp = (Enemy)e.nextElement();
            ((Enemy)temp).reset();
        }
    }
}

