/*
 * Decompiled with CFR 0.152.
 */
package ahr.ice.Math;

import ahr.ice.AHRBot;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.Vector;
import robocode.annotation.SafeStatic;

public class PointGenerator {
    @SafeStatic
    public static AHRBot r;
    @SafeStatic
    public static Rectangle2D.Double battlefield;
    static Point2D.Double bottomLeft;
    static Point2D.Double bottomRight;
    static Point2D.Double topLeft;
    static Point2D.Double topRight;

    public Point2D.Double generatePoint(Rectangle2D.Double rect) {
        Point2D.Double p = new Point2D.Double();
        p.x = this.random(rect.getX(), rect.getX() + rect.getWidth());
        p.y = this.random(rect.getY(), rect.getY() + rect.getHeight());
        return p;
    }

    public Iterator generatePoints(int number) {
        Vector<Point2D.Double> points = new Vector<Point2D.Double>();
        points.add(bottomLeft);
        points.add(bottomRight);
        points.add(topLeft);
        points.add(topRight);
        for (int i = 0; i < number; ++i) {
            points.add(this.generatePoint(battlefield));
        }
        return points.iterator();
    }

    public Iterator generatePoints(Point2D.Double m) {
        Vector<Point2D.Double> points = new Vector<Point2D.Double>();
        int numPoints = 4;
        double pointAngle = 360 / numPoints;
        double pointDistance = 150.0;
        for (int c = 0; c <= numPoints; ++c) {
            Point2D.Double p = new Point2D.Double();
            p.x = r.getY() + Math.sin(Math.toRadians(90 * c)) * pointDistance;
            p.y = r.getX() + Math.cos(Math.toRadians(90 * c)) * pointDistance;
            points.add(p);
        }
        PointGenerator.r.out.println(points.size());
        Iterator i = points.iterator();
        return i;
    }

    public double random(double min, double max) {
        return min + Math.random() * (max - min);
    }

    public PointGenerator(AHRBot r, Rectangle2D.Double battlefield) {
        PointGenerator.r = r;
        PointGenerator.battlefield = battlefield;
        bottomRight = new Point2D.Double(battlefield.getX() + battlefield.getWidth(), 20.0);
        topLeft = new Point2D.Double(20.0, battlefield.getY() + battlefield.getHeight());
        topRight = new Point2D.Double(battlefield.getX() + battlefield.getWidth(), battlefield.getY() + battlefield.getHeight());
    }

    static {
        bottomLeft = new Point2D.Double(20.0, 20.0);
    }
}

