/*
 * Decompiled with CFR 0.152.
 */
package pedersen.systems;

import pedersen.core.Constraints;
import pedersen.core.Conversions;
import pedersen.core.Targetable;
import pedersen.misc.Host;
import pedersen.misc.Metrics;
import pedersen.physics.StaticPosition;
import pedersen.systems.FireControlBase;

public class FireControlStandardImpl
extends FireControlBase {
    public double getBulletVelocity(StaticPosition firingPosition, Targetable target) {
        double bulletVelocity = 0.0;
        double firepower = 2.499999;
        if (firingPosition.getDistance(target) < 75.0) {
            firepower = 3.0;
        } else if (Metrics.getFiredShotCount() < 5L) {
            firepower = 0.1;
        } else if (Host.singleton.getActiveEnemyCount() > 4) {
            firepower = 3.0;
        } else if (target.getEnergy() < 4.0) {
            firepower = 0.1;
        } else if (target.getEnergy() < 8.0) {
            firepower = 0.5;
        } else if (target.getEnergy() < 16.0) {
            firepower = 1.0;
        }
        if (Constraints.isFirepowerLegal(firepower)) {
            bulletVelocity = Conversions.getBulletVelocityFromFirepower(firepower);
        }
        return bulletVelocity;
    }

    public boolean isFiringAdvisable(Targetable target, double firepower) {
        boolean fire = true;
        double combatantEnergy = Host.singleton.getEnergy();
        double combatantFutureEnergy = combatantEnergy - firepower;
        if (Host.singleton.isInDuelMode() && combatantFutureEnergy < target.getEnergy() && target.getEnergy() < combatantEnergy) {
            fire = false;
        }
        if (combatantFutureEnergy < 2.0) {
            fire = false;
        }
        return fire;
    }
}

