/*
 * Decompiled with CFR 0.152.
 */
package reaper;

import reaper.Enemy;
import reaper.Methods;
import reaper.Reaper;

public class VirtualBullet {
    private double originX;
    private double originY;
    private double angle;
    private double speed;
    private double timeFired;
    private int fireMode;
    private String target;
    private Enemy startScan;
    private Reaper r;

    public boolean doneTravelling(long time) {
        double targetY;
        double distanceTravelled = ((double)time - this.timeFired) * this.speed;
        double targetX = this.r.getEnemy(this.target).getX();
        double targetDistance = Methods.getDistance(this.originX, this.originY, targetX, targetY = this.r.getEnemy(this.target).getY());
        return targetDistance <= distanceTravelled;
    }

    public double timeTillHit() {
        return ((double)this.r.getTime() - (Methods.getDistance(this.originX, this.originY, this.r.getX(), this.r.getY()) / this.speed + this.timeFired)) * -1.0;
    }

    public boolean hit() {
        double targetX = this.r.getEnemy(this.target).getX();
        double targetY = this.r.getEnemy(this.target).getY();
        double targetAngle = Methods.absoluteBearing(this.originX, this.originY, targetX, targetY);
        if (this.fireMode == 0) {
            this.r.addBearing(Methods.normalizeRelatief(targetAngle - this.angle), this.startScan);
        }
        return Math.toRadians(this.angle) - Math.toRadians(targetAngle) > -1.0 * Math.atan(36.0 / Methods.getDistance(this.originX, this.originY, targetX, targetY)) && Math.toRadians(targetAngle) - Math.toRadians(this.angle) >= -1.0 * Math.atan(36.0 / Methods.getDistance(this.originX, this.originY, targetX, targetY));
    }

    public boolean hitMe(double targetX, double targetY) {
        double targetAngle = Methods.absoluteBearing(this.originX, this.originY, targetX, targetY);
        return Math.toRadians(this.angle) - Math.toRadians(targetAngle) > -1.0 * Math.atan(36.0 / Methods.getDistance(this.originX, this.originY, targetX, targetY)) && Math.toRadians(targetAngle) - Math.toRadians(this.angle) >= -1.0 * Math.atan(36.0 / Methods.getDistance(this.originX, this.originY, targetX, targetY));
    }

    public double getXPosition(double time) {
        double distanceTravelled = (time - this.timeFired) * this.speed;
        return distanceTravelled * Math.cos(Math.toRadians(this.angle - 90.0));
    }

    public double getYPosition(double time) {
        double distanceTravelled = (time - this.timeFired) * this.speed;
        return distanceTravelled * Math.sin(Math.toRadians(this.angle + 90.0));
    }

    public String getTarget() {
        return this.target;
    }

    public int getFireMode() {
        return this.fireMode;
    }

    public VirtualBullet(double originX, double originY, double angle, double firePower, int fireMode, String target, long time, Reaper r) {
        this.originX = originX;
        this.originY = originY;
        this.angle = angle;
        if (firePower > (double)3) {
            firePower = 3;
        }
        this.speed = 20.0 - firePower * (double)3;
        this.target = target;
        this.fireMode = fireMode;
        this.timeFired = time;
        this.r = r;
        this.startScan = r.getEnemy(target);
    }
}

