/*
 * Decompiled with CFR 0.152.
 */
package ustimaw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.MessageEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.RobotStatus;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;
import robocode.TeamRobot;
import robocode.util.Utils;
import ustimaw.CircularPredictor;
import ustimaw.EnemyStatus;
import ustimaw.GunManager;
import ustimaw.LinearTargeting;
import ustimaw.MessageType;
import ustimaw.MinimumRiskMovement;
import ustimaw.MinimumRiskMovement2;
import ustimaw.Movement;
import ustimaw.Pair;
import ustimaw.Position;
import ustimaw.Prediction;
import ustimaw.RadarManager;
import ustimaw.Score;
import ustimaw.Wave;

public class Nightmare
extends TeamRobot {
    private TreeSet<String> teammatesName;
    final HashMap<String, RobotStatus> teammates = new HashMap();
    final HashMap<String, EnemyStatus> enemys = new HashMap();
    private final HashSet<String> dead = new HashSet();
    private final HashSet<String> suspend = new HashSet();
    String target;
    private String radarTarget;
    private double fieldHeight;
    private double fieldWidth;
    private Graphics2D graphics;
    private final HashMap<String, CircularPredictor> predictor = new HashMap();
    private final HashSet<String> droid = new HashSet();
    private Wave wave;
    private static String enemyLeader;
    private final MinimumRiskMovement mrm = new MinimumRiskMovement();
    boolean isIndependent = false;
    private final GunManager gunManager = new GunManager(this);
    private final double thresholdEnergy = 35.0;
    private final double passiveEnergy = 0.0;
    private static Score score;
    private static ArrayList<Score> scores;
    private static ArrayList<Pair<Score, Integer>> scorePair;
    private final RadarManager radarManager = new RadarManager();
    private boolean isLeader;
    private static int flag;
    private final Movement movement = new MinimumRiskMovement2();
    private StatusEvent statusEvent;
    private double mv = 8.0;
    static final double NORMALMINUTE;

    static {
        scores = new ArrayList();
        scorePair = new ArrayList();
        flag = 0;
        NORMALMINUTE = Nightmare.getNormalMinute();
    }

    public void run() {
        this.fieldHeight = this.getBattleFieldHeight();
        this.fieldWidth = this.getBattleFieldWidth();
        this.graphics = this.getGraphics();
        double w = this.getBattleFieldWidth();
        double h = this.getBattleFieldHeight();
        Point2D.Double c = new Point2D.Double(w / 2.0, h / 2.0);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.teammatesName = this.getTeammates() == null ? new TreeSet() : new TreeSet<String>(Arrays.asList(this.getTeammates()));
        this.teammatesName.add(this.getName());
        this.setAllColors(Color.RED);
        this.setTurnRight(999.0);
        this.setTurnGunRight(999.0);
        this.setTurnRadarRight(999.0);
        boolean bl = this.isLeader = this.getEnergy() > 150.0;
        if (this.getRoundNum() != 0) {
            scorePair.add(new Pair<Score, Integer>(score, flag));
            try {
                this.broadcastMessage(score);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        score = new Score();
        if (this.getRoundNum() == 0) {
            this.onGotScore();
        }
        while (true) {
            if (!this.isModeA()) {
                this.doRadar();
                this.mrm.update(this);
                if (this.isIndependent) {
                    this.selectTarget();
                    this.mrm.move(this, new Point2D.Double[0]);
                }
                this.target();
                if (this.isCaptain() && this.teammates.size() == this.teammatesName.size() - 1) {
                    this.assign();
                }
            } else {
                this.radarManager.doRadar(this);
                this.selectTarget();
                this.movement.update(this);
                this.movement.move(this);
                this.gunManager.update(this);
                if (this.target != null) {
                    double p = Math.min(this.getEnergy() * 0.1, 3.0);
                    p = Math.min(p, this.getEnergyNeed(this.enemys.get((Object)this.target).sre.getEnergy()));
                    p = Math.max(p, 0.1);
                    this.setGunAngle(this.gunManager.getAngle(p));
                    if (this.getGunHeat() == 0.0 && Math.abs(this.getGunTurnRemainingRadians()) < 1.0 && this.getEnergy() - p > 0.1) {
                        this.setFire(p);
                        this.gunManager.fire(this, p);
                    }
                }
            }
            this.execute();
        }
    }

    public long getTime() {
        return this.statusEvent.getTime();
    }

    private boolean isModeA() {
        return flag == 1;
    }

    private void selectTarget() {
        String[] e = this.getLivingEnemys();
        double m = Double.POSITIVE_INFINITY;
        String[] stringArray = e;
        int n = e.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            double c = this.enemys.get(s).getPoint().distanceSq(this.getPosition());
            if (c < m) {
                m = c;
                this.target = s;
            }
            ++n2;
        }
    }

    private void radarLock(String s) {
        if (this.getTime() - this.enemys.get((Object)s).sre.getTime() > 0L) {
            double r = this.getRadarTurnRemaining();
            if (r != 0.0) {
                this.setTurnRadarRight(r * Double.POSITIVE_INFINITY);
            } else {
                this.setTurnRadarRight(999.0);
            }
        } else {
            Position e = this.linearPredict(s, 1.0);
            double rhr = this.getRadarHeadingRadians();
            double a = Utils.normalRelativeAngle((double)(e.sub(this.zzzgetPoint()).arg() - rhr));
            this.drawLine(this.getPosition(), this.getPosition().add(Position.polar(200.0, rhr + Rules.RADAR_TURN_RATE_RADIANS)));
            this.drawLine(this.getPosition(), this.getPosition().add(Position.polar(200.0, rhr - Rules.RADAR_TURN_RATE_RADIANS)));
            this.graphics.setColor(Color.yellow);
            this.drawLine(this.getPosition(), this.getPosition().add(Position.polar(200.0, rhr)));
            this.setTurnRadarRightRadians(a + (a > 0.0 ? Rules.RADAR_TURN_RATE_RADIANS / 2.0 : -Rules.RADAR_TURN_RATE_RADIANS / 2.0));
            this.drawLine(this.getPosition(), this.getPosition().add(Position.polar(200.0, rhr + this.getRadarTurnRemainingRadians())));
        }
    }

    double getClosest(String[] s) {
        double m = Double.POSITIVE_INFINITY;
        String[] stringArray = s;
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            m = Math.min(m, this.getPosition().distanceSq(this.nameToPosition(t)));
            ++n2;
        }
        return m;
    }

    private void drawLine(Point2D.Double a, Point2D.Double b) {
        this.graphics.drawLine((int)a.x, (int)a.y, (int)b.x, (int)b.y);
    }

    private void doRadar() {
        if (this.getLivingEnemys().length == 1) {
            this.radarLock(this.getLivingEnemys()[0]);
        } else if (this.radarTarget == null || this.isIndependent) {
            this.radarManager.doRadar(this);
        } else {
            this.radarLock(this.radarTarget);
        }
    }

    private double getEnergyNeed(double e) {
        double eps = 1.0E-5;
        return eps + (e > 8.0 ? (e + 2.0) / 6.0 : e / 4.0);
    }

    private void linearTargeting(double p) {
        int i = 0;
        while (true) {
            Position pt;
            if ((pt = this.linearPredict(this.target, i)).distance(this.zzzgetPoint()) < Rules.getBulletSpeed((double)p) * (double)i) {
                this.setGun(pt);
                return;
            }
            ++i;
        }
    }

    private void circularTargeting(double p) {
        Prediction pr = this.predictor.get(this.target).getPrediction((Robot)this);
        int i = 0;
        while (true) {
            Position pt = this.insidePoint(pr.getPosition());
            this.printCircle(pt, 5, Color.blue);
            if (pt.distance(this.zzzgetPoint()) < Rules.getBulletSpeed((double)p) * (double)i) {
                this.setGun(pt);
                return;
            }
            pr.advance();
            ++i;
        }
    }

    private void quickGFT(double p) {
        if (this.target != null && this.wave != null) {
            Position pos = this.linearPredict(this.target, 0.0);
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(pos.sub(this.zzzgetPoint()).arg() - this.getGunHeadingRadians() + pos.sub(this.wave.position).arg() - this.wave.angle)));
        } else {
            this.linearTargeting(p);
        }
    }

    private double getRobotDistance(Point2D.Double a, Point2D.Double b) {
        double[] x = new double[]{18.0, 18.0, -18.0, -18.0};
        double[] y = new double[]{18.0, -18.0, -18.0, 18.0};
        double m = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < 4) {
            Line2D.Double l = new Line2D.Double(a.x + x[i], a.y + y[i], a.x + x[(i + 1) % 4], a.y + y[(i + 1) % 4]);
            int j = 0;
            while (j < 4) {
                m = Math.min(m, l.ptSegDist(b.x + x[j], b.y + y[j]));
                ++j;
            }
            ++i;
        }
        return m;
    }

    private void target() {
        if (this.target == null) {
            return;
        }
        double p = 2.49;
        double n = 2.0;
        double aa = 3.0 * Math.pow(270.0, n);
        p = aa / Math.pow(this.linearPredict(this.target, 0.0).distance(this.getPosition()), n);
        p = Math.min(p, this.getEnergy() * 0.1);
        p = Math.min(p, this.getEnergyNeed(this.enemys.get((Object)this.target).sre.getEnergy()));
        p = Math.min(p, this.getEnergy() - 0.1);
        double a = new LinearTargeting().getAngle(this, p);
        this.getGunHeat();
        this.setGunAngle(a);
        if (!this.isFriendlyFire() && Math.abs(this.getGunTurnRemainingRadians()) < 1.2 && this.getGunHeat() == 0.0 && this.getEnergy() - Math.max(0.1, p) > 0.1) {
            this.setFire(p);
        }
    }

    private double getInnerAngle(String e, ArrayList<String> t) {
        double[] a = new double[t.size()];
        int i = 0;
        while (i < t.size()) {
            a[i] = this.getTeammatePosition(t.get(i)).sub(this.linearPredict(e, 0.0)).arg();
            ++i;
        }
        Arrays.sort(a);
        double m = 0.0;
        int i2 = 0;
        while (i2 < a.length) {
            m = Math.max(m, Utils.normalAbsoluteAngle((double)(a[(i2 + 1) % a.length] - a[i2])));
            ++i2;
        }
        return Math.PI * 2 - m;
    }

    private void assign22(String en, String[] t) {
        double pt = 5.0;
        Position ep = this.linearPredict(en, pt);
        double m = Double.POSITIVE_INFINITY;
        Position[] mp = null;
        int i = 0;
        while (i < 4) {
            int j = (i + 2) % 4;
            double[] dx = new double[]{0.0, 1.0, 0.0, -1.0};
            double[] dy = new double[]{1.0, 0.0, -1.0, 0.0};
            double w = 40.0;
            Position[] positions = new Position[]{new Position(ep.x + w * dx[i], ep.y + w * dy[i]), new Position(ep.x + w * dx[j], ep.y + w * dy[j])};
            double c = this.getTeammatePosition(t[0]).distanceSq(positions[0]) + this.getTeammatePosition(t[1]).distanceSq(positions[1]);
            if (c < m) {
                m = c;
                mp = positions;
            }
            ++i;
        }
        i = 0;
        while (i < 2) {
            try {
                this.sendMessage(t[i], mp[i]);
                this.sendMessage(t[i], (Serializable)((Object)en));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
    }

    private void assign2(String en, String[] t) {
        double pt = 5.0;
        Position ep = this.linearPredict(en, pt);
        double a0 = this.getTeammatePosition(t[0]).sub(ep).arg();
        double a1 = this.getTeammatePosition(t[1]).sub(ep).arg();
        double m1 = (a0 + a1) / 2.0;
        double m2 = m1 + Math.PI;
        double m = Math.abs(Utils.normalRelativeAngle((double)(a0 - m1))) < Math.abs(Utils.normalRelativeAngle((double)(a0 - m2))) ? m1 : m2;
        double[] ang = new double[2];
        double a = 1.5707963267948966;
        this.printCircle(ep, 10, Color.magenta);
        this.getGraphics().drawLine((int)ep.x, (int)ep.y, (int)(ep.x + 100.0 * Math.sin(m)), (int)(ep.y + 100.0 * Math.cos(m)));
        if (Utils.normalRelativeAngle((double)(a0 - m)) > 0.0) {
            ang[0] = m + a;
            ang[1] = m - a;
        } else {
            ang[0] = m - a;
            ang[1] = m + a;
        }
        double r = Math.min(ep.distance(this.getTeammatePosition(t[0])), ep.distance(this.getTeammatePosition(t[1]))) * 0.6;
        int i = 0;
        while (i < 2) {
            try {
                Position d = ep.add(this.polar(r, ang[i]));
                this.printCircle(d, 10, Color.cyan);
                this.sendMessage(t[i], d);
                this.sendMessage(t[i], (Serializable)((Object)en));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
    }

    private void assign() {
        Assigner a = new Assigner();
        for (String en : this.enemys.keySet()) {
            int i;
            boolean assignedRadar = false;
            if (this.dead.contains(en)) continue;
            ArrayList<String> al = new ArrayList<String>();
            int i2 = 0;
            while (i2 < this.teammatesName.size()) {
                String tn = this.teammatesName.toArray(new String[0])[i2];
                if (!this.dead.contains(tn)) {
                    if (a.r == null) {
                        this.out.println(String.valueOf(en) + ":" + tn);
                    }
                    if (en.equals(a.r.get(tn))) {
                        Pair<MessageType, Object> p;
                        al.add(tn);
                        if (!assignedRadar && !this.droid.contains(tn)) {
                            assignedRadar = true;
                            p = new Pair<MessageType, String>(MessageType.RADAR, en);
                        } else {
                            p = new Pair<MessageType, Object>(MessageType.RADAR, null);
                        }
                        try {
                            this.sendMessage(tn, p);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                ++i2;
            }
            al.size();
            al.size();
            double avg = 0.0;
            double min = Double.POSITIVE_INFINITY;
            for (String s : al) {
                double d = this.getTeammatePosition(s).distance(this.enemys.get(en).getPoint());
                avg += d / (double)al.size();
                min = Math.min(min, d);
            }
            double r = min * 0.74;
            int[] p = new int[al.size()];
            int i3 = 0;
            while (i3 < p.length) {
                p[i3] = i3;
                ++i3;
            }
            Point2D.Double[] ap = new Point2D.Double[p.length];
            double m = Double.POSITIVE_INFINITY;
            int pr = 9;
            double pt = 5.0;
            Position ep = this.linearPredict(en, pt);
            Pair<Double, Double> arc = this.getInsideArc(ep, r);
            this.printCircle(this.add(ep, this.polar(r, (Double)arc.first)), 10, Color.yellow);
            this.printCircle(this.add(ep, this.polar(r, (Double)arc.second)), 10, Color.yellow);
            double ga = Math.min(Math.PI * 2 / (double)p.length, ((Double)arc.second - (Double)arc.first) / (double)(p.length - 1));
            double aap = 0.45;
            double rn = al.size() == 1 ? 0.0 : Math.min(ga, this.getInnerAngle(en, al) / (double)(al.size() - 1) + 1.0);
            double b = ((Double)arc.second - (Double)arc.first - rn * (double)(al.size() - 1)) / (double)pr;
            HashMap<String, Double> te = new HashMap<String, Double>();
            te.put(this.getName(), this.getEnergy());
            for (String t : this.teammates.keySet()) {
                te.put(t, this.teammates.get(t).getEnergy());
            }
            do {
                i = 0;
                while (i < pr) {
                    Point2D.Double[] d = new Point2D.Double[p.length];
                    int j = 0;
                    while (j < p.length) {
                        int x = p[j];
                        double cr = r;
                        ((Double)te.get(al.get(x))).doubleValue();
                        this.enemys.get((Object)en).sre.getEnergy();
                        d[x] = this.add(ep, this.polar(cr, rn * (double)j + b * (double)i + (Double)arc.first));
                        ++j;
                    }
                    double cr = 0.0;
                    int j2 = 0;
                    while (j2 < d.length) {
                        cr += d[j2].distanceSq(this.getTeammatePosition(al.get(j2)));
                        ++j2;
                    }
                    if (cr < m) {
                        ap = d;
                        m = cr;
                    }
                    ++i;
                }
            } while (this.nextPermutation(p));
            i = 0;
            while (i < ap.length) {
                try {
                    this.sendMessage(al.get(i), (Serializable)((Object)en));
                    if (this.getTeammatePosition(al.get(i)).distance(this.getCurrentEnemyPosition(en)) < avg * 0.0) {
                        this.sendMessage(al.get(i), (Serializable)((Object)MessageType.ALONE));
                    } else {
                        this.sendMessage(al.get(i), ap[i]);
                    }
                }
                catch (IOException e) {
                    this.out.println("catch");
                }
                ++i;
            }
        }
    }

    private boolean nextPermutation(int[] a) {
        int i = a.length - 2;
        while (i >= 0) {
            if (a[i] < a[i + 1]) break;
            --i;
        }
        if (i < 0) {
            return false;
        }
        int n = i + 1;
        int j = i + 2;
        while (j < a.length) {
            if (a[i] < a[j] && a[j] < a[n]) {
                n = j;
            }
            ++j;
        }
        int t = a[i];
        a[i] = a[n];
        a[n] = t;
        Arrays.sort(a, i + 1, a.length);
        return true;
    }

    private Pair<Double, Double> getInsideArc(Point2D.Double p, double r) {
        int pr = 128;
        double u = Math.PI * 2 / (double)pr;
        int b = 0;
        while (b < pr) {
            if (!this.isInside(this.add(p, this.polar(r, u * (double)b)))) break;
            ++b;
        }
        if (b == pr) {
            return new Pair<Double, Double>(0.0, Math.PI * 2);
        }
        double ub = u * (double)b;
        int l = 0;
        int f = 0;
        int cf = 0;
        int i = 0;
        while (i < pr) {
            Point2D.Double c = this.add(p, this.polar(r, (double)i * u + ub));
            Point2D.Double n = this.add(p, this.polar(r, (double)(i + 1) * u + ub));
            if (!this.isInside(c) && this.isInside(n)) {
                cf = i + 1;
            } else if (this.isInside(c) && !this.isInside(n) && i - cf > l - f) {
                l = i;
                f = cf;
            }
            ++i;
        }
        return new Pair<Double, Double>((double)(f + b) * u, (double)(l + b) * u);
    }

    private void setGun(Point2D.Double p) {
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(Math.atan2(p.x - this.getX(), p.y - this.getY()) - this.getGunHeadingRadians())));
    }

    private void setGunAngle(double a) {
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(a - this.getGunHeadingRadians())));
    }

    Point2D.Double zzzgetPoint() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    Position getPosition() {
        return new Position(this.statusEvent.getStatus().getX(), this.statusEvent.getStatus().getY());
    }

    Position getCurrentEnemyPosition(String s) {
        return this.linearPredict(s, 0.0);
    }

    String[] getActiveTeammates() {
        ArrayList<String> a = new ArrayList<String>();
        for (String s : this.teammatesName) {
            if (this.suspend.contains(s) || this.dead.contains(s)) continue;
            a.add(s);
        }
        return a.toArray(new String[0]);
    }

    String[] getLivingEnemys() {
        ArrayList<String> a = new ArrayList<String>();
        for (String s : this.enemys.keySet()) {
            if (this.dead.contains(s)) continue;
            a.add(s);
        }
        return a.toArray(new String[0]);
    }

    String[] getLivingAllTeammates() {
        if (this.getEnergy() == 0.0) {
            return this.getLivingOtherTeammates();
        }
        return this.concat(this.getLivingOtherTeammates(), {this.getName()});
    }

    String[] getLivingOtherTeammates() {
        ArrayList<String> a = new ArrayList<String>();
        for (String s : this.teammatesName) {
            if (this.dead.contains(s) || s.equals(this.getName())) continue;
            a.add(s);
        }
        return a.toArray(new String[0]);
    }

    String[] getLivingOthers() {
        return this.concat(this.getLivingOtherTeammates(), this.getLivingEnemys());
    }

    String[] getLiving() {
        return this.concat(this.getLivingOthers(), {this.getName()});
    }

    private String[] concat(String[] ... a) {
        ArrayList<String> al = new ArrayList<String>();
        String[][] stringArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            String[] t;
            String[] stringArray2 = t = stringArray[n2];
            int n3 = t.length;
            int n4 = 0;
            while (n4 < n3) {
                String u = stringArray2[n4];
                al.add(u);
                ++n4;
            }
            ++n2;
        }
        return al.toArray(new String[al.size()]);
    }

    Position nameToPosition(String s) {
        if (this.getName().equals(s)) {
            return this.getPosition();
        }
        if (this.teammates.containsKey(s)) {
            return new Position(this.teammates.get(s).getX(), this.teammates.get(s).getY());
        }
        if (this.enemys.containsKey(s)) {
            return this.enemys.get(s).getPoint();
        }
        return new Position(0.0, 0.0);
    }

    void updateEnemy(EnemyStatus e) {
        String n = e.sre.getName();
        this.enemys.put(n, e);
        if (!this.predictor.containsKey(n)) {
            this.predictor.put(n, new CircularPredictor());
        }
        this.predictor.get(n).update(e);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (!this.teammatesName.contains(e.getName())) {
            if (this.getTime() < 30L && e.getEnergy() > 150.0) {
                enemyLeader = e.getName();
            }
            EnemyStatus es = new EnemyStatus(this, e);
            this.updateEnemy(es);
            try {
                this.broadcastMessage(es);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.radarManager.Scan(e);
    }

    private void addSuspend(String s) {
        this.suspend.add(s);
    }

    public void onMessageReceived(MessageEvent e) {
        Serializable mes = e.getMessage();
        if (e.getMessage() instanceof EnemyStatus) {
            this.updateEnemy((EnemyStatus)e.getMessage());
        } else if (e.getMessage() instanceof RobotStatus) {
            this.teammates.put(e.getSender(), (RobotStatus)e.getMessage());
        } else if (e.getMessage() instanceof Point2D.Double) {
            Position p = this.insidePoint((Point2D.Double)e.getMessage());
            if (!this.isIndependent) {
                String[] al;
                if (this.getEnergy() < 0.0) {
                    Position t = this.getCurrentEnemyPosition(this.target);
                    al = this.getLivingOthers();
                } else {
                    al = this.getLivingOtherTeammates();
                }
                this.setGoTo(p, al);
            }
        } else if (e.getMessage() instanceof String) {
            this.target = (String)((Object)e.getMessage());
        } else if (e.getMessage() instanceof Pair) {
            this.radarTarget = (String)((Pair)e.getMessage()).second;
        } else if (e.getMessage() instanceof MessageType) {
            if (((MessageType)((Object)mes)).equals((Object)MessageType.SUSPEND)) {
                this.addSuspend(e.getSender());
            }
            if (((MessageType)((Object)mes)).equals((Object)MessageType.DROID)) {
                this.droid.add(e.getSender());
            } else if (((MessageType)((Object)mes)).equals((Object)MessageType.ALONE)) {
                this.mrm.move(this, new Point2D.Double[0]);
            }
        } else if (mes instanceof Score) {
            Score s = (Score)Nightmare.scorePair.get((int)(Nightmare.scorePair.size() - 1)).first;
            s.update((Score)mes);
            if (s.nupdates == this.getTeammates().length) {
                this.onGotScore();
            }
        } else {
            this.out.printf("%s:%s\n", e.getSender(), e.getMessage());
        }
    }

    private boolean isFriendlyFire() {
        double r = this.getPosition().distance(this.getCurrentEnemyPosition(this.target));
        Line2D.Double l = new Line2D.Double(this.getPosition(), this.getPosition().add(Position.polar(r, this.getGunHeadingRadians())));
        String[] stringArray = this.getLivingOtherTeammates();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (l.intersects(this.createRectangle(this.getTeammatePosition(s), 54.0))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void onGotScore() {
        int nog = 3;
        boolean noa = true;
        if (this.getRoundNum() < 3) {
            flag = 0;
        } else if (this.getRoundNum() < 4) {
            flag = 1;
        } else {
            int[] n = new int[2];
            double[] s = new double[2];
            for (Pair<Score, Integer> p : scorePair) {
                int n2 = (Integer)p.second;
                n[n2] = n[n2] + 1;
                int n3 = (Integer)p.second;
                s[n3] = s[n3] + ((Score)p.first).getPercent();
            }
            flag = s[0] / (double)n[0] > s[1] / (double)n[1] ? 0 : 1;
        }
        flag = 0;
        this.out.println("nognoa31");
        this.out.println(flag);
    }

    public String[] getTeammates() {
        String[] strings = super.getTeammates();
        return strings == null ? new String[]{} : strings;
    }

    public void onStatus(StatusEvent e) {
        this.statusEvent = e;
        try {
            this.broadcastMessage((Serializable)e.getStatus());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Rectangle2D.Double createRectangle(Point2D.Double p, double size) {
        return new Rectangle2D.Double(p.x - size / 2.0, p.y - size / 2.0, size, size);
    }

    private Rectangle2D.Double createRobot(Point2D.Double p) {
        int size = 36;
        this.graphics.setColor(Color.white);
        return this.createRectangle(p, 36.0);
    }

    private boolean hits(Position p, String[] a) {
        Rectangle2D.Double r = this.createRobot(p);
        String[] stringArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            String ap = stringArray[n2];
            if (r.intersects(this.createRobot(this.nameToPosition(ap)))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    void setGoTo(Position p, String[] al) {
        boolean frontHit = this.hits(this.getPosition().add(Position.polar(1.0, this.getHeadingRadians())), al);
        boolean backHit = this.hits(this.getPosition().add(Position.polar(-1.0, this.getHeadingRadians())), al);
        if (frontHit || backHit) {
            this.out.println("mv" + this.mv);
        }
        if (!frontHit || !backHit) {
            if (frontHit) {
                this.setBack(99.0);
            } else if (backHit) {
                this.setAhead(99.0);
            } else {
                p = this.avoidHit(p, al);
                double fr = Math.atan2(p.x - this.getX(), p.y - this.getY()) - this.getHeadingRadians();
                boolean fw = Math.cos(fr) > 0.0;
                double r = Utils.normalRelativeAngle((double)(fw ? fr : fr + Math.PI));
                this.setTurnRightRadians(r);
                this.mv = Math.abs(r) > 0.9424777960769379 ? 1 : 9;
                this.setMaxVelocity(this.mv);
                this.setAhead(this.argDist(p, this.zzzgetPoint(), this.getHeadingRadians()));
                this.printCircle(p, 10, Color.green);
                this.getGraphics().drawLine((int)this.getX(), (int)this.getY(), (int)p.x, (int)p.y);
            }
        }
    }

    void setGoTo(Point2D.Double p) {
        this.out.println("dpr");
        double fr = Math.atan2(p.x - this.getX(), p.y - this.getY()) - this.getHeadingRadians();
        boolean fw = Math.cos(fr) > 0.0;
        double r = Utils.normalRelativeAngle((double)(fw ? fr : fr + Math.PI));
        this.setTurnRightRadians(r);
        this.setMaxVelocity(Math.max(0.0, -7.0625 * Math.abs(r) + 8.1287));
        this.setAhead(this.argDist(p, this.zzzgetPoint(), this.getHeadingRadians()));
        this.printCircle(p, 10, Color.green);
        this.getGraphics().drawLine((int)this.getX(), (int)this.getY(), (int)p.x, (int)p.y);
    }

    private double argDist(Point2D.Double t, Point2D.Double f, double a) {
        Point2D.Double v = this.sub(t, f);
        return this.abs(v) * Math.cos(a - this.arg(v));
    }

    Position avoidHit(Position p, String[] ap) {
        int n = 99;
        double m = Double.POSITIVE_INFINITY;
        Position d = p;
        int i = 0;
        while (i < n) {
            block5: {
                double a = Math.PI * 2 * (double)i / (double)n;
                Position c = this.getPosition().add(Position.polar(this.argDist(p, this.getPosition(), a), a));
                if (this.isInside(c)) {
                    Line2D.Double l = new Line2D.Double(this.zzzgetPoint(), c);
                    String[] stringArray = ap;
                    int n2 = ap.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        String s = stringArray[n3];
                        Position cp = this.nameToPosition(s);
                        double x = cp.x;
                        double sz = 72.0;
                        double y = cp.y;
                        if (!new Rectangle2D.Double(x - sz / 2.0, y - sz / 2.0, sz, sz).intersectsLine(l)) {
                            ++n3;
                            continue;
                        }
                        break block5;
                    }
                    this.printCircle(c, 4, Color.white);
                    if (m > c.distance(p)) {
                        m = c.distance(p);
                        d = c;
                    }
                }
            }
            ++i;
        }
        return d;
    }

    void printCircle(Point2D.Double p, int r, Color c) {
        Graphics2D g = this.graphics;
        g.setColor(c);
        g.fillOval((int)Math.round(p.x) - r, (int)Math.round(p.y) - r, r * 2, r * 2);
    }

    void printRectangle(Rectangle2D.Double r) {
        this.graphics.drawRect((int)r.x, (int)r.y, (int)r.width, (int)r.height);
    }

    private Point2D.Double add(Point2D.Double a, Point2D.Double b) {
        return new Point2D.Double(a.x + b.x, a.y + b.y);
    }

    private Point2D.Double sub(Point2D.Double a, Point2D.Double b) {
        return new Point2D.Double(a.x - b.x, a.y - b.y);
    }

    private double abs(Point2D.Double p) {
        return Math.hypot(p.x, p.y);
    }

    private double arg(Point2D.Double p) {
        return Math.atan2(p.x, p.y);
    }

    private Point2D.Double polar(double m, double a) {
        return new Point2D.Double(m * Math.sin(a), m * Math.cos(a));
    }

    private Point2D.Double multiply(Point2D.Double p, double x) {
        return new Point2D.Double(p.x * x, p.y * x);
    }

    public void onDeath(DeathEvent event) {
        this.onRobotDeath(this.getName());
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.onRobotDeath(e.getName());
    }

    private void onRobotDeath(String s) {
        this.dead.add(s);
        score.onRobotDeath(this, s);
    }

    public void onHitRobot(HitRobotEvent e) {
        this.eject();
        score.onHitRobot(this, e);
        if (e.isMyFault()) {
            this.out.println("hit" + this.getEnergy() + "\t" + 0.0);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.eject();
        score.onHitByBullet(this, e);
        if (this.isModeA()) {
            this.movement.onHitByBullet(this, e);
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        score.onBulletHit(this, e);
    }

    private void eject() {
        if (this.getEnergy() < 35.0) {
            this.isIndependent = true;
            try {
                this.broadcastMessage((Serializable)((Object)MessageType.SUSPEND));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.addSuspend(this.getName());
        }
    }

    private double getMaxEnergy() {
        String[] strings = this.getLivingOtherTeammates();
        double m = this.getEnergy();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            m = Math.max(m, this.teammates.get(string).getEnergy());
            ++n2;
        }
        return m;
    }

    boolean isDead(String s) {
        return this.dead.contains(s);
    }

    Position insidePoint(Point2D.Double p) {
        double eps = 1.0E-5;
        return new Position(Math.min(this.fieldWidth - 18.0 - 1.0E-5, Math.max(18.00001, p.x)), Math.min(this.fieldHeight - 18.0 - 1.0E-5, Math.max(18.00001, p.y)));
    }

    Position linearPredict(String en, double t) {
        long time;
        double head;
        Position pos;
        double vel;
        if (this.getName().equals(en)) {
            vel = this.getVelocity();
            pos = this.getPosition();
            head = this.getHeadingRadians();
            time = this.getTime();
        } else if (this.isTeammate(en)) {
            RobotStatus tm = this.teammates.get(en);
            vel = tm.getVelocity();
            pos = this.getTeammatePosition(en);
            head = tm.getHeadingRadians();
            time = tm.getTime();
        } else {
            EnemyStatus e = this.enemys.get(en);
            vel = e.sre.getVelocity();
            pos = e.getPoint();
            head = e.sre.getHeadingRadians();
            time = e.sre.getTime();
        }
        return this.insidePoint(this.add(pos, this.multiply(this.polar(vel, head), t + (double)this.getTime() - (double)time)));
    }

    double getDistanceFromOther(String s) {
        String[] l = this.getLiving();
        double m = Double.POSITIVE_INFINITY;
        String[] stringArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            String o = stringArray[n2];
            if (!o.equals(s) && this.enemys.containsKey(s) && this.enemys.containsKey(o)) {
                m = Math.min(m, this.nameToPosition(o).distance(this.nameToPosition(s)));
            }
            ++n2;
        }
        return m;
    }

    private boolean isCaptain() {
        for (String s : this.teammatesName) {
            if (this.dead.contains(s)) continue;
            return s.equals(this.getName());
        }
        return false;
    }

    boolean isInside(Point2D.Double p) {
        double bh = 18.0;
        double bw = 18.0;
        return bw < p.x && p.x < this.fieldWidth - bw && bh < p.y && p.y < this.fieldHeight - bh;
    }

    private double getTeammateEnergy(String s) {
        return this.getName().equals(s) ? this.getEnergy() : this.teammates.get(s).getEnergy();
    }

    Position getTeammatePosition(String s) {
        double x = 0.0;
        double y = 0.0;
        if (s.equals(this.getName())) {
            x = this.getX();
            y = this.getY();
        } else if (this.teammates.containsKey(s)) {
            x = this.teammates.get(s).getX();
            y = this.teammates.get(s).getY();
        }
        return new Position(x, y);
    }

    HashMap<String, Position> getLivingPosition() {
        String s;
        HashMap<String, Position> m = new HashMap<String, Position>();
        String[] stringArray = this.getLivingAllTeammates();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            m.put(s, this.getTeammatePosition(s));
            ++n2;
        }
        stringArray = this.getLivingEnemys();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            m.put(s, this.getCurrentEnemyPosition(s));
            ++n2;
        }
        return m;
    }

    private static double getNormalMinute() {
        return (double)Calendar.getInstance().get(12) / 60.0;
    }

    class Assigner {
        private int[] ri;
        double p = Double.POSITIVE_INFINITY;
        private final String[] tn;
        private final String[] en;
        private final double[][] d;
        HashMap<String, String> r;

        Assigner() {
            this.tn = Nightmare.this.getActiveTeammates();
            this.en = Nightmare.this.getLivingEnemys();
            this.d = new double[this.tn.length][this.en.length];
            this.r = new HashMap();
            int i = 0;
            while (i < this.tn.length) {
                int j = 0;
                while (j < this.en.length) {
                    this.d[i][j] = Math.pow(Math.max(0.0, Nightmare.this.getTeammatePosition(this.tn[i]).distance(Nightmare.this.linearPredict(this.en[j], 0.0)) + 1.2 * Nightmare.this.enemys.get((Object)this.en[j]).sre.getEnergy()), 2.0);
                    ++j;
                }
                ++i;
            }
            this.assign(new int[this.tn.length], 0);
            if (this.ri != null) {
                i = 0;
                while (i < this.ri.length) {
                    this.r.put(this.tn[i], this.en[this.ri[i]]);
                    ++i;
                }
            }
        }

        private void assign(int[] e, int idx) {
            if (idx < e.length) {
                int s = 0;
                while (s < this.en.length) {
                    e[idx] = s++;
                    this.assign(e, idx + 1);
                }
            } else {
                double c = 0.0;
                int i = 0;
                while (i < e.length) {
                    c += this.d[i][e[i]];
                    ++i;
                }
                i = 0;
                while (i < this.en.length) {
                    if (!Nightmare.this.dead.contains(this.en[i])) {
                        int cn = 0;
                        int j = 0;
                        while (j < e.length) {
                            if (!Nightmare.this.dead.contains(this.tn[j]) && e[j] == i) {
                                ++cn;
                            }
                            ++j;
                        }
                        if (cn == 1 || cn > 3) {
                            c *= 1.6;
                        }
                    }
                    ++i;
                }
                if (c < this.p) {
                    this.p = c;
                    this.ri = (int[])e.clone();
                }
            }
        }
    }
}

