/*
 * Decompiled with CFR 0.152.
 */
package ags.muse.gun.segmentation;

import ags.muse.gun.SWave;
import ags.muse.recon.Enemy;
import ags.muse.recon.SelfStatus;
import ags.util.Range;
import java.util.EnumMap;

public enum Dimension {
    BULLETSPEED(11.0, 20.0){

        @Override
        public double getValue(SWave wave, SelfStatus status, Enemy target) {
            return wave.getSpeed();
        }
    }
    ,
    BFT(0.0, 91.0){

        @Override
        public double getValue(SWave wave, SelfStatus status, Enemy target) {
            return wave.getOrigin().distance(target.getLocation()) / wave.getSpeed();
        }
    }
    ,
    LATERALV(0.0, 8.0){

        @Override
        public double getValue(SWave wave, SelfStatus status, Enemy target) {
            return Math.abs(target.ext.getLateralVelocity());
        }
    }
    ,
    ADVANCINGV(-8.0, 8.0){

        @Override
        public double getValue(SWave wave, SelfStatus status, Enemy target) {
            return target.ext.getAdvancingVelocity();
        }
    }
    ,
    DISTANCE(18.0, 1200.0){

        @Override
        public double getValue(SWave wave, SelfStatus status, Enemy target) {
            return target.ext.getRelativeLocation().magnitude;
        }
    }
    ,
    ACCEL(-2.0, 1.0){

        @Override
        public double getValue(SWave wave, SelfStatus status, Enemy target) {
            return target.ext.getAccel() * (double)target.ext.getOrientation();
        }
    }
    ,
    LATACCEL(-2.0, 2.0){

        @Override
        public double getValue(SWave wave, SelfStatus status, Enemy target) {
            return target.ext.getLateralAccel() * (double)target.ext.getLateralOrientation();
        }
    }
    ,
    ADVACCEL(-2.0, 2.0){

        @Override
        public double getValue(SWave wave, SelfStatus status, Enemy target) {
            return target.ext.getAdvancingAccel();
        }
    }
    ,
    FWALL(0.0, 1.0){

        @Override
        public double getValue(SWave wave, SelfStatus status, Enemy target) {
            return Math.min(1.0, target.ext.getWallSegment(1, status.getLocation(), wave.getPower()));
        }
    }
    ,
    BWALL(0.0, 1.0){

        @Override
        public double getValue(SWave wave, SelfStatus status, Enemy target) {
            return Math.min(1.0, target.ext.getWallSegment(-1, status.getLocation(), wave.getPower()));
        }
    }
    ,
    VCHANGETIME(0.0, 1.0){

        @Override
        public double getValue(SWave wave, SelfStatus status, Enemy target) {
            double traveltime = wave.getOrigin().distance(target.getLocation()) / wave.getSpeed();
            return (double)target.ext.getVelocityChangeTime() / traveltime;
        }
    }
    ,
    LATDIRTIME(0.0, 1.0){

        @Override
        public double getValue(SWave wave, SelfStatus status, Enemy target) {
            double traveltime = wave.getOrigin().distance(target.getLocation()) / wave.getSpeed();
            return (double)target.ext.getLateralDirectionTime() / traveltime;
        }
    }
    ,
    DISTLAST9(0.0, 72.0){

        @Override
        public double getValue(SWave wave, SelfStatus status, Enemy target) {
            return target.ext.getDistanceLastTicks(9);
        }
    };

    private final Range range;

    public abstract double getValue(SWave var1, SelfStatus var2, Enemy var3);

    public Range getValueRange() {
        return this.range;
    }

    private Dimension(double lower, double upper) {
        this.range = new Range(lower, upper);
    }

    public double normalize(double value) {
        return (value - this.range.getLower()) / this.range.getSize();
    }

    public static Data<Double> getData(SWave wave, SelfStatus status, Enemy target) {
        Data<Double> data = new Data<Double>();
        Dimension[] dimensionArray = Dimension.values();
        int n = dimensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Dimension s = dimensionArray[n2];
            data.put(s, s.getValue(wave, status, target));
            ++n2;
        }
        return data;
    }

    public static int getDimensionCount() {
        return Dimension.values().length;
    }

    /* synthetic */ Dimension(String string, int n, double d, double d2, Dimension dimension) {
        this(d, d2);
    }

    public static class Data<T>
    extends EnumMap<Dimension, T> {
        private static final long serialVersionUID = 1L;

        public Data() {
            super(Dimension.class);
        }

        public Data(Data<T> d) {
            super(d);
        }
    }
}

