/*
 * Decompiled with CFR 0.152.
 */
package bh.facade;

import bh.facade.RulesFacade;
import bh.facade.event_listeners.EventType;
import bh.facade.event_listeners.interfaces.AdvancedEventListener;
import bh.units.Angle;
import bh.units.Bearing;
import bh.units.Distance;
import bh.units.Energy;
import bh.units.Heading;
import bh.units.Heat;
import bh.units.Location;
import bh.units.Speed;
import bh.units.Time;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;

public class FacadeBot
extends AdvancedRobot {
    private final Map<EventType, List<AdvancedEventListener>> listeners = new HashMap<EventType, List<AdvancedEventListener>>();

    public void init() {
        RulesFacade.BATTLEFIELD_HEIGHT = new Distance(this.getBattleFieldHeight());
        RulesFacade.BATTLEFIELD_WIDTH = new Distance(this.getBattleFieldWidth());
        System.out.println("FacadeBot.init(): not using bot width and height as reported by bot...");
    }

    public Time time() {
        return new Time(this.getTime());
    }

    public Energy energy() {
        return new Energy(this.getEnergy());
    }

    public Location location() {
        return new Location(new Distance(this.getX()), new Distance(this.getY()));
    }

    public Heading heading() {
        return new Heading(Angle.fromDegrees(this.getHeading()));
    }

    public Speed speed() {
        return new Speed(this.getVelocity());
    }

    public Heading gunHeading() {
        return new Heading(Angle.fromDegrees(this.getGunHeading()));
    }

    public Heading radarHeading() {
        return new Heading(Angle.fromDegrees(this.getRadarHeading()));
    }

    public Heat gunHeat() {
        return new Heat(this.getGunHeat());
    }

    public Heat gunCoolingRate() {
        return new Heat(this.getGunCoolingRate());
    }

    public Distance width() {
        return new Distance(this.getWidth());
    }

    public Distance height() {
        return new Distance(this.getHeight());
    }

    public Distance battleFieldHeight() {
        return new Distance(this.getBattleFieldHeight());
    }

    public Distance battleFieldWidth() {
        return new Distance(this.getBattleFieldWidth());
    }

    public void setAhead(Distance distance) {
        this.setAhead(distance.toDouble());
    }

    public void setBack(Distance distance) {
        this.setBack(distance.toDouble());
    }

    public void setMaxVelocity(Speed newMaxVelocity) {
        this.setMaxVelocity(newMaxVelocity.toDouble());
    }

    public void setTurnLeft(Bearing bearing) {
        this.setTurnLeft(bearing.toDouble());
    }

    public void setTurnRight(Bearing bearing) {
        this.setTurnRight(bearing.toDouble());
    }

    public void setMaxTurnRate(Bearing newMaxTurnRate) {
        this.setMaxTurnRate(newMaxTurnRate.toDouble());
    }

    public void setTurnGunLeft(Bearing bearing) {
        this.setTurnGunLeft(bearing.toDouble());
    }

    public void setTurnGunRight(Bearing bearing) {
        this.setTurnGunRight(bearing.toDouble());
    }

    public void setTurnRadarLeft(Bearing bearing) {
        this.setTurnRadarLeft(bearing.toDouble());
    }

    public void setTurnRadarRight(Bearing bearing) {
        this.setTurnRadarRight(bearing.toDouble());
    }

    public void setFire(Energy power) {
        this.setFire(power.toDouble());
    }

    public Bullet setFireBullet(Energy power) {
        return this.setFireBullet(power.toDouble());
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    public void registerListener(AdvancedEventListener advancedEventListener) {
        if (advancedEventListener == null) {
            throw new IllegalArgumentException("FacadeBot.registerListener(AdvancedEventListener): passed null AdvancedEventListener");
        }
        EventType[] eventTypeArray = EventType.values();
        int n = eventTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EventType et = eventTypeArray[n2];
            this.registerListener(et, advancedEventListener);
            ++n2;
        }
    }

    public void registerListener(EventType eventType, AdvancedEventListener advancedEventListener) {
        if (advancedEventListener == null) {
            throw new IllegalArgumentException("FacadeBot.registerListener(EventType, AdvancedEventListener): passed null AdvancedEventListener");
        }
        List<AdvancedEventListener> listenersForEventType = this.listeners.get((Object)eventType);
        if (listenersForEventType == null) {
            listenersForEventType = new LinkedList<AdvancedEventListener>();
            this.listeners.put(eventType, listenersForEventType);
        }
        listenersForEventType.add(advancedEventListener);
    }

    public void onBattleEnded(BattleEndedEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.BATTLE_ENDED);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onBattleEnded(event);
            }
        }
    }

    public void onBulletHit(BulletHitEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.BULLET_HIT);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onBulletHit(event);
            }
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.BULLET_HIT_BULLET);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onBulletHitBullet(event);
            }
        }
    }

    public void onBulletMissed(BulletMissedEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.BULLET_MISSED);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onBulletMissed(event);
            }
        }
    }

    public void onCustomEvent(CustomEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.CUSTOM_EVENT);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onCustomEvent(event);
            }
        }
    }

    public void onDeath(DeathEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.DEATH);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onDeath(event);
            }
        }
    }

    public void onHitByBullet(HitByBulletEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.HIT_BY_BULLET);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onHitByBullet(event);
            }
        }
    }

    public void onHitRobot(HitRobotEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.HIT_ROBOT);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onHitRobot(event);
            }
        }
    }

    public void onHitWall(HitWallEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.HIT_WALL);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onHitWall(event);
            }
        }
    }

    public void onKeyPressed(KeyEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.KEY_PRESSED);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onKeyPressed(event);
            }
        }
    }

    public void onKeyReleased(KeyEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.KEY_RELEASED);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onKeyReleased(event);
            }
        }
    }

    public void onKeyTyped(KeyEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.KEY_TYPED);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onKeyTyped(event);
            }
        }
    }

    public void onMouseClicked(MouseEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.MOUSE_CLICKED);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onMouseClicked(event);
            }
        }
    }

    public void onMouseDragged(MouseEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.MOUSE_DRAGGED);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onMouseDragged(event);
            }
        }
    }

    public void onMouseEntered(MouseEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.MOUSE_ENTERED);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onMouseEntered(event);
            }
        }
    }

    public void onMouseExited(MouseEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.MOUSE_EXITED);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onMouseExited(event);
            }
        }
    }

    public void onMouseMoved(MouseEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.MOUSE_MOVED);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onMouseMoved(event);
            }
        }
    }

    public void onMousePressed(MouseEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.MOUSE_PRESSED);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onMousePressed(event);
            }
        }
    }

    public void onMouseReleased(MouseEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.MOUSE_RELEASED);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onMouseReleased(event);
            }
        }
    }

    public void onMouseWheelMoved(MouseWheelEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.MOUSE_WHEEL_MOVED);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onMouseWheelMoved(event);
            }
        }
    }

    public void onPaint(Graphics2D g) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.PAINT);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onPaint(g);
            }
        }
    }

    public void onRobotDeath(RobotDeathEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.ROBOT_DEATH);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onRobotDeath(event);
            }
        }
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.SCANNED_ROBOT);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onScannedRobot(event);
            }
        }
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.SKIPPED_TURN);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onSkippedTurn(event);
            }
        }
    }

    public void onStatus(StatusEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.STATUS);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onStatus(event);
            }
        }
    }

    public void onWin(WinEvent event) {
        List<AdvancedEventListener> aels = this.listeners.get((Object)EventType.WIN);
        if (aels != null) {
            for (AdvancedEventListener ael : aels) {
                ael.onWin(event);
            }
        }
    }
}

