/*
 * Decompiled with CFR 0.152.
 */
package eem.frame.core;

import eem.botVersion;
import eem.frame.gameInfo.gameInfo;
import eem.frame.misc.logger;
import eem.frame.misc.math;
import eem.frame.misc.physics;
import eem.frame.misc.profiler;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Arrays;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.RobocodeFileWriter;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class CoreBot
extends AdvancedRobot {
    public Rules game_rules;
    double BodyTurnRate = 10.0;
    private botVersion botVer;
    public static gameInfo _gameinfo;
    public int numEnemyBotsAlive = 1;
    public long initTicStartTime = 0L;
    public Point2D.Double myCoord;
    double absurdly_huge = 1000000.0;
    double desiredBodyRotationDirection = 0.0;
    public long ticTime;
    public int roundCnt = 0;
    int nonexisting_coord = -10000;
    public int totalNumOfEnemiesAtStart = 0;
    public static int roundsWon;
    public static int roundsLost;
    public static int[] finishingPlacesStats;
    public static int[] skippedTurnStats;
    public static int[] hitWallStats;
    public static int[] hitByBulletStats;
    public static int bulletFiredCnt;
    public static int bulletHitEnemyCnt;
    public static int bulletHitEnemyBulletCnt;
    public static int bulletHitByPredictedCnt;
    private static int numTicsWhenGunInColdState;
    private String logFileName = "CoreBot.log";
    public int verbosity_level = 5;
    private static RobocodeFileWriter fileWriter;
    private boolean appendToLogFlag = false;
    public logger _log = null;

    public void initBattle() {
        this.roundCnt = this.getRoundNum() + 1;
        if (fileWriter == null) {
            try {
                fileWriter = new RobocodeFileWriter(this.getDataFile(this.logFileName));
                this._log = new logger(this.verbosity_level, fileWriter);
            }
            catch (IOException iOException) {
                System.out.println("Trouble opening the logging file: " + iOException.getMessage());
                this._log = new logger(this.verbosity_level);
            }
        }
        physics.init(this);
        math.init(this);
        this.setColors(Color.red, Color.blue, Color.white);
        this.botVer = new botVersion();
        this.totalNumOfEnemiesAtStart = this.getOthers();
        if (finishingPlacesStats == null) {
            finishingPlacesStats = new int[this.totalNumOfEnemiesAtStart + 1];
        }
        if (skippedTurnStats == null) {
            skippedTurnStats = new int[this.getNumRounds()];
        }
        if (hitWallStats == null) {
            hitWallStats = new int[this.getNumRounds()];
        }
        if (hitByBulletStats == null) {
            hitByBulletStats = new int[this.getNumRounds()];
        }
        logger.routine("=========== Round #" + this.roundCnt + "=============");
        this.myCoord = new Point2D.Double(this.getX(), this.getY());
        if (_gameinfo == null) {
            _gameinfo = new gameInfo(this);
        }
        _gameinfo.initBattle(this);
        this.setEventPriority("ScannedRobotEvent", 98);
        this.initTicStartTime = System.nanoTime();
    }

    public void initTic() {
        this.numEnemyBotsAlive = this.getOthers();
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setTicTime();
        logger.noise("----------- Bot version: " + this.botVer.getVersion() + "------- Tic # " + this.ticTime + " -------------");
        logger.noise("Game time: " + this.ticTime);
        logger.noise("Number of other bots = " + this.numEnemyBotsAlive);
        if (this.numEnemyBotsAlive == 0) {
            // empty if block
        }
        this.myCoord.x = this.getX();
        this.myCoord.y = this.getY();
        _gameinfo.initTic();
    }

    private void setTicTime() {
        this.ticTime = this.getTime();
    }

    public long getTime() {
        return physics.ticTimeFromTurnAndRound(super.getTime(), this.getRoundNum());
    }

    public gameInfo getGameInfo() {
        return _gameinfo;
    }

    public String fightType() {
        double d = 1.0 * (double)this.numEnemyBotsAlive / (double)this.totalNumOfEnemiesAtStart;
        String string = "";
        if (this.numEnemyBotsAlive == 0) {
            return "MasterBotAlreadyWon";
        }
        if (this.numEnemyBotsAlive == 1 && this.totalNumOfEnemiesAtStart == 1) {
            return "1on1";
        }
        if (this.numEnemyBotsAlive == 1 && this.totalNumOfEnemiesAtStart != 1) {
            return "melee1on1";
        }
        if (this.numEnemyBotsAlive > 1 && this.totalNumOfEnemiesAtStart != 1) {
            string = "meleeVeterans";
        }
        if (this.numEnemyBotsAlive > 4 && this.totalNumOfEnemiesAtStart != 1) {
            string = "meleeSeasoned";
        }
        if (this.numEnemyBotsAlive > 7 && this.totalNumOfEnemiesAtStart != 1) {
            string = "melee";
        }
        return string;
    }

    public double distTo(double d, double d2) {
        double d3 = d - this.myCoord.x;
        double d4 = d2 - this.myCoord.y;
        return Math.sqrt(d3 * d3 + d4 * d4);
    }

    public void run() {
        this.initBattle();
        while (true) {
            this.initTic();
            if (this.getOthers() == 0) {
                // empty if block
            }
            _gameinfo.run();
        }
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        this.setTicTime();
        this.myCoord.x = this.getX();
        this.myCoord.y = this.getY();
        _gameinfo.onScannedRobot(scannedRobotEvent);
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        _gameinfo.onHitByBullet(hitByBulletEvent);
        int n = this.getRoundNum();
        hitByBulletStats[n] = hitByBulletStats[n] + 1;
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
        _gameinfo.onBulletHit(bulletHitEvent);
        ++bulletHitEnemyCnt;
    }

    public void onBulletMissed(BulletMissedEvent bulletMissedEvent) {
    }

    public void onBulletHitBullet(BulletHitBulletEvent bulletHitBulletEvent) {
        _gameinfo.onBulletHitBullet(bulletHitBulletEvent);
        ++bulletHitEnemyBulletCnt;
    }

    public void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        _gameinfo.onRobotDeath(robotDeathEvent);
    }

    public void onHitWall(HitWallEvent hitWallEvent) {
        int n = this.getRoundNum();
        hitWallStats[n] = hitWallStats[n] + 1;
        logger.dbg("tic " + this.getTime() + ": shame I hit wall");
    }

    public void onSkippedTurn(SkippedTurnEvent skippedTurnEvent) {
        int n = this.getRoundNum();
        skippedTurnStats[n] = skippedTurnStats[n] + 1;
        logger.routine("Skipped turn " + skippedTurnEvent.getSkippedTurn() + " reported at " + this.getTime());
    }

    public void onPaint(Graphics2D graphics2D) {
        _gameinfo.onPaint(graphics2D);
    }

    public void onWin(WinEvent winEvent) {
        this.setTicTime();
        ++roundsWon;
        this.updateFinishingPlacesStats();
        _gameinfo.onWin(winEvent);
        this.winOrLoseRoundEnd();
    }

    public void onDeath(DeathEvent deathEvent) {
        ++roundsLost;
        this.updateFinishingPlacesStats();
        _gameinfo.onDeath(deathEvent);
        this.winOrLoseRoundEnd();
    }

    public void onRoundEnded(RoundEndedEvent roundEndedEvent) {
    }

    public void updateFinishingPlacesStats() {
        int n;
        int n2 = n = this.getOthers();
        finishingPlacesStats[n2] = finishingPlacesStats[n2] + 1;
        logger.routine("Hit by bullet: " + Arrays.toString(hitByBulletStats));
        logger.routine("Wall hits stats: " + Arrays.toString(hitWallStats));
        logger.routine("Skipped turns stats: " + Arrays.toString(skippedTurnStats));
        logger.routine("Hit rate stats: " + logger.hitRateFormat(bulletHitEnemyCnt, bulletFiredCnt));
        logger.routine("Bullet hit bullet stats:: " + logger.hitRateFormat(bulletHitEnemyBulletCnt, bulletFiredCnt));
        logger.routine("Rounds ratio of win/lose = " + roundsWon + "/" + roundsLost);
        logger.routine("Finishing places stats: " + Arrays.toString(finishingPlacesStats));
    }

    public void winOrLoseRoundEnd() {
        logger.routine(profiler.formatAll());
    }

    static {
        roundsWon = 0;
        roundsLost = 0;
        finishingPlacesStats = null;
        skippedTurnStats = null;
        hitWallStats = null;
        hitByBulletStats = null;
        bulletFiredCnt = 0;
        bulletHitEnemyCnt = 0;
        bulletHitEnemyBulletCnt = 0;
        bulletHitByPredictedCnt = 0;
        numTicsWhenGunInColdState = 0;
        fileWriter = null;
    }
}

