/*
 * Decompiled with CFR 0.152.
 */
package eem.frame.dangermap;

import eem.frame.bot.botStatPoint;
import eem.frame.bot.fighterBot;
import eem.frame.dangermap.dangerCalc;
import eem.frame.misc.graphics;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class dangerPathPoint
implements Comparable<dangerPathPoint> {
    public botStatPoint botStat;
    public double dangerLevel;

    public dangerPathPoint() {
        this.botStat = new botStatPoint();
        this.dangerLevel = 0.0;
    }

    public dangerPathPoint(botStatPoint botStatPoint2, double d) {
        this.botStat = botStatPoint2;
        this.dangerLevel = d;
    }

    public double getDanger() {
        return this.dangerLevel;
    }

    public botStatPoint getBotStatPoint() {
        return this.botStat;
    }

    public double calculateDanger(fighterBot fighterBot2) {
        double d = 0.0;
        long l = this.botStat.getTime();
        d += dangerCalc.calculateDangerFromCorners(l, this.botStat.getPosition(), fighterBot2);
        d += dangerCalc.calculateDangerFromWall(l, this.botStat.getPosition(), fighterBot2);
        d += dangerCalc.calculateDangerFromEnemyBots(l, this.botStat.getPosition(), fighterBot2);
        this.setDanger(d += dangerCalc.calculateDangerFromEnemyWaves(l, this.botStat.getPosition(), fighterBot2));
        return d;
    }

    public void setDanger(double d) {
        this.dangerLevel = d;
    }

    public Point2D.Double getPosition() {
        return this.botStat.getPosition();
    }

    public void setPosition(Point2D.Double double_) {
        this.botStat.setPosition((Point2D.Double)double_.clone());
    }

    public int compare(dangerPathPoint dangerPathPoint2, dangerPathPoint dangerPathPoint3) {
        double d = dangerPathPoint2.dangerLevel;
        double d2 = dangerPathPoint3.dangerLevel;
        if (d == d2) {
            return 0;
        }
        if (d > d2) {
            return 1;
        }
        return -1;
    }

    @Override
    public int compareTo(dangerPathPoint dangerPathPoint2) {
        return this.compare(this, dangerPathPoint2);
    }

    public String toString() {
        String string = "";
        string = string + "Point " + this.botStat.format() + "\n" + " has danger level = " + this.dangerLevel;
        return string;
    }

    public void onPaint(Graphics2D graphics2D) {
        Point2D.Double double_ = this.botStat.getPosition();
        double d = this.dangerLevel;
        graphics2D.setColor(graphics.dangerLevel2mapColor(d));
        double d2 = 5.0;
        graphics.drawCircle(graphics2D, double_, d2);
        graphics2D.setColor(new Color(0, 0, 170, 255));
        double d3 = 2.0;
        graphics.drawCircle(graphics2D, double_, d3);
    }
}

