/*
 * Decompiled with CFR 0.152.
 */
package divineomega;

import divineomega.DivineBot;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import robocode.util.Utils;

public class GunWave {
    private double velocity;
    private Point2D origin;
    private int velSeg;
    private double absBearing;
    private double startingTime;
    private double radius;
    private boolean waveIsDead = false;
    private String enemyName;

    public GunWave(double velocity, Point2D origin, int velSeg, double absBearing, double startingTime, String enemyName) {
        this.velocity = velocity;
        this.origin = origin;
        this.velSeg = velSeg;
        this.absBearing = absBearing;
        this.startingTime = startingTime;
        this.enemyName = enemyName;
    }

    public void update(long newTime) {
        this.radius = this.velocity * ((double)newTime - this.startingTime);
    }

    public void update(long newTime, Point2D enemyPosition) {
        this.update(newTime);
        if (((double)newTime - this.startingTime) * this.velocity >= this.origin.distance(enemyPosition)) {
            double[] gunAngles = DivineBot.gunAngles.get(this.enemyName);
            if (gunAngles == null || gunAngles.length != DivineBot.gunAnglesSize) {
                gunAngles = new double[DivineBot.gunAnglesSize];
            }
            gunAngles[this.velSeg + gunAngles.length / 2] = Utils.normalRelativeAngle((double)(Utils.normalAbsoluteAngle((double)Math.atan2(enemyPosition.getX() - this.origin.getX(), enemyPosition.getY() - this.origin.getY())) - this.absBearing));
            DivineBot.gunAngles.put(this.enemyName, gunAngles);
            this.waveIsDead = true;
        }
    }

    public boolean isDead() {
        return this.waveIsDead;
    }

    public void paint(Graphics g, Color color) {
        g.setColor(color);
        g.drawOval((int)(this.origin.getX() - this.radius), (int)(this.origin.getY() - this.radius), (int)this.radius * 2, (int)this.radius * 2);
    }
}

