/*
 * Decompiled with CFR 0.152.
 */
package xiongan;

import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Random;
import robocode.AdvancedRobot;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobocodeFileOutputStream;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import xiongan.Chromosom;
import xiongan.MovingState;
import xiongan.Pace;
import xiongan.Population;
import xiongan.Rectangle;

public class Xiongan
extends AdvancedRobot {
    public MovingState movingState;
    public boolean isFire;
    public boolean isScanned;
    public double preHeading;
    public double enemyBearing;
    public Population pop;
    public Chromosom curGene;
    public boolean isInit = false;
    public static Random random = new Random();

    public void run() {
        this.loadSettings();
        this.pop = new Population(this.getDataFile("move.dat"));
        this.pop.read();
        this.movingState = MovingState.Evolute;
        this.isScanned = false;
        this.enemyBearing = 0.0;
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setTurnRadarRightRadians(Double.MAX_VALUE);
        this.Reset();
        double centerX = this.getBattleFieldWidth() / 2.0;
        double centerY = this.getBattleFieldHeight() / 2.0;
        double centerL = 20.0;
        Rectangle center = new Rectangle(centerX - centerL, centerX + centerL, centerY + centerL, centerY - centerL);
        while (true) {
            if (this.movingState == MovingState.Evolute) {
                this.turnRightRadians(Utils.normalRelativeAngle((double)(this.enemyBearing - 1.5707963267948966)));
                this.setAhead(Double.MAX_VALUE);
                this.evaluate();
                this.Reset();
                this.doNothing();
                continue;
            }
            if (this.movingState == MovingState.Reset && center.contains(this.getX(), this.getY())) {
                this.movingState = MovingState.Evolute;
                continue;
            }
            this.doNothing();
        }
    }

    public void loadSettings() {
        BufferedReader r = null;
        try {
            r = new BufferedReader(new FileReader(this.getDataFile("xiongan.properties")));
            this.isFire = Boolean.parseBoolean(r.readLine());
            r.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.createSettings();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createSettings() {
        this.isFire = true;
        PrintStream w = null;
        try {
            try {
                w = new PrintStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile("xiongan.properties")));
                w.println(this.isFire);
                w.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (w != null) {
                w.close();
            }
        }
    }

    public void onDeath(DeathEvent event) {
        if (this.movingState == MovingState.Evolute && this.curGene.hpLost >= 70.0) {
            this.curGene.isEvaluated = true;
            this.curGene.fitness = this.curGene.hpLost;
            ++this.pop.nextToEvaluate;
        }
        if (this.pop.nextToEvaluate == Population.popSize) {
            this.select();
            this.crossover();
            this.mutate();
            this.pop.nextToEvaluate = 0;
        }
        this.pop.write();
    }

    public void onRobotDeath(RobotDeathEvent event) {
        this.pop.write();
    }

    public void evaluate() {
        this.curGene = this.pop.genes.get(this.pop.nextToEvaluate);
        if (!this.curGene.isEvaluated) {
            this.curGene.hpLost = 0.0;
            for (Pace p : this.curGene.m.paces) {
                if (this.movingState != MovingState.Evolute) break;
                this.setMaxVelocity(p.speed);
                if (p.isForward) {
                    this.setAhead(Double.MAX_VALUE);
                } else {
                    this.setBack(Double.MAX_VALUE);
                }
                this.turnRightRadians(p.angle);
            }
            if (this.movingState == MovingState.Evolute) {
                this.curGene.fitness = this.curGene.hpLost;
                ++this.pop.nextToEvaluate;
                this.curGene.isEvaluated = true;
            }
        } else {
            this.out.println("evaluated already.");
            ++this.pop.nextToEvaluate;
        }
        if (this.pop.nextToEvaluate == Population.popSize) {
            this.select();
            this.crossover();
            this.mutate();
            this.pop.nextToEvaluate = 0;
        }
    }

    private void mutate() {
        int i = 0;
        while (i < Population.popSize) {
            int j = 0;
            while (j < Population.patternSize) {
                if (random.nextDouble() < Population.pMutate) {
                    this.pop.genes.get((int)i).m.paces.set(j, new Pace());
                }
                ++j;
            }
            ++i;
        }
    }

    private void crossover() {
        int count = 0;
        int previous = 0;
        int i = 0;
        while (i < Population.popSize) {
            if (random.nextDouble() < Population.pXover) {
                if (count % 2 == 0) {
                    this.Xover(previous, i);
                } else {
                    previous = i;
                }
            }
            ++i;
        }
    }

    private void Xover(int a, int b) {
        int point = random.nextInt(Population.patternSize) + 1;
        int i = 0;
        while (i < point) {
            Pace tempA = this.pop.genes.get((int)a).m.paces.get(i);
            Pace tempB = this.pop.genes.get((int)b).m.paces.get(i);
            this.pop.genes.get((int)a).m.paces.set(i, tempB);
            this.pop.genes.get((int)a).m.paces.set(i, tempA);
            ++i;
        }
    }

    private void select() {
        Population newPop = new Population(this.getDataFile("move.dat"));
        int i = 0;
        while (i < Population.popSize) {
            int first = random.nextInt(Population.popSize);
            int second = random.nextInt(Population.popSize);
            if (this.pop.genes.get((int)first).fitness <= this.pop.genes.get((int)second).fitness) {
                newPop.genes.set(i, this.pop.genes.get(first));
            } else {
                newPop.genes.set(i, this.pop.genes.get(second));
            }
            newPop.genes.get((int)i).isEvaluated = false;
            ++i;
        }
        this.pop = newPop;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.enemyBearing = this.getHeadingRadians() + e.getBearingRadians();
        double radarTurn = Utils.normalRelativeAngle((double)(this.enemyBearing - this.getRadarHeadingRadians()));
        double arcToScan = Math.min(Math.atan(36.0 / e.getDistance()), 0.7853981633974483);
        this.setTurnRadarRightRadians(radarTurn += radarTurn < 0.0 ? -arcToScan : arcToScan);
        if (this.isFire) {
            this.circularShooting(e);
        }
        this.preHeading = e.getHeadingRadians();
        if (!this.isScanned) {
            this.isScanned = true;
        }
        if (this.movingState == MovingState.Trace && e.getDistance() > 100.0) {
            this.Reset();
        }
    }

    public Point2D.Double getVector(double bearing, double velocity, double turnRate, double t) {
        if (turnRate >= 1.0E-4) {
            double r = velocity / turnRate;
            double dx = r * (Math.cos(bearing) - Math.cos(bearing + turnRate * t));
            double dy = r * (Math.sin(bearing + turnRate * t) - Math.sin(bearing));
            return new Point2D.Double(dx, dy);
        }
        double dx = velocity * t * Math.sin(bearing);
        double dy = velocity * t * Math.cos(bearing);
        return new Point2D.Double(dx, dy);
    }

    public void circularShooting(ScannedRobotEvent e) {
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        double enemyHeading = e.getHeadingRadians();
        double enemyVelocity = e.getVelocity();
        double turnRate = Utils.normalRelativeAngle((double)(enemyHeading - this.preHeading));
        double x = this.getX() + e.getDistance() * Math.sin(absoluteBearing);
        double y = this.getY() + e.getDistance() * Math.cos(absoluteBearing);
        Point2D.Double me = new Point2D.Double(this.getX(), this.getY());
        Point2D.Double p = new Point2D.Double(x, y);
        Point2D.Double p0 = new Point2D.Double(x, y);
        double power = this.getPower(e.getDistance());
        double bulletVelocity = 20.0 - 3.0 * power;
        int i = 0;
        while (i < 10) {
            double t = this.getRange(p.x, p.y, me.x, me.y) / bulletVelocity;
            Point2D.Double vector = this.getVector(enemyHeading, enemyVelocity, turnRate, t);
            p.x = p0.x + vector.x;
            p.y = p0.y + vector.y;
            ++i;
        }
        double gunBearing = this.getAbsoluteBearing(p.x - me.x, p.y - me.y);
        double gunTurn = Utils.normalRelativeAngle((double)(gunBearing - this.getGunHeadingRadians()));
        this.setTurnGunRightRadians(gunTurn);
        this.setFire(power);
    }

    public double getRange(double x1, double y1, double x2, double y2) {
        double x = x2 - x1;
        double y = y2 - y1;
        double h = Math.sqrt(x * x + y * y);
        return h;
    }

    public double getPower(double dist) {
        if (dist >= 300.0) {
            return 1.0;
        }
        return 3.0;
    }

    public void onHitWall(HitWallEvent event) {
        if (this.movingState == MovingState.Trace) {
            this.Reset();
        } else if (this.movingState == MovingState.Evolute) {
            this.curGene.hpLost += this.wallDamage(8.0);
        }
    }

    public double wallDamage(double velocity) {
        return Math.max(Math.abs(velocity) - 1.0, 0.0);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (this.movingState == MovingState.Evolute) {
            this.curGene.hpLost += this.bulletDamage(e.getPower());
        }
    }

    public double bulletDamage(double power) {
        return 4.0 * power + 2.0 * Math.max(power - 1.0, 0.0);
    }

    public void Reset() {
        this.movingState = MovingState.Reset;
        this.setMaxVelocity(8.0);
        this.moveTo(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0);
    }

    public void moveTo(double toX, double toY) {
        this.ahead(0.0);
        double curX = this.getX();
        double curY = this.getY();
        double dx = toX - curX;
        double dy = toY - curY;
        double dist = Math.sqrt(dx * dx + dy * dy);
        double absoluteBearing = this.getAbsoluteBearing(dx, dy);
        double turn = Utils.normalRelativeAngle((double)(absoluteBearing - this.getHeadingRadians()));
        this.turnRightRadians(turn);
        this.setAhead(dist);
    }

    public double getAbsoluteBearing(double dx, double dy) {
        double absoluteBearing = dy > 0.0 ? Math.atan(dx / dy) : (dy < 0.0 ? Math.PI - Math.atan(-dx / dy) : (dx >= 0.0 ? 1.5707963267948966 : -1.5707963267948966));
        return absoluteBearing;
    }

    public void onHitRobot(HitRobotEvent e) {
        this.movingState = MovingState.Trace;
        this.setTurnRight(e.getBearing());
        this.setFire(3.0);
        this.setAhead(Double.MAX_VALUE);
    }
}

