/*
 * Decompiled with CFR 0.152.
 */
package deo.virtual;

import deo.virtual.AdvancedEnemyBot;
import deo.virtual.Gun;
import deo.virtual.Util;
import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Condition;

class SGFTGun
extends Gun {
    public static Point2D.Double enemyLoc;
    public static final double MAX_DISTANCE;
    public static final int DISTANCE_INDEXES;
    public static final int VELOCITY_INDEXES = 5;
    public static final int PREVIOUS_VELOCITY_INDEXES = 5;
    public static final int MIDDLE_VELOCITY_INDEX = 2;
    public static final int BINS = 47;
    public static final int MIDDLE_BIN = 23;
    public static final double MAX_ESC_ANGLE = 0.8143399421265254;
    public static final double BIN_WIDTH = 0.03540608444028371;
    public static double[][][][] stats;
    public static AdvancedRobot robot;
    public static AdvancedEnemyBot enemy;

    static {
        MAX_DISTANCE = Point2D.distance(18.0, 18.0, 782.0, 582.0);
        DISTANCE_INDEXES = (int)(MAX_DISTANCE / 100.0);
    }

    public SGFTGun() {
        stats = new double[DISTANCE_INDEXES][5][5][47];
    }

    @Override
    public String getName() {
        return "GuessFactor Targeting Gun";
    }

    @Override
    public Color getColor() {
        return Color.BLUE;
    }

    @Override
    public double getFireAngle(AdvancedRobot shooter, AdvancedEnemyBot target, double bulletPower) {
        robot = shooter;
        enemy = target;
        double absBearing = robot.getHeadingRadians() + SGFTGun.enemy.bearing;
        double firePower = SGFTGun.enemy.distance >= 200.0 ? 1.72 : 3.0;
        SGFTWave w = new SGFTWave();
        w.firedLocation = new Point2D.Double(robot.getX(), robot.getY());
        enemyLoc = new Point2D.Double(enemy.getX(), enemy.getY());
        w.sign = Util.sign((double)SGFTGun.enemy.velocity * Math.sin(SGFTGun.enemy.heading - absBearing));
        w.bearing = absBearing;
        w.velocity = Util.bulletVelocity(firePower);
        int distanceIndex = (int)(SGFTGun.enemy.distance / (MAX_DISTANCE / (double)DISTANCE_INDEXES));
        int velocityIndex = (int)Math.abs((double)SGFTGun.enemy.velocity / 2.0);
        int previousVelocityIndex = (int)Math.abs((double)SGFTGun.enemy.owner.getVelocity() / 2.0);
        w.segment = stats[distanceIndex][velocityIndex][previousVelocityIndex];
        return Util.normalizeBearing(absBearing + w.sign * 0.03540608444028371 * (double)(this.getMostVisited(w.segment) - 23));
    }

    public int getMostVisited(double[] segment) {
        int mostVisited = 23;
        int i = 0;
        while (i < 47) {
            if (segment[i] > segment[mostVisited]) {
                mostVisited = i;
            }
            ++i;
        }
        return mostVisited;
    }

    public class SGFTWave
    extends Condition {
        public double[] segment;
        public Point2D.Double firedLocation;
        public double velocity;
        public double distanceTraveled;
        public double bearing;
        public double sign;
        final SGFTGun this$0;

        public boolean test() {
            this.distanceTraveled += this.velocity;
            double distance = this.firedLocation.distance(enemyLoc);
            if (this.distanceTraveled > distance - 18.0) {
                int bin = (int)Math.round((Util.normalizeBearing(Util.absoluteBearing(this.firedLocation, enemyLoc)) - this.bearing) / (this.sign * 0.03540608444028371)) + 23;
                int i = 0;
                while (i < 47) {
                    int n = i;
                    this.segment[n] = this.segment[n] + 1.0 / (Math.pow(bin - i, 2.0) + 1.0);
                    ++i;
                }
                robot.removeCustomEvent((Condition)this);
            }
            return false;
        }

        public SGFTWave() {
            this.this$0 = SGFTGun.this;
        }
    }
}

