/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.robot.strategy;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import lazarecki.robot.event.BulletFiredEvent;
import lazarecki.robot.strategy.StrategicModule;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.WinEvent;

public class HitCountModule
extends StrategicModule {
    private int hitCount;
    private List<Bullet> bullets;

    public HitCountModule() {
        this.resetStats();
    }

    public int getBulletCount() {
        return this.bullets.size();
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public int getLastHitCount(int lastShots) {
        if (this.bullets.isEmpty()) {
            return 0;
        }
        lastShots = Math.min(lastShots, this.bullets.size());
        int lastHitCount = 0;
        ListIterator<Bullet> it = this.bullets.listIterator(this.bullets.size() - 1);
        int i = 0;
        while (i < lastShots && it.hasPrevious()) {
            Bullet bullet = it.previous();
            if (bullet.getVictim() != null) {
                ++lastHitCount;
            }
            ++i;
        }
        return lastHitCount;
    }

    public double getHitRatio() {
        return this.getBulletCount() != 0 ? (double)this.getHitCount() / (double)this.getBulletCount() : 0.0;
    }

    public double getLastHitRatio(int lastShots) {
        return (lastShots = Math.min(lastShots, this.bullets.size())) != 0 ? (double)this.getLastHitCount(lastShots) / (double)lastShots : 0.0;
    }

    @Override
    public void onBulletFired(BulletFiredEvent event) {
        this.bullets.add(event.getBullet());
    }

    @Override
    public void onBulletHit(BulletHitEvent event) {
        ++this.hitCount;
    }

    @Override
    public void onDeath(DeathEvent event) {
        this.resetStats();
    }

    @Override
    public void onWin(WinEvent event) {
        this.resetStats();
    }

    protected void resetStats() {
        this.hitCount = 0;
        this.bullets = new LinkedList<Bullet>();
    }
}

