/*
 * Decompiled with CFR 0.152.
 */
package jaybot.intel;

import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jaybot.bots.BaseBot;
import jaybot.guns.AheadTargetting;
import jaybot.guns.BulletDistanceComparator;
import jaybot.guns.FiringSolution;
import jaybot.guns.Gun;
import jaybot.guns.LagTargetting;
import jaybot.guns.LinearTargetting;
import jaybot.guns.VirtualBullet;
import jaybot.intel.EnemyIntel;
import jaybot.intel.RunningStatsBase;
import jaybot.intel.RunningStatsTracker;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class Enemy
extends RunningStatsBase
implements RunningStatsTracker {
    private EnemyIntel _$3379;
    String name;
    public static final double MAX_SCAN_DATA_AGE = 33.0;
    private Map _$3381 = new HashMap();
    private static Map _$3382 = new HashMap();
    private static Map _$3383 = new HashMap();
    private int _$3384 = 0;
    private int _$3385 = 0;
    private int _$3386 = 0;
    private int _$3387 = 0;
    private int _$3388 = 0;
    private double _$3389 = 0.0;
    private int _$2262 = 0;
    private int _$3390 = 0;
    private double _$3391 = 0.0;
    private boolean _$3392 = true;
    private double _$3393 = 100.0;
    private double _$3394 = Double.NEGATIVE_INFINITY;
    private double _$3395 = Double.NEGATIVE_INFINITY;
    private double _$3396 = Double.NEGATIVE_INFINITY;
    private double _$3397 = Double.NEGATIVE_INFINITY;
    private double _$3398 = Double.NEGATIVE_INFINITY;
    private double _$3399 = Double.NEGATIVE_INFINITY;
    private double _$3400 = Double.NEGATIVE_INFINITY;
    private double _$3401 = 100.0;
    private double _$3402 = 0.0;
    private double _$3403 = 0.0;
    private double _$3404 = Double.NEGATIVE_INFINITY;
    private double _$3405 = Double.NEGATIVE_INFINITY;
    private double _$3406 = Double.NEGATIVE_INFINITY;
    private double _$3407 = Double.NEGATIVE_INFINITY;
    private double _$3408 = Double.NEGATIVE_INFINITY;
    private double _$3409 = Double.NEGATIVE_INFINITY;
    private double _$3410 = Double.NEGATIVE_INFINITY;
    private double _$3411 = Double.NEGATIVE_INFINITY;
    private long _$3412 = 0L;
    private long _$3413 = 0L;
    private int _$1652 = 0;
    private int[] _$2264 = new int[9];
    private int _$3414 = 0;
    private double _$3415 = 0.0;
    private double _$3416 = 0.0;
    private double _$3417 = 0.0;
    private List _$3418 = new ArrayList();
    private static DecimalFormat _$318 = new DecimalFormat();

    protected Integer getHitType(int shotType) {
        Integer typ = new Integer(shotType);
        Integer current = (Integer)_$3383.get(typ);
        if (current == null) {
            _$3383.put(typ, new Integer(1));
            return this.getHitType(shotType);
        }
        return current;
    }

    protected int incHitType(int shotType) {
        Integer typ = new Integer(shotType);
        Integer current = this.getHitType(shotType);
        int newValue = current + 1;
        _$3383.put(typ, new Integer(newValue));
        return newValue;
    }

    public void resetHitTypeCounts() {
        _$3383.clear();
    }

    public double getDamageToHim() {
        return this._$3389;
    }

    public int getDeathOrder() {
        return this._$2262;
    }

    public double getLastDataScanTime() {
        return this._$3411;
    }

    public double getEstimatedTurnPerTickRadians() {
        return this._$3416;
    }

    public double getEstimatedTurnPerTickDegrees() {
        return this._$3417;
    }

    public double getEstimatedMovementPerTick() {
        return this._$3415;
    }

    public List getVirtualBullets() {
        return this._$3418;
    }

    public double getLastKnownX() {
        return this._$3394;
    }

    public long getLastCollisionTime() {
        return this._$3413;
    }

    public double getDamageToMe() {
        return this._$3391;
    }

    public double getLastKnownHeading() {
        return this._$3397;
    }

    public int getShotsIntercepted() {
        return this._$3387;
    }

    public int getShotsMissed() {
        return this._$3386;
    }

    public int getShotsHit() {
        return this._$3385;
    }

    public long getLastShotMeTime() {
        return this._$3412;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAlive() {
        return this._$3392;
    }

    public double getLastKnownBearing() {
        return this._$3396;
    }

    public int getShotsFired() {
        return this._$3384;
    }

    public double getLastKnownY() {
        return this._$3395;
    }

    public double getLastKnownEnergy() {
        return this._$3393;
    }

    public int getShotsUnintentionallyHit() {
        return this._$3388;
    }

    public int getHitsOnMe() {
        return this._$3390;
    }

    public double getLastKnownVelocity() {
        return this._$3398;
    }

    public Enemy(EnemyIntel owner, String name) {
        this._$3379 = owner;
        this.name = name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        return this.name.equals(o);
    }

    public boolean hasKnownPosition() {
        return this.haveData() && this._$3394 != Double.NEGATIVE_INFINITY && this._$3395 != Double.NEGATIVE_INFINITY;
    }

    public boolean hasKnownBearing() {
        return this.haveData() && this._$3396 != Double.NEGATIVE_INFINITY;
    }

    public boolean hasKnownHeading() {
        return this.haveData() && this._$3397 != Double.NEGATIVE_INFINITY;
    }

    public boolean hasKnownVelocity() {
        return this.haveData() && this._$3398 != Double.NEGATIVE_INFINITY;
    }

    public void setDeathOrder(int order) {
        this._$2262 = order;
    }

    private Map _$3443() {
        HashMap gunsUsed = (HashMap)_$3382.get(this.getName());
        if (gunsUsed == null) {
            gunsUsed = new HashMap();
            _$3382.put(this.getName(), gunsUsed);
        }
        return gunsUsed;
    }

    public Gun getGunByName(String name) {
        Map gunsUsed = this._$3443();
        if (name == null) {
            return null;
        }
        Gun agun = (Gun)gunsUsed.get(name);
        if (agun == null) {
            if (name.equals("Ahead")) {
                agun = new AheadTargetting();
            } else if (name.equals("Linear")) {
                agun = new LinearTargetting();
            } else if (name.equals("Lag")) {
                agun = new LagTargetting();
            }
            gunsUsed.put(agun.getGunName(), agun);
        }
        return agun;
    }

    public Collection getAllGuns() {
        return this._$3443().values();
    }

    public boolean canDetermineFuturePosition() {
        if (!this.haveData()) {
            this._$3379.getBot().logDetail("- scanMarkTime is not available");
            return false;
        }
        double curTime = this._$3379.getBot().getTime();
        double elapsed = curTime - this._$3411;
        if (!this.hasKnownPosition()) {
            this._$3379.getBot().logDetail("- no known position data");
            return false;
        }
        if (!this.hasKnownVelocity()) {
            this._$3379.getBot().logDetail("- no known velocity data");
            return false;
        }
        if (this._$3398 == 0.0) {
            return true;
        }
        return this.hasKnownHeading();
    }

    public void shootAt(FiringSolution solution, Bullet firedBullet) {
        this._$3381.put(firedBullet, solution);
        Gun gun = this.getGunByName(solution.getGunName());
        if (gun != null) {
            gun.registerFiring(solution);
        }
        ++this._$3384;
        ++this.runningShotsFired;
        this._$3379.getBot().logDetail("Shot fired at: " + this.name + "...");
    }

    public void countBadGuyCollidingWithMe(HitRobotEvent event) {
        ++this.runningCollisions;
        this._$3413 = this._$3379.getBot().getTime();
    }

    public boolean checkShotDueToMissAllTargets(Bullet firedBullet) {
        if (this._$3381.containsKey(firedBullet)) {
            FiringSolution solution = (FiringSolution)this._$3381.get(firedBullet);
            Gun gun = this.getGunByName(solution.getGunName());
            if (gun != null) {
                gun.registerMiss(solution);
            }
            this._$3379.getBot().logTactical("Shot fired at: " + this.name + " missed.");
            ++this._$3386;
            ++this.runningShotsMissedOthers;
            this._$3381.remove(firedBullet);
            return true;
        }
        return false;
    }

    public boolean checkShotDueToMissFromInterception(Bullet firedBullet) {
        if (this._$3381.containsKey(firedBullet)) {
            this._$3379.getBot().logTactical("Shot fired at: " + this.name + " intercepted by another bullet.");
            ++this._$3387;
            this._$3381.remove(firedBullet);
            return true;
        }
        return false;
    }

    public boolean isTargetOfBullet(Bullet firedBullet) {
        return this._$3381.containsKey(firedBullet);
    }

    public boolean checkShotDueToHitATarget(Bullet firedBullet, double damage) {
        if (this._$3381.containsKey(firedBullet)) {
            if (firedBullet.getVictim().equals(this.name)) {
                FiringSolution solution = (FiringSolution)this._$3381.get(firedBullet);
                Gun gun = this.getGunByName(solution.getGunName());
                if (gun != null) {
                    gun.registerHit(solution);
                }
                this._$3379.getBot().logTactical("Shot fired at: " + this.name + " hit!");
                ++this._$3385;
                ++this.runningShotsHitOthers;
                this._$3389 += damage;
                this.runningDamageToOthers += damage;
                this._$3381.remove(firedBullet);
                return true;
            }
            FiringSolution solution = (FiringSolution)this._$3381.get(firedBullet);
            Gun gun = this.getGunByName(solution.getGunName());
            if (gun != null) {
                // empty if block
            }
            this._$3379.getBot().logTactical("Shot fired at: " + this.name + " missed but hit " + firedBullet.getVictim() + ".");
            this._$3381.remove(firedBullet);
            return false;
        }
        if (firedBullet.getName().equals(this.name)) {
            this._$3379.getBot().logTactical("Shot fired at someone else missed but hit " + firedBullet.getVictim() + ".");
            ++this._$3388;
            return true;
        }
        return false;
    }

    public void countBadGuyPickingOnMe(Bullet firedBullet, double damage) {
        ++this._$3390;
        ++this.runningShotsHittingMe;
        this._$3412 = this._$3379.getBot().getTime();
        this._$3379.getBot().logTactical("Hit by " + this.name + " (" + _$318.format(firedBullet.getPower()) + " power) for " + _$318.format(damage));
        this._$3391 += damage;
        this.runningDamageToMe += damage;
        Point2D pos = this._$3379.getBot().getTankPosition();
        ArrayList bullets = new ArrayList(this._$3418);
        if (bullets.size() > 0) {
            Iterator i = bullets.iterator();
            while (i.hasNext()) {
                VirtualBullet check = (VirtualBullet)i.next();
                if (!check.isDead(this._$3412 - 20L)) continue;
                i.remove();
            }
            if (bullets.size() > 0) {
                Collections.sort(bullets, new BulletDistanceComparator(false, pos, this._$3412));
                VirtualBullet closest = (VirtualBullet)bullets.get(0);
                if (closest != null) {
                    double distance = closest.distanceToPoint(pos, this._$3412);
                    this._$3379.getBot().logDetail("Virtual Bullet matches hit at distance " + _$318.format(distance));
                    if (distance < 150.0) {
                        switch (closest.getShotType()) {
                            case 0: {
                                int v = this.incHitType(0);
                                this._$3379.getBot().logDetail("HIT TYPE AHEAD: " + v);
                                break;
                            }
                            case 1: {
                                int v = this.incHitType(1);
                                this._$3379.getBot().logDetail("HIT TYPE FRONT: " + v);
                                break;
                            }
                            case -1: {
                                int v = this.incHitType(-1);
                                this._$3379.getBot().logDetail("HIT TYPE BACK: " + v);
                                break;
                            }
                        }
                    }
                }
            }
        }
    }

    public int getVirtualHitWeightAhead() {
        return this.getHitType(0);
    }

    public int getVirtualHitWeightFront() {
        return this.getHitType(1);
    }

    public int getVirtualHitWeightBack() {
        return this.getHitType(-1);
    }

    public void announceStats() {
        String stats = "";
        stats = "  -- Enemy[" + this.name + "] combined shot statistics ---\n" + "       Shots Fired:               " + this._$3384 + "\n" + "       Shots Hit:                 " + this._$3385 + "\n" + "       Shots Missed:              " + this._$3386 + "\n" + "       Shot Accuracy:             " + _$318.format(this.getShotAccuracy()) + "%\n" + "       Hit Me:                    " + this._$3390 + "\n" + "       Damage to Me:              " + this._$3391 + "\n" + "       Damage to Him:             " + this._$3389 + "\n" + "       Death Order:               " + this._$2262 + "\n";
        stats = stats + "     >> Static gun stats:\n";
        Iterator i = this.getAllGuns().iterator();
        while (i.hasNext()) {
            Gun oneGun = (Gun)i.next();
            String gunStat = "       " + oneGun.getStatsString() + "\n";
            stats = stats + gunStat;
        }
        stats = stats + "     >> Round velocity scan stats:\n";
        stats = stats + "       Total scans: " + this._$1652 + "\n";
        stats = stats + "       Scan array: ";
        for (int i2 = 0; i2 < this._$2264.length; ++i2) {
            stats = stats + i2 + "=" + this._$2264[i2] + ", ";
        }
        stats = stats + "\n";
        this._$3379.getBot().logStats(stats);
    }

    public Point2D getLastPosition() {
        if (this.hasKnownPosition()) {
            return new Point2D.Double(this._$3394, this._$3395);
        }
        return null;
    }

    public double getDistanceToLastPosition() {
        if (this.hasKnownPosition()) {
            return this._$3379.getBot().getTankPosition().distance(this.getLastPosition());
        }
        return Double.POSITIVE_INFINITY;
    }

    public double getShotAccuracy() {
        if (this._$3385 + this._$3386 == 0) {
            return 0.0;
        }
        return (double)this._$3385 / ((double)this._$3385 + (double)this._$3386) * 100.0;
    }

    public void registerDataFromEvent(Event e) {
        if (e instanceof BulletHitEvent) {
            this.registerDataFromBulletHitEvent((BulletHitEvent)e);
        } else if (e instanceof HitRobotEvent) {
            this.registerDataFromHitRobotEvent((HitRobotEvent)e);
        } else if (e instanceof RobotDeathEvent) {
            this.registerDataFromRobotDeathEvent((RobotDeathEvent)e);
        } else if (e instanceof ScannedRobotEvent) {
            this.registerDataFromScanEvent((ScannedRobotEvent)e);
        } else if (e instanceof HitByBulletEvent) {
            this.registerDataFromBulletHittingMeEvent((HitByBulletEvent)e);
        } else {
            throw new UnsupportedOperationException("Enemy cannot handle event " + e.getClass().getName());
        }
    }

    protected void resetDeltaEnergyTracking() {
        this._$3402 = 0.0;
    }

    public double getDeltaScanEnergy() {
        return this._$3402;
    }

    public boolean didFireGun() {
        boolean result = this.deltaIsInFiringRange();
        this.resetDeltaEnergyTracking();
        return result;
    }

    protected boolean deltaIsInFiringRange() {
        return this._$3402 >= 0.1 && this._$3402 <= 3.0;
    }

    public double getLastEnergyChangeTime() {
        return this._$3403;
    }

    public double getLastEnergyChangeElapsedTime() {
        return (double)this._$3379.getBot().getTime() - this._$3403;
    }

    protected void updateEnergy(double newEnergy, double expectedDrop) {
        this._$3402 = this._$3393 - newEnergy + expectedDrop;
        this._$3401 = this._$3393;
        this._$3393 = newEnergy;
        if (newEnergy == 0.0) {
            this._$3402 = 0.0;
            return;
        }
        double oldTime = this._$3403;
        this._$3403 = this._$3379.getBot().getTime();
        double deltaTime = this._$3403 - oldTime;
        double bestGuess = this._$3403 - deltaTime / 2.0;
        if (!this.hasKnownPosition()) {
            return;
        }
        if (this.deltaIsInFiringRange()) {
            Point2D tankPos = this._$3379.getBot().getTankPosition();
            Point2D enemyPos = this.getLastPosition();
            double distanceBetween = tankPos.distance(enemyPos);
            double tankVelocity = this._$3379.getBot().getVelocity();
            double tankHeading = this._$3379.getBot().getHeading();
            double tankHeading2 = BaseBot.normalizeAbsoluteAngleDegrees(tankHeading - 180.0);
            double myVelocity = 5.0;
            double bulletVelocity = BaseBot.getBulletVelocityFromPower(this._$3402);
            this._$3379.getBot().logDetail("Virtual Bullets launched: ");
            this._$3418.add(new VirtualBullet(this._$3379.getBot(), this, enemyPos, bestGuess, this._$3402, tankPos, tankHeading, tankVelocity, 0));
            this._$3379.getBot().logDetail("  = " + tankPos);
            this._$3379.getBot().logTactical("Enemy(" + this.getName() + ") fired shot of power " + _$318.format(this._$3402) + " at someone, virtual bullet created for shooting at me");
        }
        Iterator i = this._$3418.iterator();
        while (i.hasNext()) {
            VirtualBullet bull = (VirtualBullet)i.next();
            if (!bull.isDead(this._$3403)) continue;
            i.remove();
        }
    }

    protected void registerDataFromBulletHitEvent(BulletHitEvent e) {
        BaseBot myBot = this._$3379.getBot();
        this.updateEnergy(e.getEnergy(), BaseBot.getBulletDamageFromPower(e.getBullet().getPower()));
    }

    protected void registerDataFromHitRobotEvent(HitRobotEvent e) {
        this.updateEnergy(e.getEnergy(), 0.6);
    }

    protected void registerDataFromRobotDeathEvent(RobotDeathEvent e) {
        this._$3392 = false;
        this.updateEnergy(0.0, 0.0);
        this._$3394 = Double.NEGATIVE_INFINITY;
        this._$3395 = Double.NEGATIVE_INFINITY;
        this._$3396 = Double.NEGATIVE_INFINITY;
        this._$3398 = Double.NEGATIVE_INFINITY;
        this._$3397 = Double.NEGATIVE_INFINITY;
        this._$3399 = Double.NEGATIVE_INFINITY;
        this._$3400 = Double.NEGATIVE_INFINITY;
        this._$3411 = Double.NEGATIVE_INFINITY;
    }

    protected void registerDataFromBulletHittingMeEvent(HitByBulletEvent e) {
    }

    protected void setNormalizedHeadingAndVelocity(double heading, double velocity) {
        this._$3407 = this._$3397;
        this._$3408 = this._$3398;
        this._$3409 = this._$3399;
        this._$3410 = this._$3400;
        this._$3399 = heading;
        this._$3400 = velocity;
        if (velocity < 0.0) {
            heading = BaseBot.normalizeAbsoluteAngleDegrees(heading + 180.0);
            velocity *= -1.0;
        }
        this._$3397 = heading;
        this._$3398 = velocity;
    }

    protected boolean haveData() {
        return this._$3411 != Double.NEGATIVE_INFINITY;
    }

    protected boolean isStillMovingSameWay() {
        return this._$3400 * this._$3410 >= 0.0;
    }

    public int getMovementReliability() {
        return this._$3414;
    }

    protected void registerDataFromScanEvent(ScannedRobotEvent e) {
        int index;
        BaseBot myBot = this._$3379.getBot();
        double curTime = myBot.getTime();
        ++this._$1652;
        int n = index = Math.min(Math.abs((int)Math.round(e.getVelocity())), this._$2264.length - 1);
        this._$2264[n] = this._$2264[n] + 1;
        this._$3404 = this._$3394;
        this._$3405 = this._$3395;
        this._$3406 = this._$3396;
        this._$3394 = myBot.getX() + Math.sin(Math.toRadians(myBot.bearingToHeadingDegrees(e.getBearing()))) * e.getDistance();
        this._$3395 = myBot.getY() + Math.cos(Math.toRadians(myBot.bearingToHeadingDegrees(e.getBearing()))) * e.getDistance();
        this._$3396 = e.getBearing();
        this.setNormalizedHeadingAndVelocity(e.getHeading(), e.getVelocity());
        if (this.haveData()) {
            double timeSinceLastScan = curTime - this._$3411;
            double lastEstimatedTurn = this._$3416;
            double lastEstimatedSpeed = this._$3415;
            double movementAngle = 0.0;
            Point2D priorPos = BaseBot.pointFromCoords(this._$3404, this._$3405);
            Point2D thisPos = BaseBot.pointFromCoords(this._$3394, this._$3405);
            if (this._$3398 != 0.0 && this.isStillMovingSameWay()) {
                movementAngle = 2.0 * BaseBot.normalizeRelativeAngleDegrees(this._$3397 - BaseBot.getAngleBetweenPointsInDegrees(priorPos, thisPos));
            }
            if (Math.abs(movementAngle) > 270.0) {
                movementAngle = BaseBot.normalizeRelativeAngleDegrees(movementAngle);
            }
            double movementRadians = Math.toRadians(movementAngle);
            this._$3416 = movementRadians / timeSinceLastScan;
            if (Math.abs(this._$3416) < 0.01) {
                this._$3415 = priorPos.distance(thisPos) / timeSinceLastScan;
            } else {
                double turnRadius = priorPos.distance(thisPos) / 2.0 / Math.sin(movementAngle / 2.0);
                this._$3415 = Math.min(8.0, turnRadius * this._$3416);
            }
            double tolerance = 1.0;
            double toleranceRadians = Math.toRadians(tolerance);
            if (Math.abs(this._$3416 - lastEstimatedTurn) <= toleranceRadians && Math.abs(this._$3415 - lastEstimatedSpeed) <= tolerance && timeSinceLastScan < 33.0) {
                ++this._$3414;
            }
        }
        this._$3417 = Math.toDegrees(this._$3416);
        this._$3411 = myBot.getTime();
        this.updateEnergy(e.getEnergy(), 0.0);
    }

    static {
        _$318.setMaximumFractionDigits(2);
        _$318.setMinimumFractionDigits(2);
        _$318.setMinimumIntegerDigits(1);
    }
}

