/*
 * Decompiled with CFR 0.152.
 */
package jaybot.tactics;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Random;
import jaybot.bots.BaseBot;
import jaybot.guns.FiringSolution;
import jaybot.guns.Gun;
import jaybot.intel.Enemy;
import jaybot.strategies.Tactic;
import jaybot.tactics.BasePersonality;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class OddBallPersonality
extends BasePersonality
implements Tactic {
    private static final int _$4715 = 0;
    protected Enemy currentTarget = null;
    protected boolean recentlytHit = false;
    protected int radarSkipCount = 0;

    public void doStartupAction() {
        this.myBot.setColors(this.myBot.getTankColor(), this.myBot.getGunColor(), Color.yellow);
        this.myBot.setAdjustGunForRobotTurn(true);
        this.myBot.setAdjustRadarForGunTurn(true);
        this.myBot.setAdjustRadarForRobotTurn(true);
        this.myBot.turnTankToBearingDegrees(new Random().nextInt(13));
    }

    public void doRunIteration() {
        int test;
        this.myBot.moveTank(90 + new Random().nextInt(20));
        if (!this.recentlytHit && (test = new Random().nextInt(5)) == 3) {
            this.recentlytHit = true;
        }
        if (this.recentlytHit && this.radarSkipCount < 4) {
            ++this.radarSkipCount;
            this.recentlytHit = false;
            this.myBot.logTactical("Skipping radar scan");
        } else {
            this.radarSkipCount = 0;
            this.recentlytHit = false;
            this.myBot.turnRadarByDegrees(360.0);
        }
    }

    private int _$4719(double val) {
        if (val < 0.0) {
            return -1;
        }
        return 1;
    }

    public void reactToYouHitByEnemyBullet(HitByBulletEvent event, Enemy badGuy) {
        if (this.currentTarget == null) {
            this.currentTarget = badGuy;
        }
        if (this.currentTarget != badGuy && badGuy.getRunningShotsHitMe() > this.currentTarget.getRunningShotsHitMe()) {
            this.currentTarget = badGuy;
        }
        if (Math.abs(event.getBearing()) < 30.0) {
            int sign = this._$4719(event.getBearing()) * -1;
            double adjust = event.getBearing() * -2.0;
            if (Math.abs(adjust) < 30.0) {
                adjust += (double)(sign * new Random().nextInt(30));
            }
            this.myBot.logTactical("Hit from narrow bearing from the front (" + dblfmt.format(event.getBearing()) + "), reacting with direction change of " + dblfmt.format(adjust));
            this.myBot.turnTankByDegrees(adjust);
            this.recentlytHit = true;
        } else if (Math.abs(event.getBearing()) > 150.0) {
            int sign = this._$4719(event.getBearing());
            double adjust = 180.0 - Math.abs(event.getBearing());
            adjust = adjust * (double)sign * -2.0;
            sign *= -1;
            if (Math.abs(adjust) < 30.0) {
                adjust += (double)(sign * new Random().nextInt(30));
            }
            this.myBot.logTactical("Hit from narrow bearing from the rear (" + dblfmt.format(event.getBearing()) + "), reacting with direction change of " + dblfmt.format(adjust));
            this.myBot.turnTankByDegrees(adjust);
            this.recentlytHit = true;
        }
    }

    public void reactToYouCollidedWithEnemyRobot(HitRobotEvent event, Enemy badGuy) {
        this.currentTarget = badGuy;
        this.myBot.stop();
        double gunToCollisionAngle = BaseBot.diffBetweenRelativeAnglesDegrees(this.myBot.getGunBearingInDegrees(), event.getBearing());
        if (Math.abs(gunToCollisionAngle) < 20.0) {
            if (this.myBot.getGunHeat() <= 0.0) {
                this.myBot.fireBulletWithoutGun(event.getName(), 3.0, 1.0);
            }
        } else if (Math.abs(gunToCollisionAngle) < 45.0) {
            this.myBot.turnGunToBearingDegrees(event.getBearing());
            if (this.myBot.getGunHeat() <= 0.0) {
                this.myBot.fireBulletWithoutGun(event.getName(), 3.0, 1.0);
            }
        }
        this.myBot.resume();
        if (event.isMyFault()) {
            this.myBot.back(new Random().nextInt(50) + 50);
        } else {
            double absBearing = Math.abs(event.getBearing());
            int multiplier = 1;
            if (new Random().nextInt(2) == 1) {
                multiplier = -1;
            }
            if (absBearing <= 45.0) {
                this.myBot.back(new Random().nextInt(50) + 50);
                this.myBot.turnTankToBearingDegrees(75 * multiplier);
                this.myBot.ahead(150.0);
            } else if (absBearing >= 135.0) {
                this.myBot.ahead(new Random().nextInt(50) + 50);
                this.myBot.turnTankToBearingDegrees(75 * multiplier);
                this.myBot.ahead(150.0);
            } else if (event.getBearing() < 0.0) {
                this.myBot.turnTankToBearingDegrees(event.getBearing() + 90.0);
                this.myBot.ahead(new Random().nextInt(75) + 50);
            } else {
                this.myBot.turnTankToBearingDegrees(event.getBearing() - 90.0);
                this.myBot.ahead(new Random().nextInt(75) + 50);
            }
        }
    }

    public void reactToYouHitWall(HitWallEvent event) {
        this.myBot.moveTank(-66.0);
        this.myBot.turnTankByDegrees(90.0);
    }

    public void reactToSeeingEnemyRobot(ScannedRobotEvent event, Enemy badGuy) {
        FiringSolution solution;
        Point2D myPos;
        double curDistance;
        if (this.currentTarget == null || !this.currentTarget.hasKnownPosition()) {
            this.currentTarget = badGuy;
        }
        if (this.currentTarget != badGuy && (curDistance = (myPos = this.myBot.getTankPosition()).distance(this.currentTarget.getLastPosition())) > 100.0 && curDistance > myPos.distance(badGuy.getLastPosition())) {
            this.currentTarget = badGuy;
        }
        if (this.currentTarget != badGuy) {
            return;
        }
        double power = 3.0;
        Gun linear = badGuy.getGunByName("Linear");
        Gun ahead = badGuy.getGunByName("Ahead");
        if (linear.getRunningShotAccuracy() < 35.0) {
            power = 1.73;
        }
        Gun gun = linear;
        if (this.myBot.getOthers() > 4) {
            power = 3.0;
            gun = ahead;
        }
        if ((solution = gun.buildFiringSolution(this.myBot, badGuy, power)) != null) {
            this.myBot.logTactical("Scan :: " + solution.toString() + ", prior accuracy=" + dblfmt.format(badGuy.getShotAccuracy()));
            if (this.myBot.fireBullet(solution, true)) {
                // empty if block
            }
        } else {
            this.myBot.logTactical("Scan :: cannot determine firing solution for some reason (gun chose not to fire?)");
        }
    }

    public void reactToBulletHitTarget(BulletHitEvent event, Enemy actualTarget, Enemy intendedTarget) {
    }

    public void reactToBulletHitAnotherBullet(BulletHitBulletEvent event, Enemy ownerOfOtherBullet, Enemy intendedTarget) {
    }

    public void reactToBulletMissedTarget(BulletMissedEvent event, Enemy intendedTarget) {
    }

    public void reactToAnotherRobotDeath(RobotDeathEvent event, Enemy deadBadGuy) {
        if (this.currentTarget != null && this.currentTarget.getName().equals(deadBadGuy.getName())) {
            this.currentTarget = null;
        }
    }
}

