/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.data;

import dmh.robocode.data.RadarObservation;
import dmh.robocode.data.Shot;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.gunner.aiming.AimingStrategy;
import dmh.robocode.robot.CommandBasedRobot;
import dmh.robocode.utils.ConvertStatistic;
import robocode.util.Utils;

public class ShotAtEnemy
extends Shot {
    private ShotStatus status;
    private byte enemyVelocityTimesTen;
    private short headingDifferential;
    private AimingStrategy aimingStrategy;

    public ShotAtEnemy(CommandBasedRobot myRobot, EnemyRobot enemyRobot, double bulletPower, AimingStrategy aimingStrategy) {
        super(myRobot, enemyRobot, bulletPower);
        RadarObservation enemyObservation = enemyRobot.getLatestRadarObservation();
        if (enemyObservation == null) {
            this.enemyVelocityTimesTen = 0;
            this.headingDifferential = 0;
        } else {
            this.enemyVelocityTimesTen = ConvertStatistic.makeByte(enemyObservation.getVelocity() * 10.0);
            this.headingDifferential = this.getDifferential(myRobot.getHeading(), enemyObservation.getHeading());
        }
        this.status = ShotStatus.IN_PROGRESS;
        this.aimingStrategy = aimingStrategy;
    }

    private short getDifferential(double myHeading, double enemyHeading) {
        double diff = Utils.normalRelativeAngleDegrees((double)(enemyHeading - myHeading));
        return ConvertStatistic.makeShort(diff);
    }

    public void setStatus(ShotStatus newStatus) {
        this.status = newStatus;
    }

    public ShotStatus getStatus() {
        return this.status;
    }

    public double getEnemyVelocity() {
        return (double)this.enemyVelocityTimesTen / 10.0;
    }

    public short getHeadingDifferential() {
        return this.headingDifferential;
    }

    public AimingStrategy getAimingStrategy() {
        return this.aimingStrategy;
    }

    public static enum ShotStatus {
        IN_PROGRESS,
        HIT_TARGET,
        HIT_OTHER,
        HIT_BULLET,
        MISS,
        ALREADY_DEAD,
        END_ROUND;

    }
}

