/*
 * Decompiled with CFR 0.152.
 */
package oog.melee;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Capulet
extends AdvancedRobot {
    static Rectangle2D.Double fieldRect;
    static double enemyDist;
    static String enemyName;
    static double absBearing;
    static double eHeading;
    static double eEnergy;
    static double targetValue;
    static double eVel;

    public void run() {
        this.setColors(Color.black, Color.red, Color.black);
        fieldRect = new Rectangle2D.Double(18.0, 18.0, this.getBattleFieldWidth() - 36.0, this.getBattleFieldHeight() - 36.0);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        targetValue = Double.POSITIVE_INFINITY;
        while (true) {
            if (this.getGunHeat() >= 1.0 || Capulet.bulletPower() <= 1.0) {
                this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            }
            this.setFire(Capulet.bulletPower());
            this.setMaxVelocity(1.0 / this.getTurnRemaining());
            if (this.getDistanceRemaining() == 0.0) {
                double dist = Math.min(250.0, Math.max(100.0, enemyDist * 0.5 * Math.random()));
                double maxRating = Double.NEGATIVE_INFINITY;
                double pointAngle = 0.0;
                while (pointAngle < Math.PI * 2) {
                    Point2D.Double movePoint = new Point2D.Double(this.getX() + dist * Math.sin(pointAngle), this.getY() + dist * Math.cos(pointAngle));
                    double rating = Math.abs(movePoint.x - this.getBattleFieldWidth() / 2.0) + Math.abs(movePoint.y - this.getBattleFieldHeight() / 2.0) - 200.0 * Math.min(Math.abs(Utils.normalRelativeAngle((double)(pointAngle - absBearing + 1.5707963267948966))), Math.abs(Utils.normalRelativeAngle((double)(pointAngle - absBearing - 1.5707963267948966))));
                    if (rating > maxRating && fieldRect.contains(movePoint)) {
                        maxRating = rating;
                        int dir = Math.abs(pointAngle - this.getHeadingRadians()) < 1.5707963267948966 ? 1 : -1;
                        this.setAhead(dist * (double)dir);
                        this.setTurnRightRadians(Utils.normalRelativeAngle((double)(pointAngle + (dir == 1 ? 0.0 : Math.PI) - this.getHeadingRadians())));
                    }
                    pointAngle += 0.19634954084936207;
                }
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (e.getName() == enemyName || e.getDistance() + e.getEnergy() < targetValue) {
            absBearing = e.getBearingRadians() + this.getHeadingRadians();
            Point2D.Double ePos = Capulet.project(new Point2D.Double(this.getX(), this.getY()), e.getDistance(), absBearing);
            int count = 0;
            double enemyHeading = e.getHeadingRadians();
            double headingChange = enemyHeading - eHeading;
            double d = eVel;
            eVel = e.getVelocity();
            double eDir = Math.signum(d - eVel);
            double speed = eVel;
            while ((double)(++count) * (20.0 - 3.0 * Capulet.bulletPower()) < Point2D.distance(this.getX(), this.getY(), ePos.x, ePos.y)) {
                speed = Math.max(-8.0, Math.min(8.0, speed - (speed / eDir > 0.0 ? eDir : eDir * 2.0)));
                ePos = Capulet.project(ePos, speed, enemyHeading);
                enemyHeading += headingChange;
                if (!fieldRect.contains(ePos)) break;
            }
            enemyDist = e.getDistance();
            eEnergy = e.getEnergy();
            targetValue = enemyDist + eEnergy;
            eHeading = e.getHeadingRadians();
            enemyName = e.getName();
            if (this.getGunHeat() < 1.0) {
                this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getRadarHeadingRadians())) * 2.0);
            }
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(Utils.normalAbsoluteAngle((double)Math.atan2(ePos.x - this.getX(), ePos.y - this.getY())) - this.getGunHeadingRadians())));
        }
    }

    public static double bulletPower() {
        return Math.min(3.0, Math.max(0.1, Math.min(eEnergy / 3.0, 500.0 / enemyDist)));
    }

    public static Point2D.Double project(Point2D.Double origin, double dist, double angle) {
        return new Point2D.Double(origin.x + dist * Math.sin(angle), origin.y + dist * Math.cos(angle));
    }

    public void onRobotDeath(RobotDeathEvent e) {
        targetValue = Double.POSITIVE_INFINITY;
    }
}

