/*
 * Decompiled with CFR 0.152.
 */
package catcat20.jewel.iolite.utils.ags.utils.dataStructures.trees.thirdGenKD;

import catcat20.jewel.iolite.utils.ags.utils.dataStructures.BinaryHeap;
import catcat20.jewel.iolite.utils.ags.utils.dataStructures.MaxHeap;
import catcat20.jewel.iolite.utils.ags.utils.dataStructures.MinHeap;
import catcat20.jewel.iolite.utils.ags.utils.dataStructures.trees.thirdGenKD.DistanceFunction;
import catcat20.jewel.iolite.utils.ags.utils.dataStructures.trees.thirdGenKD.KdNode;
import catcat20.jewel.iolite.utils.ags.utils.dataStructures.trees.thirdGenKD.NearestNeighborIterator;

public class KdTree<T>
extends KdNode<T> {
    public KdTree(int dimensions) {
        this(dimensions, 24);
    }

    public KdTree(int dimensions, int bucketCapacity) {
        super(dimensions, bucketCapacity);
    }

    public NearestNeighborIterator<T> getNearestNeighborIterator(double[] searchPoint, int maxPointsReturned, DistanceFunction distanceFunction) {
        return new NearestNeighborIterator(this, searchPoint, maxPointsReturned, distanceFunction);
    }

    public MaxHeap<T> findNearestNeighbors(double[] searchPoint, int maxPointsReturned, DistanceFunction distanceFunction) {
        BinaryHeap.Min<KdNode<KdTree>> pendingPaths = new BinaryHeap.Min<KdNode<KdTree>>();
        BinaryHeap.Max evaluatedPoints = new BinaryHeap.Max();
        int pointsRemaining = Math.min(maxPointsReturned, this.size());
        pendingPaths.offer(0.0, this);
        while (pendingPaths.size() > 0 && (evaluatedPoints.size() < pointsRemaining || pendingPaths.getMinKey() < evaluatedPoints.getMaxKey())) {
            KdTree.nearestNeighborSearchStep(pendingPaths, evaluatedPoints, pointsRemaining, distanceFunction, searchPoint);
        }
        return evaluatedPoints;
    }

    protected static <T> void nearestNeighborSearchStep(MinHeap<KdNode<T>> pendingPaths, MaxHeap<T> evaluatedPoints, int desiredPoints, DistanceFunction distanceFunction, double[] searchPoint) {
        block8: {
            KdNode<T> cursor;
            block7: {
                cursor = pendingPaths.getMin();
                pendingPaths.removeMin();
                while (!cursor.isLeaf()) {
                    KdNode pathNotTaken;
                    if (searchPoint[cursor.splitDimension] > cursor.splitValue) {
                        pathNotTaken = cursor.left;
                        cursor = cursor.right;
                    } else {
                        pathNotTaken = cursor.right;
                        cursor = cursor.left;
                    }
                    double otherDistance = distanceFunction.distanceToRect(searchPoint, pathNotTaken.minBound, pathNotTaken.maxBound);
                    if (evaluatedPoints.size() >= desiredPoints && !(otherDistance <= evaluatedPoints.getMaxKey())) continue;
                    pendingPaths.offer(otherDistance, pathNotTaken);
                }
                if (!cursor.singlePoint) break block7;
                double nodeDistance = distanceFunction.distance(cursor.points[0], searchPoint);
                if (evaluatedPoints.size() >= desiredPoints && !(nodeDistance <= evaluatedPoints.getMaxKey())) break block8;
                for (int i = 0; i < cursor.size(); ++i) {
                    Object value = cursor.data[i];
                    if (evaluatedPoints.size() == desiredPoints) {
                        evaluatedPoints.replaceMax(nodeDistance, value);
                        continue;
                    }
                    evaluatedPoints.offer(nodeDistance, value);
                }
                break block8;
            }
            for (int i = 0; i < cursor.size(); ++i) {
                double[] point = cursor.points[i];
                Object value = cursor.data[i];
                double distance = distanceFunction.distance(point, searchPoint);
                if (evaluatedPoints.size() < desiredPoints) {
                    evaluatedPoints.offer(distance, value);
                    continue;
                }
                if (!(distance < evaluatedPoints.getMaxKey())) continue;
                evaluatedPoints.replaceMax(distance, value);
            }
        }
    }
}

