/*
 * Decompiled with CFR 0.152.
 */
package com.syncleus.robocode;

import com.syncleus.robocode.NotLockedException;
import com.syncleus.robocode.ScanPing;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Dreadnaught
extends AdvancedRobot {
    private static final boolean AVOID_WHEN_GROUPS = false;
    private static final boolean ADJUST_FIRE_POWER = true;
    TreeMap<Integer, ScanPing> timedScans = new TreeMap();
    TreeMap<String, ScanPing> identifiedRecentScans = new TreeMap();
    TreeMap<Integer, ScanPing> timedScansLock = new TreeMap();
    String currentLockName = null;
    Color bodyColor = Color.black;
    Color gunColor = Color.red;
    Color radarColor = Color.black;
    Color scanColor = Color.red;
    Color bulletColor = Color.white;
    int turns = 0;
    int lastMoveTime = 0;
    private static Random random = new Random();
    private double travelDistance = 300.0;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        while (true) {
            this.doColor();
            this.doScanner();
            this.doGun();
            this.doSeekMovement();
            this.doEncounterMovement();
            this.doWobbleMovement();
            this.execute();
            ++this.turns;
            if (this.turns >= 0) continue;
            this.turns = 0;
        }
    }

    private void doWobbleMovement() {
        if (this.isLocked() && this.getDistanceRemaining() > 0.0) {
            this.setTurnRightRadians(Math.sin((double)this.turns / 7.5) + this.getTurnRemainingRadians());
        }
        double intendedHeading = Utils.normalAbsoluteAngle((double)this.getHeadingRadians());
        if (this.travelDistance < 0.0) {
            intendedHeading = Utils.normalAbsoluteAngle((double)(intendedHeading + Math.PI));
        }
        if (this.getX() + 100.0 > this.getBattleFieldWidth() && intendedHeading < Math.PI) {
            this.setAhead(this.travelDistance * -0.01);
            this.travelDistance *= -1.0;
        } else if (this.getX() - 100.0 < 0.0 && intendedHeading > Math.PI) {
            this.setAhead(this.travelDistance * -0.01);
            this.travelDistance *= -1.0;
        } else if (this.getY() - 100.0 < 0.0 && intendedHeading > 1.5707963267948966 && intendedHeading < 4.71238898038469) {
            this.setAhead(this.travelDistance * -0.01);
            this.travelDistance *= -1.0;
        } else if (this.getY() + 100.0 > this.getBattleFieldHeight() && (intendedHeading < 1.5707963267948966 || intendedHeading > 4.71238898038469)) {
            this.setAhead(this.travelDistance * -0.01);
            this.travelDistance *= -1.0;
        }
    }

    private void doSeekMovement() {
        if (!this.isLocked() && this.getDistanceRemaining() <= 5.0) {
            double turnAngle = random.nextDouble() - 0.5;
            this.setTurnRightRadians(turnAngle);
            this.setAhead(this.travelDistance);
        }
    }

    public void setAhead(double distance) {
        this.lastMoveTime = this.turns;
        super.setAhead(distance);
    }

    private double calculateBulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    private void doGun() {
        double bulletPower = 3.0;
        if (this.isLocked() && this.getPreviousLock() != null) {
            double dy;
            double dx;
            if (this.getLastLock().getEnemyRobot().getDistance() > 600.0 || this.getEnergy() <= 3.0) {
                bulletPower = 0.1;
            } else if (this.getLastLock().getEnemyRobot().getDistance() > 400.0 && this.getLastLock().getEnemyRobot().getDistance() <= 600.0) {
                bulletPower = 1.0;
            } else if (this.getLastLock().getEnemyRobot().getDistance() > 200.0 && this.getLastLock().getEnemyRobot().getDistance() <= 400.0) {
                bulletPower = 2.0;
            } else if (this.getLastLock().getEnemyRobot().getDistance() <= 200.0) {
                bulletPower = 3.0;
            }
            double w = this.getLastLock().getEnemyRobot().getHeadingRadians() - this.getPreviousLock().getEnemyRobot().getHeadingRadians();
            double absbearing = this.getLastLock().getEnemyBearingAbsolute();
            double eX = this.getLastLock().getEnemyRobot().getDistance() * Math.sin(absbearing);
            double eY = this.getLastLock().getEnemyRobot().getDistance() * Math.cos(absbearing);
            double db = 0.0;
            double ww = this.getLastLock().getEnemyRobot().getHeadingRadians();
            do {
                dx = this.getLastLock().getEnemyRobot().getVelocity() * Math.sin(ww);
                dy = this.getLastLock().getEnemyRobot().getVelocity() * Math.cos(ww);
                ww += w;
            } while ((db += this.calculateBulletVelocity(bulletPower)) < Point2D.distance(0.0, 0.0, eX += dx, eY += dy));
            if (eX + this.getX() > this.getBattleFieldWidth()) {
                eX -= eX + this.getX() - this.getBattleFieldWidth();
            } else if (eX + this.getX() < 0.0) {
                eX -= eX + this.getX();
            }
            if (eY + this.getY() > this.getBattleFieldHeight()) {
                eY -= eY + this.getY() - this.getBattleFieldHeight();
            } else if (eY + this.getY() < 0.0) {
                eY -= eY + this.getY();
            }
            this.setTurnGunRightRadians(Math.asin(Math.sin(Math.atan2(eX, eY) - this.getGunHeadingRadians())));
            if (this.getGunTurnRemainingRadians() <= 0.02) {
                this.setFire(bulletPower);
            }
        }
    }

    void doColor() {
        if (this.turns % 20 == 0) {
            if (this.bodyColor == Color.red) {
                this.bodyColor = Color.black;
                this.radarColor = Color.red;
            } else if (this.gunColor == Color.red) {
                this.gunColor = Color.black;
                this.bodyColor = Color.red;
            } else if (this.radarColor == Color.red) {
                this.radarColor = Color.black;
                this.gunColor = Color.red;
            }
            this.scanColor = this.scanColor == Color.red ? Color.white : Color.red;
            this.setBodyColor(this.bodyColor);
            this.setGunColor(this.gunColor);
            this.setRadarColor(this.radarColor);
            this.setScanColor(this.scanColor);
        }
    }

    public void setFire(double power) {
        if (this.getGunHeat() == 0.0) {
            this.bulletColor = this.bulletColor == Color.red ? Color.white : Color.red;
            this.setBulletColor(this.bulletColor);
        }
        super.setFire(power);
    }

    private void doScanner() {
        double radarOffset = Double.POSITIVE_INFINITY;
        try {
            if (this.isLocked()) {
                if (this.timeSinceLastLock() > 8) {
                    this.currentLockName = null;
                    this.timedScansLock.clear();
                }
                if (this.timeSinceLastLock() < 2) {
                    if (this.getOthers() > 1) {
                        // empty if block
                    }
                    radarOffset = Utils.normalRelativeAngle((double)(this.getRadarHeadingRadians() - (this.getLastLock().getEnemyRobot().getBearingRadians() + this.getLastLock().getLocalHeadingRadians())));
                    radarOffset += Math.signum(radarOffset) * 0.02;
                }
            }
        }
        catch (NotLockedException caughtException) {
            this.currentLockName = null;
            this.timedScansLock.clear();
        }
        this.setTurnRadarLeftRadians(radarOffset);
    }

    private boolean isLocked() {
        return this.getLastLock() != null;
    }

    private int timeSinceLastLock() throws NotLockedException {
        if (!this.isLocked()) {
            throw new NotLockedException();
        }
        return this.turns - this.getLastLock().getTurn();
    }

    private int timeSinceLastMove() {
        return this.turns - this.lastMoveTime;
    }

    private ScanPing getLastLock() {
        if (this.currentLockName == null || this.timedScansLock.isEmpty()) {
            return null;
        }
        return this.timedScansLock.lastEntry().getValue();
    }

    private ScanPing getPreviousLock() {
        if (this.currentLockName == null || this.timedScansLock.size() < 2) {
            return null;
        }
        SortedMap<Integer, ScanPing> truncatedMap = this.timedScansLock.headMap(this.timedScansLock.lastKey());
        return (ScanPing)truncatedMap.get(truncatedMap.lastKey());
    }

    private ScanPing getClosestRecentScan() {
        Collection<ScanPing> scans = this.identifiedRecentScans.values();
        ScanPing[] scansSnapshot = new ScanPing[scans.size()];
        scans.toArray(scansSnapshot);
        ScanPing mostRecent = null;
        for (ScanPing scan : scansSnapshot) {
            if (this.turns - scan.getTurn() >= 8) continue;
            if (mostRecent == null) {
                mostRecent = scan;
                continue;
            }
            if (!(mostRecent.getEnemyRobot().getDistance() > scan.getEnemyRobot().getDistance())) continue;
            mostRecent = scan;
        }
        return mostRecent;
    }

    private void doEncounterMovement() {
        if (!this.isLocked()) {
            return;
        }
        if (this.getOthers() <= 1 && this.isLocked()) {
            int turnDirection = 1;
            turnDirection = this.getLastLock().getEnemyRobot().getBearingRadians() >= 0.0 ? 1 : -1;
            this.setTurnRightRadians(this.getLastLock().getEnemyRobot().getBearingRadians());
            this.setAhead(this.getLastLock().getEnemyRobot().getDistance() - 75.0);
        } else if (this.getOthers() > 1 && this.isLocked() && this.getClosestRecentScan() != null) {
            int turnDirection = 1;
            turnDirection = this.getClosestRecentScan().getEnemyRobot().getBearingRadians() >= 0.0 ? 1 : -1;
            this.setTurnRightRadians(this.getClosestRecentScan().getEnemyRobot().getBearingRadians());
            this.setAhead(this.getClosestRecentScan().getEnemyRobot().getDistance() - 75.0);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        ScanPing recentPing = new ScanPing(e, this.getHeadingRadians(), this.getX(), this.getY(), this.turns);
        this.timedScans.put(new Integer(recentPing.getTurn()), recentPing);
        this.identifiedRecentScans.put(recentPing.getEnemyRobot().getName(), recentPing);
        if (this.currentLockName == null || this.currentLockName.compareTo(recentPing.getEnemyRobot().getName()) == 0) {
            this.currentLockName = recentPing.getEnemyRobot().getName();
            this.timedScansLock.put(new Integer(recentPing.getTurn()), recentPing);
        }
    }
}

