/*
 * Decompiled with CFR 0.152.
 */
package bndl;

import bandol.misc.Fncts;
import bndl.Enemy;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;

public class Gun {
    double bulletPower;
    AdvancedRobot robot;

    public Gun(AdvancedRobot advancedRobot) {
        this.robot = advancedRobot;
        this.bulletPower = 0.0;
    }

    public double aimAt(Enemy enemy) {
        this.bulletPower = 0.0;
        double d = 0.0;
        if (enemy != null) {
            this.bulletPower = 3.0;
            if (enemy.getEnergy() <= 16.0) {
                this.bulletPower = Math.min(Math.max(enemy.getEnergy() / 5.0, 0.3), 3.0);
            } else if (enemy.getDistance(this.robot.getX(), this.robot.getY()) > 150.0) {
                this.bulletPower = enemy.getHitRate() != 0.0 ? (this.bulletPower *= Math.min(enemy.getHitRate() * 4.0, 1.0)) : 2.0;
            }
            if (this.robot.getEnergy() < 5.0) {
                this.bulletPower = Math.min(this.bulletPower, this.robot.getEnergy() / 10.0);
            }
            if (this.robot.getEnergy() <= 1.0) {
                this.bulletPower = enemy.getEnergy() == 0.0 ? 0.1 : 0.0;
            }
            if (this.bulletPower != 0.0) {
                double d2 = 20.0 - this.bulletPower * 3.0;
                d = this.intercept(enemy, 0.0, 60.0);
            }
        }
        return d;
    }

    public double simpleInterception(Enemy enemy) {
        double d = 20.0 - this.bulletPower * 3.0;
        double d2 = enemy.getDistance(this.robot.getX(), this.robot.getY()) / d;
        Point2D.Double double_ = enemy.getEstimatedPosition((long)d2);
        double d3 = Math.atan2(double_.x - this.robot.getX(), double_.y - this.robot.getY());
        return Fncts.normRelRadians(d3 - this.robot.getGunHeadingRadians());
    }

    public double noInterception(Enemy enemy) {
        return Fncts.normRelRadians(enemy.getDirection(this.robot.getX(), this.robot.getY()) - this.robot.getGunHeadingRadians());
    }

    public double f(double d, Enemy enemy) {
        double d2 = 20.0 - 3.0 * this.bulletPower;
        return enemy.getEstimatedPosition((long)d).distance(this.robot.getX(), this.robot.getY()) - d2 * d;
    }

    public double intercept(Enemy enemy, double d, double d2) {
        double d3 = d;
        double d4 = d2;
        double d5 = this.f(d4, enemy);
        int n = 0;
        while (Math.abs(d3 - d4) >= 0.1 && n < 15) {
            ++n;
            double d6 = this.f(d3, enemy);
            if (d6 - d5 == 0.0) break;
            double d7 = d3 - d6 * (d3 - d4) / (d6 - d5);
            d4 = d3;
            d3 = d7;
            d5 = d6;
        }
        Point2D.Double double_ = enemy.getEstimatedPosition((long)d3);
        double d8 = Math.atan2(double_.x - this.robot.getX(), double_.y - this.robot.getY());
        return Fncts.normRelRadians(d8 - this.robot.getGunHeadingRadians());
    }

    public double getBulletPower() {
        return this.bulletPower;
    }
}

