/*
 * Decompiled with CFR 0.152.
 */
package wcsv;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import wcsv.Stampede_Gun;
import wcsv.Stampede_TargetData;
import wcsv.targetData;

public class Stampede
extends AdvancedRobot {
    private static double width;
    private static double height;
    private static double diagDistance;
    public static final double border = 45.0;
    public static Stampede_MoveEngine SM;
    public static Stampede_Gun SG;
    public static Stampede_TargetData target;
    private static boolean trackingRight;
    private static double moveDistance;
    private static double offsetAngle;
    private static boolean movingToOne;

    public void run() {
        width = this.getBattleFieldWidth();
        height = this.getBattleFieldHeight();
        diagDistance = Math.sqrt(width * width + height * height);
        SM = new Stampede_MoveEngine();
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setColors(Color.red.darker(), Color.red, Color.orange.brighter());
        SG.resetLists();
        while (true) {
            this.scan();
            this.execute();
        }
    }

    public void scan() {
        this.setTurnRadarRight(target != null ? (trackingRight ? 20 : -20) : -360);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (target != null && e.getName().equals(Stampede.target.name)) {
            target.refreshData(e.getHeading(), e.getVelocity(), e.getEnergy(), e.getDistance(), e.getBearing(), targetData.calcX(this.getX(), (this.getHeading() + e.getBearing()) % 360.0, e.getDistance()), targetData.calcY(this.getY(), (this.getHeading() + e.getBearing()) % 360.0, e.getDistance()), this.getX(), this.getY(), this.getTime());
            SG.testBullets(Stampede.target.x, Stampede.target.y, this.getTime());
            double en = Stampede.target.oldEnergy - Stampede.target.energy;
            if (en > 0.0 && en <= (double)3) {
                SM.pickNextPoint_Orbital(moveDistance);
                SM.move();
                this.setMaxVelocity(Math.random() * 20.0);
                moveDistance = Math.random() * 400.0;
                this.execute();
            }
        } else {
            target = new Stampede_TargetData(e.getName(), e.getHeading(), e.getVelocity(), e.getEnergy(), e.getDistance(), e.getBearing(), targetData.calcX(this.getX(), (this.getHeading() + e.getBearing()) % 360.0, e.getDistance()), targetData.calcY(this.getY(), (this.getHeading() + e.getBearing()) % 360.0, e.getDistance()), this.getX(), this.getY(), this.getTime());
        }
        this.trackAndFire();
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.setMaxVelocity(Math.random() * 20.0);
        moveDistance = Math.random() * 400.0;
    }

    protected void trackAndFire() {
        if (target == null) {
            return;
        }
        double firePower = 3;
        double d = this.getX();
        double d2 = this.getY();
        long l = this.getTime();
        double d3 = 3;
        boolean bl = false;
        if (this.getGunHeat() / this.getGunCoolingRate() < (double)3) {
            bl = true;
        }
        SG.fireBulletWave(target, d, d2, l, d3, bl);
        if (this.getEnergy() <= 8.0) {
            firePower = 0.5;
        }
        double[] bestOffset = SG.getBestOffset(target, firePower);
        if (Stampede.target.energy <= 0.0) {
            bestOffset[0] = 0.0;
        }
        double time = target.calcTime(firePower);
        double GunAngle = bestOffset[1] < 0.0 ? Stampede_TargetData.normalRelativeAngle(Stampede_TargetData.absbearing(this.getX(), this.getY(), target.calcNextX_Linear(8.0 * bestOffset[0], time, 1), target.calcNextY_Linear(8.0 * bestOffset[0], time, 1)) - this.getHeading() + (this.getHeading() - this.getGunHeading())) : Stampede_TargetData.normalRelativeAngle(Stampede_TargetData.absbearing(this.getX(), this.getY(), target.calcNextX_LinearCircular(8.0 * bestOffset[0], time, 1), target.calcNextY_LinearCircular(8.0 * bestOffset[0], time, 1)) - this.getHeading() + (this.getHeading() - this.getGunHeading()));
        this.setTurnGunRight(GunAngle <= 180.0 ? GunAngle : -GunAngle);
        double RadarAngle = Stampede_TargetData.normalRelativeAngle(Stampede_TargetData.absbearing(this.getX(), this.getY(), Stampede.target.x, Stampede.target.y) - this.getHeading() + (this.getHeading() - this.getRadarHeading()));
        this.setTurnRadarRight(RadarAngle <= 180.0 ? RadarAngle : -RadarAngle);
        boolean bl2 = false;
        if (RadarAngle <= 180.0) {
            bl2 = true;
        }
        trackingRight = bl2;
        this.execute();
        this.setFire(firePower);
    }

    public void onBulletHit(BulletHitEvent e) {
        if (target != null && e.getName().equals(Stampede.target.name)) {
            Stampede.target.energy = e.getEnergy();
        }
    }

    static {
        SG = new Stampede_Gun();
        target = null;
        moveDistance = 200.0;
        movingToOne = true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Stampede_MoveEngine {
        private static final int TRACE_DEPTH = 16;
        public final Ellipse2D.Double fieldCircle;
        public final Ellipse2D.Double innerFieldCircle;
        public Point2D.Double nextPoint;

        public void move() {
            double distance = Stampede_TargetData.calcDistance(Stampede.this.getX(), Stampede.this.getY(), this.nextPoint.getX(), this.nextPoint.getY());
            double angle = Stampede_TargetData.normalRelativeAngle(Stampede_TargetData.absbearing(Stampede.this.getX(), Stampede.this.getY(), this.nextPoint.getX(), this.nextPoint.getY()) - Stampede.this.getHeading());
            if (Math.abs(angle) > 90.0) {
                distance *= -1.0;
                angle += angle > 0.0 ? -180.0 : 180.0;
            }
            Stampede.this.setTurnRight(angle);
            Stampede.this.setAhead(distance);
        }

        public void pickNextPoint_Orbital(double distance) {
            if (target == null || Math.abs(Stampede.this.getDistanceRemaining()) > 30.0) {
                return;
            }
            offsetAngle = Math.random() * 60.0;
            double angle = Stampede_TargetData.normalRelativeAngle(Stampede_TargetData.absbearing(Stampede.this.getX(), Stampede.this.getY(), Stampede.target.x, Stampede.target.y));
            Point2D.Double nextPoint2 = new Point2D.Double(Stampede_TargetData.calcX(Stampede.this.getX(), angle - (70.0 + offsetAngle), distance), Stampede_TargetData.calcY(Stampede.this.getY(), angle - (70.0 + offsetAngle), distance));
            Point2D.Double nextPoint1 = new Point2D.Double(Stampede_TargetData.calcX(Stampede.this.getX(), angle + (70.0 + offsetAngle), distance), Stampede_TargetData.calcY(Stampede.this.getY(), angle + (70.0 + offsetAngle), distance));
            if (!this.innerFieldCircle.contains(nextPoint1)) {
                nextPoint1 = this.findIntersectionShape(new Line2D.Double(nextPoint1.getX(), nextPoint1.getY(), width / (double)2, height / (double)2), this.innerFieldCircle);
            }
            if (!this.innerFieldCircle.contains(nextPoint2)) {
                nextPoint2 = this.findIntersectionShape(new Line2D.Double(nextPoint2.getX(), nextPoint2.getY(), width / (double)2, height / (double)2), this.innerFieldCircle);
            }
            Point2D.Double source = !this.innerFieldCircle.contains(Stampede.target.x, Stampede.target.y) ? this.findIntersectionShape(new Line2D.Double(width / (double)2, height / (double)2, Stampede.target.x, Stampede.target.y), this.innerFieldCircle) : new Point2D.Double(Stampede.target.x, Stampede.target.y);
            Point2D.Double end1 = this.findIntersectionShape(new Line2D.Double(source, new Point2D.Double(Stampede_TargetData.calcX(source.getX(), Stampede_TargetData.absbearing(source.getX(), source.getY(), nextPoint1.getX(), nextPoint1.getY()), diagDistance), Stampede_TargetData.calcY(source.getY(), Stampede_TargetData.absbearing(source.getX(), source.getY(), nextPoint1.getX(), nextPoint1.getY()), diagDistance))), this.fieldCircle);
            Point2D.Double end2 = this.findIntersectionShape(new Line2D.Double(source, new Point2D.Double(Stampede_TargetData.calcX(source.getX(), Stampede_TargetData.absbearing(source.getX(), source.getY(), nextPoint2.getX(), nextPoint2.getY()), diagDistance), Stampede_TargetData.calcY(source.getY(), Stampede_TargetData.absbearing(source.getX(), source.getY(), nextPoint2.getX(), nextPoint2.getY()), diagDistance))), this.fieldCircle);
            double d1 = Stampede_TargetData.calcDistance(source.getX(), source.getY(), end1.getX(), end1.getY());
            double d2 = Stampede_TargetData.calcDistance(source.getX(), source.getY(), end2.getX(), end2.getY());
            double d = Math.random();
            Point2D.Double double_ = this.nextPoint = d >= 0.5 ? nextPoint1 : nextPoint2;
            if (d1 / 1.5 > d2) {
                this.nextPoint = nextPoint1;
            } else if (d1 < d2 / 1.5) {
                this.nextPoint = nextPoint2;
            }
        }

        public Point2D.Double findIntersectionShape(Line2D line, Shape shape) {
            boolean containsFirst = shape.contains(line.getP1());
            if (containsFirst == shape.contains(line.getP2())) {
                return null;
            }
            int i = 0;
            while (i < 16) {
                Point2D.Double middle = new Point2D.Double((line.getX1() + line.getX2()) / (double)2, (line.getY1() + line.getY2()) / (double)2);
                line = containsFirst != shape.contains(middle) ? new Line2D.Double(line.getP1(), middle) : new Line2D.Double(middle, line.getP2());
                ++i;
            }
            return new Point2D.Double((line.getX1() + line.getX2()) / (double)2, (line.getY1() + line.getY2()) / (double)2);
        }

        private final /* synthetic */ void this() {
            this.fieldCircle = new Ellipse2D.Double(0.0, 0.0, width, height);
            this.innerFieldCircle = new Ellipse2D.Double(45.0, 45.0, width - 90.0, height - 90.0);
            this.nextPoint = new Point2D.Double();
        }

        public Stampede_MoveEngine() {
            this.this();
        }
    }
}

