/*
 * Decompiled with CFR 0.152.
 */
package ICS4U1;

import java.awt.geom.Point2D;
import java.util.Vector;

class EnemyRobot {
    String name;
    double fieldWidth = 800.0;
    double fieldHeight = 600.0;
    Vector<Point2D.Double> locations = new Vector();
    Point2D.Double expectedLocation = new Point2D.Double(400.0, 300.0);
    boolean alive = true;
    long timeLastSeen = 0L;
    long timeSecondLastSeen = 0L;
    double lastHeading = 0.0;
    double secondLastHeading = 0.0;

    EnemyRobot(String name, double width, double height) {
        this.name = name;
        this.fieldWidth = width;
        this.fieldHeight = height;
    }

    String getName() {
        return this.name;
    }

    Point2D.Double getAverageLocation() {
        double x = 0.0;
        double y = 0.0;
        for (int i = this.locations.size() - 10; i < this.locations.size(); ++i) {
            if (i < 0) continue;
            Point2D.Double point = this.locations.get(i);
            x += point.x;
            y += point.y;
        }
        if (this.locations.size() < 10) {
            return new Point2D.Double(x / (double)this.locations.size(), y / (double)this.locations.size());
        }
        return new Point2D.Double(x / 10.0, y / 10.0);
    }

    Point2D.Double getLocation() {
        if (this.locations.size() == 0) {
            return new Point2D.Double(this.fieldWidth / 2.0, this.fieldHeight / 2.0);
        }
        return this.locations.get(this.locations.size() - 1);
    }

    double getDistance(double x, double y, long time) {
        return Math.sqrt(Math.pow(this.getExpectedLocation((long)time).x - x, 2.0) + Math.pow(this.getExpectedLocation((long)time).y - x, 2.0));
    }

    Point2D.Double getExpectedLocation(long time) {
        double y;
        if (this.locations.size() < 2) {
            return this.expectedLocation;
        }
        double x = this.locations.get((int)(this.locations.size() - 1)).x + (this.locations.get((int)(this.locations.size() - 1)).x - this.locations.get((int)(this.locations.size() - 2)).x) / (double)(this.timeLastSeen - this.timeSecondLastSeen) * (double)(time - this.timeLastSeen);
        if (x < 18.0) {
            x = 18.0;
        }
        if (x > this.fieldWidth - 18.0) {
            x = this.fieldWidth - 18.0;
        }
        if ((y = this.locations.get((int)(this.locations.size() - 1)).y + (this.locations.get((int)(this.locations.size() - 1)).y - this.locations.get((int)(this.locations.size() - 2)).y) / (double)(this.timeLastSeen - this.timeSecondLastSeen) * (double)(time - this.timeLastSeen)) < 18.0) {
            y = 18.0;
        }
        if (y > this.fieldHeight - 18.0) {
            y = this.fieldHeight - 18.0;
        }
        this.expectedLocation.setLocation(x, y);
        return this.expectedLocation;
    }

    void addLocation(double x, double y, double heading, long time) {
        this.timeSecondLastSeen = this.timeLastSeen;
        this.timeLastSeen = time;
        this.secondLastHeading = this.lastHeading;
        this.lastHeading = heading;
        this.locations.add(new Point2D.Double(x, y));
        this.expectedLocation.setLocation(x, y);
    }
}

