/*
 * Decompiled with CFR 0.152.
 */
package asd.movement;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AntiGravMovement {
    AdvancedRobot myself;
    ArrayList gravPoints;
    long tickLastChange;

    public void addGravPoint(double x, double y, double power) {
        this.gravPoints.add(new GravPoint(x, y, power));
    }

    public void addGravPoint(double x, double y, double power, double pow) {
        this.gravPoints.add(new GravPoint(x, y, power, pow));
    }

    public void removeGravPoint(double x, double y, double power) {
        while (this.gravPoints.remove(new GravPoint(x, y, power))) {
        }
    }

    public void update(long tick) {
    }

    private final void inizializeGravPoints() {
        this.addGravPoint(0.0, 0.0, -200.0, 2);
        this.addGravPoint(0.0, this.myself.getBattleFieldHeight(), -200.0, 2);
        this.addGravPoint(this.myself.getBattleFieldWidth(), this.myself.getBattleFieldHeight(), -200.0, 2);
        this.addGravPoint(this.myself.getBattleFieldWidth(), 0.0, -200.0, 2);
    }

    public void clearGravPoint() {
        this.gravPoints.clear();
        this.inizializeGravPoints();
    }

    public void move() {
        if (this.myself.getDistanceRemaining() > 10.0) {
            return;
        }
        this.addGravPoint(this.myself.getX() - this.myself.getWidth() / (double)2, this.myself.getY() - this.myself.getHeight() / (double)2, 1.0, 2);
        double xforce = 0.0;
        double yforce = 0.0;
        double x = this.myself.getX();
        double y = this.myself.getY();
        int i = 0;
        while (i < this.gravPoints.size()) {
            double force = ((GravPoint)this.gravPoints.get((int)i)).power / Math.pow(this.getRange(x, y, ((GravPoint)this.gravPoints.get((int)i)).x, ((GravPoint)this.gravPoints.get((int)i)).y), ((GravPoint)this.gravPoints.get((int)i)).pow);
            double ang = this.normaliseBearing(1.5707963267948966 - Math.atan2(y - ((GravPoint)this.gravPoints.get((int)i)).y, x - ((GravPoint)this.gravPoints.get((int)i)).x));
            xforce += Math.sin(ang) * force;
            yforce += Math.cos(ang) * force;
            ++i;
        }
        this.removeGravPoint(this.myself.getX(), this.myself.getY(), 1.0);
        xforce += 3500.0 / Math.pow(this.getRange(x, y, this.myself.getBattleFieldWidth(), y), 3);
        yforce += 3500.0 / Math.pow(this.getRange(x, y, x, this.myself.getBattleFieldHeight()), 3);
        this.goTo(this.myself.getX() - (xforce -= 3500.0 / Math.pow(this.getRange(x, y, 0.0, y), 3)), this.myself.getY() - (yforce -= 3500.0 / Math.pow(this.getRange(x, y, x, 0.0), 3)));
    }

    private final void goTo(double x, double y) {
        double dist = Math.random() * 30.0 + 20.0;
        double angle = Math.toDegrees(this.absbearing(this.myself.getX(), this.myself.getY(), x, y));
        double r = this.turnTo(angle);
        this.myself.setAhead(dist * r);
    }

    public double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = this.getRange(x1, y1, x2, y2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }

    private final double getRange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    private final double normaliseBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    private final int turnTo(double angle) {
        int dir;
        double ang = this.normaliseBearing(this.myself.getHeading() - angle);
        if (ang > 90.0) {
            ang -= 180.0;
            dir = -1;
        } else if (ang < -90.0) {
            ang += 180.0;
            dir = -1;
        } else {
            dir = 1;
        }
        this.myself.setTurnLeft(ang);
        return dir;
    }

    public void removeGravPoint(GravPoint p) {
        while (this.gravPoints.remove(p)) {
        }
    }

    public void paint(Graphics2D g) {
        int i = 0;
        while (i < this.gravPoints.size()) {
            double h = ((GravPoint)this.gravPoints.get((int)i)).power;
            if (h > 0.0) {
                g.setColor(Color.RED);
            } else {
                h *= -1.0;
                g.setColor(Color.BLUE);
            }
            h %= 10.0;
            g.fillOval((int)((GravPoint)this.gravPoints.get((int)i)).x, (int)((GravPoint)this.gravPoints.get((int)i)).y, (int)(h += 20.0), (int)h);
            ++i;
        }
    }

    private final /* synthetic */ void this() {
        this.gravPoints = new ArrayList();
    }

    public AntiGravMovement(AdvancedRobot myself) {
        this.this();
        this.myself = myself;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class GravPoint {
        public double x;
        public double y;
        public double power;
        public double pow;

        public GravPoint(double x, double y, double power) {
            this.x = x;
            this.y = y;
            this.power = power;
            this.pow = 2;
        }

        public GravPoint(double x, double y, double power, double pow) {
            this.x = x;
            this.y = y;
            this.power = power;
            this.pow = pow;
        }
    }
}

