/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.util.Deque;
import java.util.Iterator;
import pa3k.BulletTracking;
import pa3k.DataStorage;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.Stats;
import pa3k.StatsRadians;
import pa3k.Tracking;
import robocode.AdvancedRobot;

public class Aiming {
    protected Deque<BulletTracking> hits;
    protected Deque<BulletTracking> possibleHits;
    protected Deque<BulletTracking> misses;
    protected Deque<BulletTracking> all;
    protected String opponentName;

    public Aiming(AdvancedRobot advancedRobot, String string, boolean bl) {
        if (bl) {
            this.hits = DataStorage.getOutgoingHits(string);
            this.misses = DataStorage.getOutgoingMisses(string);
            this.possibleHits = DataStorage.getOutgoingPossibleHits(string);
            this.all = DataStorage.getOutgoingAll(string);
        } else {
            this.hits = DataStorage.getIncommingHits(string);
            this.misses = DataStorage.getIncommingMisses(string);
            this.possibleHits = DataStorage.getIncommingPossibleHits(string);
            this.all = DataStorage.getIncommingAll(string);
        }
        this.opponentName = string;
        Log.log(2, "Opponent " + string + ", " + (bl ? "outgoing" : "incomming") + " aiming");
        Log.log(2, "  hits " + this.hits.size());
        Log.log(2, "  misses " + this.misses.size());
        Log.log(2, "  possible hits " + this.possibleHits.size());
    }

    public String getARFF() {
        String string = BulletTracking.getARFFHeader();
        String string2 = this.opponentName.replace(' ', '_');
        Iterator<BulletTracking> iterator = this.hits.iterator();
        while (iterator.hasNext()) {
            string = string + string2 + "," + iterator.next().getARFF();
        }
        iterator = this.possibleHits.iterator();
        while (iterator.hasNext()) {
            string = string + string2 + "," + iterator.next().getARFF();
        }
        return string;
    }

    public void hit(BulletTracking bulletTracking) {
        this.hits.addFirst(bulletTracking);
        this.all.addFirst(bulletTracking);
    }

    public void miss(BulletTracking bulletTracking) {
        if (bulletTracking.getFiringAngle() == 0.0) {
            return;
        }
        this.misses.addFirst(bulletTracking);
        this.all.addFirst(bulletTracking);
    }

    public void possibleHit(BulletTracking bulletTracking) {
        this.possibleHits.addFirst(bulletTracking);
        this.all.addFirst(bulletTracking);
    }

    protected BulletTracking createBulletTracking(Position position, Opponent opponent, Tracking tracking, double d, long l) {
        return new BulletTracking(d, position, opponent, tracking, l);
    }

    public BulletTracking getBestAimingAngle(Position position, Opponent opponent, Tracking tracking, double d, long l) {
        BulletTracking bulletTracking = this.createBulletTracking(position, opponent, tracking, d, l);
        try {
            bulletTracking.setFiringAngle(position.getDirectionTo(opponent.getLastPosition(l)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bulletTracking;
    }

    public double[] getEscapeBins(BulletTracking bulletTracking) {
        double[] dArray = new double[1];
        return dArray;
    }

    public double getHittingRatio() {
        int n = this.misses.size();
        if (n == 0) {
            return 1.0;
        }
        return this.hits.size() / this.misses.size();
    }

    public void dumpStats() {
        Log.log(1, "Hits/misses " + this.hits.size() + "/" + this.misses.size() + ", " + (int)(100.0 * this.getHittingRatio()) + "%");
        StatsRadians statsRadians = new StatsRadians();
        Iterator<BulletTracking> iterator = this.hits.iterator();
        long l = 0L;
        while (iterator.hasNext()) {
            ((Stats)statsRadians).addValue(iterator.next().getFiringAngle(), l++);
        }
        Log.log(1, "Hitting angle: average " + (int)(statsRadians.getD0Average() * 100.0) + "%, STD " + statsRadians.getD0STD());
    }

    public Deque<BulletTracking> getPossibleHits() {
        return this.possibleHits;
    }
}

