/*
 * Decompiled with CFR 0.152.
 */
package gun;

import gun.BulletVector;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import origin.BotData;
import origin.Enemy;
import origin.Util;
import robocode.Rules;

public class enemyGunSim {
    public static double headOn(Point2D source, BotData target, double BULLET_POWER) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    public static double linearPredictionFire(Point2D source, BotData target, double BULLET_POWER) {
        double c;
        double bulletVelocity;
        double a2;
        double a;
        double eVelocityY;
        double time = -1.0;
        double endX = 0.0;
        double endY = 0.0;
        double eX = target.getX() - source.getX();
        double eY = target.getY() - source.getY();
        double eVelocityX = target.getVelocity() * Math.sin(target.getHeading());
        double b = 2.0 * (eX * eVelocityX + eY * (eVelocityY = target.getVelocity() * Math.cos(target.getHeading())));
        double discrim = b * b - 4.0 * (a = eVelocityX * eVelocityX + eVelocityY * eVelocityY - (a2 = (bulletVelocity = Rules.getBulletSpeed((double)BULLET_POWER)) * bulletVelocity)) * (c = eX * eX + eY * eY);
        if (discrim >= 0.0) {
            double t2;
            double t1 = (-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
            time = Math.min(t1, t2 = (-b - Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a)) >= 0.0 ? Math.min(t1, t2) : Math.max(t1, t2);
            double[] bounds = Util.getFieldBoundsxXyY();
            endX = Util.limitValueBounds(eX + source.getX() + eVelocityX * time, bounds[0], bounds[1]);
            endY = Util.limitValueBounds(eY + source.getY() + eVelocityY * time, bounds[2], bounds[3]);
        }
        return Math.atan2(endX - source.getX(), endY - source.getY());
    }

    public static double constantTurnPredict(Point2D source, BotData target, double BULLET_POWER) {
        double turnRate = target.getLatestTurnRate();
        double relX = target.getX() - source.getX();
        double relY = target.getY() - source.getY();
        double cHeading = target.getHeading();
        double velocity = target.getVelocity();
        double selfX = source.getX();
        double selfY = source.getY();
        double deltaTime = 0.0;
        double bulletVelocity = Rules.getBulletSpeed((double)BULLET_POWER);
        while (bulletVelocity * deltaTime < Math.abs(Point2D.distance(0.0, 0.0, relX, relY))) {
            relX += velocity * Math.sin(cHeading + turnRate);
            relY += velocity * Math.cos(cHeading + turnRate);
            cHeading += turnRate;
            deltaTime += 1.0;
        }
        Point2D.Double targetCoord = Util.limitCoordinateToMap(new Point2D.Double(relX + selfX, relY + selfY));
        return Math.atan2(targetCoord.getX() - source.getX(), targetCoord.getY() - source.getY());
    }

    public static boolean checkForHit(BulletVector bulletVector, Enemy target, long currentTime) {
        Rectangle2D.Double enemyArea = new Rectangle2D.Double(target.getX() - 18.0, target.getY() - 18.0, 36.0, 36.0);
        return enemyArea.contains(bulletVector.projectFromStartPos(currentTime - bulletVector.getTime()));
    }

    public static boolean checkForHit(Point2D bulletLoc, Enemy target) {
        Rectangle2D.Double enemyArea = new Rectangle2D.Double(target.getX() - 18.0, target.getY() - 18.0, 36.0, 36.0);
        return enemyArea.contains(bulletLoc);
    }
}

