/*
 * Decompiled with CFR 0.152.
 */
package origin;

import robocode.Rules;

public class EnemyStateML {
    private double distance;
    private double heading;
    private double velocity;
    private double deltaHeading;
    private double timeSinceDecel;
    private static final double distanceWeight = 0.002;
    private static final double headingWeight = 0.15915494309189535;
    private static final double velocityWeight = 0.125;
    private static final double deltaHeadingWeight = 1.0 / Rules.MAX_TURN_RATE_RADIANS;
    private static final double timeSinceDecelWeight = 0.1;

    public EnemyStateML(double d, double h, double v, double pH, long tD) {
        this.distance = d;
        this.heading = h;
        this.velocity = v;
        this.deltaHeading = h - pH;
        this.timeSinceDecel = tD;
    }

    public double getWeightedDataDistanceSq(EnemyStateML nData) {
        double dist = Math.abs(Math.pow(this.distance - nData.getDistance(), 2.0) * 0.002 + Math.pow(this.heading - nData.getHeading(), 2.0) * 0.15915494309189535 + Math.pow(this.velocity - nData.getVelocity(), 2.0) * 0.125 + Math.pow(this.deltaHeading - nData.getDeltaHeading(), 2.0) * deltaHeadingWeight + Math.pow(this.timeSinceDecel - nData.getTimeSinceDecel(), 2.0) * 0.1);
        return dist;
    }

    public double getUnweightedDataDistanceSq(EnemyStateML nData) {
        double dist = Math.abs(Math.pow(this.distance - nData.getDistance(), 2.0) + Math.pow(this.heading - nData.getHeading(), 2.0) + Math.pow(this.velocity - nData.getVelocity(), 2.0) + Math.pow(this.deltaHeading - nData.getDeltaHeading(), 2.0) + Math.pow(this.timeSinceDecel - nData.getTimeSinceDecel(), 2.0));
        return dist;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getHeading() {
        return this.heading;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getDeltaHeading() {
        return this.deltaHeading;
    }

    public double getTimeSinceDecel() {
        return this.timeSinceDecel;
    }
}

