/*
 * Decompiled with CFR 0.152.
 */
package jcs;

import jcs.Enemy;
import jcs.LinearTargeting;
import jcs.Seth;
import jcs.TargetingMode;
import robocode.Bullet;
import robocode.BulletHitEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Gunner {
    private long lastTick;
    private double bulletPower;
    private final double GUNTOLERANCE = 0.1;
    private final double ENERGY_BUFFER = 0.1;
    private final double TARGET_BUFFER = 100.0;
    private Bullet[] bullets;
    private int gunMode;
    private final int NUM_GUN_MODES = 4;
    private int[] bulletsMode;
    private int nextBulletIndex;
    private final int BULLETS_LENGTH = 20;
    private Enemy currentTarget;
    public Seth seth;
    public TargetingMode targeting;

    public void doShoot() {
        double gunLeadAngle = 0.0;
        if (this.seth.getEnemyList().getCount() > 0 && this.seth.getEnergy() > 0.1) {
            if (this.seth.getTicks() - this.lastTick > 12L) {
                this.lastTick = this.seth.getTicks();
                this.reaquireTarget();
            }
            this.bulletPower = this.targeting.calcBulletPower(this.currentTarget);
            double time = this.currentTarget.getCoord().calcDist(this.seth.getCurrentPos()) / (20.0 - (double)3 * this.bulletPower);
            gunLeadAngle = this.targeting.calcPoint(this.currentTarget, time);
            double turnAmount = gunLeadAngle - this.seth.getGunHeadingRadians();
            if (turnAmount > 0.0 && turnAmount <= Math.PI) {
                this.seth.setTurnGunRightRadians(Math.abs(turnAmount));
            } else if (turnAmount > 0.0 && turnAmount > Math.PI) {
                this.seth.setTurnGunLeftRadians(Math.abs(turnAmount));
            } else if (turnAmount < 0.0 && turnAmount > -Math.PI) {
                this.seth.setTurnGunLeftRadians(Math.abs(turnAmount));
            } else {
                this.seth.setTurnGunRightRadians(Math.abs(turnAmount));
            }
            if (this.seth.getGunHeat() < this.seth.getGunCoolingRate() / (double)5 && Math.abs(this.seth.getGunHeadingRadians() - gunLeadAngle) < 0.1) {
                this.addBullet(this.seth.fireBullet(this.bulletPower));
                this.currentTarget.incrementShots(this.gunMode);
                this.setGunMode();
                System.out.println("power = " + this.bulletPower);
            }
        }
    }

    public void reaquireTarget() {
        int targetIndex = 0;
        Enemy[] enemies = this.seth.getEnemyList().getEnemies();
        int i = 0;
        while (i < this.seth.getEnemyList().getCount()) {
            double diff = this.seth.getCurrentPos().calcDist(enemies[targetIndex].getCoord()) - this.seth.getCurrentPos().calcDist(enemies[i].getCoord());
            if (diff > 0.0 && enemies[targetIndex].getEnergy() > enemies[i].getEnergy() || diff > 100.0) {
                targetIndex = i;
            }
            ++i;
        }
        this.currentTarget = enemies[targetIndex];
    }

    public String getTargetName() {
        return this.currentTarget.getName();
    }

    public void setGunMode() {
        int gun = 0;
        int i = 0;
        while (i < 4) {
            System.out.println("gun : " + i + ", ratio = " + this.currentTarget.getRatio(i));
            if (this.currentTarget.getRatio(i) > this.currentTarget.getRatio(gun)) {
                gun = i;
            }
            ++i;
        }
        this.gunMode = gun;
        this.targeting = this.currentTarget.getGun(gun);
    }

    public void bulletHitEvent(BulletHitEvent e) {
        int i = 0;
        while (i < this.bullets.length) {
            if (e.getBullet() == this.bullets[i] && this.currentTarget != null) {
                this.currentTarget.incrementHit(this.bulletsMode[i]);
            }
            ++i;
        }
    }

    public void addBullet(Bullet _bullet) {
        this.bullets[this.nextBulletIndex] = _bullet;
        this.bulletsMode[this.nextBulletIndex] = this.gunMode;
        this.nextBulletIndex = this.nextBulletIndex == 19 ? 0 : ++this.nextBulletIndex;
    }

    public Enemy getCurrentTarget() {
        return this.currentTarget;
    }

    private final /* synthetic */ void this() {
        this.GUNTOLERANCE = 0.1;
        this.ENERGY_BUFFER = 0.1;
        this.TARGET_BUFFER = 100.0;
        this.gunMode = 0;
        this.NUM_GUN_MODES = 4;
        this.nextBulletIndex = 0;
        this.BULLETS_LENGTH = 20;
    }

    public Gunner(Seth _seth) {
        this.this();
        this.seth = _seth;
        this.lastTick = -100L;
        this.currentTarget = null;
        this.seth.setAdjustGunForRobotTurn(true);
        this.seth.setAdjustRadarForGunTurn(true);
        this.targeting = new LinearTargeting(this.seth);
        this.bullets = new Bullet[20];
        this.bulletsMode = new int[20];
    }
}

