/*
 * Decompiled with CFR 0.152.
 */
package justin;

import java.awt.geom.Point2D;
import justin.Future;
import justin.Mallais;
import justin.MyUtils;
import justin.Scan;
import justin.Tank;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class ScannerV2
extends Mallais {
    AdvancedRobot robot;
    static Tank Lf;
    static Scan Lfscan;
    boolean found = true;

    public ScannerV2(AdvancedRobot robot) {
        this.robot = robot;
    }

    public void scan() {
        if (this.found || !Tank.get((String)ScannerV2.Lf.name).alive) {
            this.found = false;
            Tank t = new Tank();
            Scan s = new Scan();
            double bestScore = Double.POSITIVE_INFINITY;
            int i = 1;
            while (i < tank.size()) {
                t = (Tank)((Object)tank.get(i));
                if (t.alive && (s = Tank.getScan(t.name, 0)) != null) {
                    double time = s.scanTime;
                    byte distance = (byte)Math.round(Math.min(1000.0, s.distance) / 1000.0 * 2.0);
                    double sweepSize = Math.abs(Utils.normalRelativeAngle((double)(s.absBearing - this.robot.getRadarHeadingRadians()))) / Math.PI;
                    double score = time - sweepSize;
                    if (this.robot.getOthers() > 5 && distance == 2) {
                        score += 15.0;
                    }
                    if (score < bestScore) {
                        bestScore = score;
                        Lf = t;
                        Lfscan = s;
                    }
                }
                ++i;
            }
        }
        double sinceScanned = this.robot.getTime() - ScannerV2.Lfscan.scanTime;
        missedScansCounter = (long)((double)missedScansCounter + sinceScanned - 1.0);
        Point2D.Double myFpos = Future.position(Tank.getScan(this.robot.getName(), 0), 1);
        Point2D.Double LfFpos = Future.position(Lfscan, (int)sinceScanned);
        double angle = MyUtils.absoluteBearing(myFpos, LfFpos);
        radarDirection = (int)Math.signum(Utils.normalRelativeAngle((double)(angle - this.robot.getRadarHeadingRadians())));
        double turnsTillScanBot = Utils.normalRelativeAngle((double)Math.abs(this.robot.getRadarHeadingRadians() - angle)) / 0.785;
        double radarTurn = Double.POSITIVE_INFINITY * radarDirection;
        if (sinceScanned == 1.0 && turnsTillScanBot < 1.0) {
            this.found = true;
            double offset = 0.01 * sinceScanned;
            offset += Math.abs(ScannerV2.Lfscan.deltaBearing * 2.0);
            offset += 35.0 * sinceScanned / ScannerV2.Lfscan.distance;
            radarTurn = Utils.normalRelativeAngle((double)(angle - this.robot.getRadarHeadingRadians() + (offset *= radarDirection)));
        }
        this.robot.setTurnRadarRightRadians(radarTurn);
    }

    public void update(ScannedRobotEvent e) {
        if (e.getName() == ScannerV2.Lfscan.name) {
            this.found = true;
        }
    }
}

