package djc;

import djc.movement.*;
import djc.util.*;

import java.awt.*;
import java.awt.geom.*;
import java.util.*;

import robocode.*;
import robocode.util.*;

/**
 * Decide which BaseMovement to use
 */
public class MovementManager
{
	public static AbstractDynaBot myrobot = null;
	
	// For Basic Wave Surfing
    public ArrayList surfDirections;
    public ArrayList surfAbsBearings;

	// For my version of Wave Surfing
	public static Hashtable enemyGuessFactorVisitCounts = new Hashtable();

	protected BaseMovement []movementList;
	protected int currentMovementIndex = 0;

	// Segment up the time spent in each Gamestage
	public static double [][]totalTicksUsed      = new double[DynaBotConstants.NUMMOVEMENTS][DynaBotConstants.GAMESTAGES];
	public static double [][]totalDamageTaken    = new double[DynaBotConstants.NUMMOVEMENTS][DynaBotConstants.GAMESTAGES];
		
	// A priori knowledge of a strategy's relative effectiveness
	public static double [][]priorityModifier    = new double[DynaBotConstants.NUMMOVEMENTS][DynaBotConstants.GAMESTAGES];
	public double currentTicksUsed;		
	public double energyAtStart;
		
	public MovementManager(AbstractDynaBot themyrobot) {
		myrobot = themyrobot;
		surfDirections = new ArrayList();
		surfAbsBearings = new ArrayList();
		movementList                                        = new BaseMovement[DynaBotConstants.NUMMOVEMENTS];
		//movementList[DynaBotConstants.SITTINGDUCK]          = new BaseMovement(myrobot);
		//movementList[DynaBotConstants.RANDOMTRONLIKE]       = new RandomTronLikeMovement(myrobot);
		//movementList[DynaBotConstants.CORNERTRONLIKE]       = new CornerTronLikeMovement(myrobot);
		//movementList[DynaBotConstants.WAVESURFER]           = new BasicWaveSurfingMovement(myrobot);
		//movementList[DynaBotConstants.HAWKONFIRE]           = new HawkOnFireMovement(myrobot);
		//movementList[DynaBotConstants.SANDBOXFLATTENER]     = new SandboxFlattenerMovement(myrobot);
		movementList[DynaBotConstants.SANDBOXMINI]          = new SandboxMiniMovement(myrobot);
		//movementList[DynaBotConstants.CORIANTUMR]           = new CoriantumrMovement(myrobot);
		movementList[DynaBotConstants.EVOLUTION]            = new EvolutionMovement(myrobot);
		movementList[DynaBotConstants.EVOLUTIONSURF]        = new EvolutionSurfMovement(myrobot);
		// currentMovementIndex = DynaBotConstants.RANDOMTRONLIKE;
		// currentMovementIndex = DynaBotConstants.CORNERTRONLIKE;
		// currentMovementIndex = DynaBotConstants.SANDBOXMINI;
		
		priorityModifier[DynaBotConstants.SITTINGDUCK][DynaBotConstants.GAMESTAGE_DUEL]        = 200.0;
		priorityModifier[DynaBotConstants.SITTINGDUCK][DynaBotConstants.GAMESTAGE_THREEORFOUR] = 200.0;
		priorityModifier[DynaBotConstants.SITTINGDUCK][DynaBotConstants.GAMESTAGE_FIVEPLUS]    = 200.0;
		priorityModifier[DynaBotConstants.SITTINGDUCK][DynaBotConstants.GAMESTAGE_ALLSTAGES]   = 200.0;
		
		priorityModifier[DynaBotConstants.RANDOMTRONLIKE][DynaBotConstants.GAMESTAGE_DUEL]        = 100.0;
		priorityModifier[DynaBotConstants.RANDOMTRONLIKE][DynaBotConstants.GAMESTAGE_THREEORFOUR] = 200.0;
		priorityModifier[DynaBotConstants.RANDOMTRONLIKE][DynaBotConstants.GAMESTAGE_FIVEPLUS]    = 200.0;
		priorityModifier[DynaBotConstants.RANDOMTRONLIKE][DynaBotConstants.GAMESTAGE_ALLSTAGES]   = 200.0;
		
		priorityModifier[DynaBotConstants.CORNERTRONLIKE][DynaBotConstants.GAMESTAGE_DUEL]        = 100.0;
		priorityModifier[DynaBotConstants.CORNERTRONLIKE][DynaBotConstants.GAMESTAGE_THREEORFOUR] = 100.0;
		priorityModifier[DynaBotConstants.CORNERTRONLIKE][DynaBotConstants.GAMESTAGE_FIVEPLUS]    = 100.0;
		priorityModifier[DynaBotConstants.CORNERTRONLIKE][DynaBotConstants.GAMESTAGE_ALLSTAGES]   = 100.0;
				
		// Update base priority...
		priorityModifier[DynaBotConstants.WAVESURFER][DynaBotConstants.GAMESTAGE_DUEL]        = 1.0;
		priorityModifier[DynaBotConstants.WAVESURFER][DynaBotConstants.GAMESTAGE_THREEORFOUR] = 200.0;
		priorityModifier[DynaBotConstants.WAVESURFER][DynaBotConstants.GAMESTAGE_FIVEPLUS]    = 200.0;
		priorityModifier[DynaBotConstants.WAVESURFER][DynaBotConstants.GAMESTAGE_ALLSTAGES]   = 200.0;

		// Update base priority...
		priorityModifier[DynaBotConstants.HAWKONFIRE][DynaBotConstants.GAMESTAGE_DUEL]        = 200.0;
		priorityModifier[DynaBotConstants.HAWKONFIRE][DynaBotConstants.GAMESTAGE_THREEORFOUR] = 200.0;
		priorityModifier[DynaBotConstants.HAWKONFIRE][DynaBotConstants.GAMESTAGE_FIVEPLUS]    = 200.0;
		priorityModifier[DynaBotConstants.HAWKONFIRE][DynaBotConstants.GAMESTAGE_ALLSTAGES]   = 200.0;
		
		// Update base priority...
		priorityModifier[DynaBotConstants.SANDBOXFLATTENER][DynaBotConstants.GAMESTAGE_DUEL]        = 2.0;
		priorityModifier[DynaBotConstants.SANDBOXFLATTENER][DynaBotConstants.GAMESTAGE_THREEORFOUR] = 200.0;
		priorityModifier[DynaBotConstants.SANDBOXFLATTENER][DynaBotConstants.GAMESTAGE_FIVEPLUS]    = 200.0;
		priorityModifier[DynaBotConstants.SANDBOXFLATTENER][DynaBotConstants.GAMESTAGE_ALLSTAGES]   = 200.0;

		// Update base priority...
		priorityModifier[DynaBotConstants.SANDBOXMINI][DynaBotConstants.GAMESTAGE_DUEL]        = 1.0;
		priorityModifier[DynaBotConstants.SANDBOXMINI][DynaBotConstants.GAMESTAGE_THREEORFOUR] = 2.0;
		priorityModifier[DynaBotConstants.SANDBOXMINI][DynaBotConstants.GAMESTAGE_FIVEPLUS]    = 200.0;
		priorityModifier[DynaBotConstants.SANDBOXMINI][DynaBotConstants.GAMESTAGE_ALLSTAGES]   = 200.0;

		// Update base priority...
		priorityModifier[DynaBotConstants.CORIANTUMR][DynaBotConstants.GAMESTAGE_DUEL]        = 10.0;
		priorityModifier[DynaBotConstants.CORIANTUMR][DynaBotConstants.GAMESTAGE_THREEORFOUR] = 1.0;
		priorityModifier[DynaBotConstants.CORIANTUMR][DynaBotConstants.GAMESTAGE_FIVEPLUS]    = 1.0;
		priorityModifier[DynaBotConstants.CORIANTUMR][DynaBotConstants.GAMESTAGE_ALLSTAGES]   = 100.0;
		
		// Update base priority...
		priorityModifier[DynaBotConstants.EVOLUTION][DynaBotConstants.GAMESTAGE_DUEL]        = 100.0;
		priorityModifier[DynaBotConstants.EVOLUTION][DynaBotConstants.GAMESTAGE_THREEORFOUR] = 1.0;
		priorityModifier[DynaBotConstants.EVOLUTION][DynaBotConstants.GAMESTAGE_FIVEPLUS]    = 1.0;
		priorityModifier[DynaBotConstants.EVOLUTION][DynaBotConstants.GAMESTAGE_ALLSTAGES]   = 100.0;

		// Update base priority...
		priorityModifier[DynaBotConstants.EVOLUTIONSURF][DynaBotConstants.GAMESTAGE_DUEL]        = 1.0;
		priorityModifier[DynaBotConstants.EVOLUTIONSURF][DynaBotConstants.GAMESTAGE_THREEORFOUR] = 1.0;
		priorityModifier[DynaBotConstants.EVOLUTIONSURF][DynaBotConstants.GAMESTAGE_FIVEPLUS]    = 1.0;
		priorityModifier[DynaBotConstants.EVOLUTIONSURF][DynaBotConstants.GAMESTAGE_ALLSTAGES]   = 1.0;								
	}
	
	/**
	 * what to do before each battle
	 */
	public void reset() {
		surfDirections = new ArrayList();
		surfAbsBearings = new ArrayList();
		for(int i=0;i<DynaBotConstants.NUMMOVEMENTS;i++) {
			if(movementList[i] != null) {
				movementList[i].reset();
			}
		}
		energyAtStart = 100;
		pickBestMovementExcluding(-1);
	}

	/**
	 *  Picks randomly (though weighted) based on strategy fitness
	 */
	public void pickBestMovementExcluding(int excludeMovement) {
		if((currentTicksUsed > 200 && energyAtStart - myrobot.getEnergy() > 15) || excludeMovement != -1) {
			return;
		}
		double []theFitnesses         = new double[DynaBotConstants.NUMMOVEMENTS];
		double []invertedFitnesses    = new double[DynaBotConstants.NUMMOVEMENTS];
		double []fitnessProbabilities = new double[DynaBotConstants.NUMMOVEMENTS];
		double sumOfInvertedFitnesses = 0;		
		
		for(int i=0;i<DynaBotConstants.NUMMOVEMENTS;i++) {
			if(movementList[i] != null) {
				double tmpFitness = movementList[i].movementFitness();
				theFitnesses[i]      = tmpFitness;
				invertedFitnesses[i] = 1.0 / tmpFitness;
				sumOfInvertedFitnesses += invertedFitnesses[i];
				//myrobot.out.println("Fitness[" + i + "] " + theFitnesses[i] + " invert: " + invertedFitnesses[i]);
			}
		}
	
		// Now, invertedFitnesses[i] / sumOfInvertedFitnesses should give the chances
		// for selecting a given movement.  I'm sure there's a better way to do this.
		double tmpStart = 0;
		for(int i=0;i<DynaBotConstants.NUMMOVEMENTS;i++) {
			if(movementList[i] != null) {
				fitnessProbabilities[i] = tmpStart + invertedFitnesses[i] / sumOfInvertedFitnesses;
				//myrobot.out.println("fitnessProbabilities[" + movementList[i].name + "] " + fitnessProbabilities[i] + " sum: " + sumOfInvertedFitnesses);
				tmpStart = fitnessProbabilities[i];
			}
		}
		fitnessProbabilities[DynaBotConstants.NUMMOVEMENTS-1] = 1.0;
		Random rdm = new Random();
		double tmpRandom = rdm.nextDouble();  // in range from 0-1.0.
		//myrobot.out.println("Random: " + tmpRandom);
		
		// Now find the corresponding movement...
		int iNewMovement = 0;
		for(;iNewMovement<DynaBotConstants.NUMMOVEMENTS;iNewMovement++) {
			if(movementList[iNewMovement] != null) {
				if(fitnessProbabilities[iNewMovement] > tmpRandom) {
					break;
				}
			}
		}
	
		//iNewMovement = DynaBotConstants.SANDBOXMINI;
		//iNewMovement = DynaBotConstants.WAVESURFER;
		//iNewMovement = DynaBotConstants.SANDBOXFLATTENER;
		//iNewMovement = DynaBotConstants.RANDOMTRONLIKE;
		//iNewMovement = DynaBotConstants.EVOLUTION;
		//iNewMovement = DynaBotConstants.EVOLUTIONSURF;
		//iNewMovement =  DynaBotConstants.SITTINGDUCK;
		if(currentMovementIndex != iNewMovement) {
			myrobot.setMaxVelocity(8);                // Reset max velocity in case someone changed it
			currentMovementIndex = iNewMovement;
			//myrobot.out.println("New: " + currentMovementIndex);
			myrobot.out.println("Switching movement to " + movementList[currentMovementIndex].name);
		}
	}
			
	/**
	 * what to do each tick
	 */
	public void doWork() {
		movementList[currentMovementIndex].doWork();
		int i = MyUtils.getGameStage(myrobot.getOthers());

		// Update the time spent in this movement mode						
		totalTicksUsed[currentMovementIndex][i]++;
		totalTicksUsed[currentMovementIndex][DynaBotConstants.GAMESTAGE_ALLSTAGES]++;
		currentTicksUsed++;
		
		if(myrobot.theEnemyManager.currentEnemy != null) {
			// Age GF roughly every 150 ticks
			if(((int)myrobot.getTime() % 150 ==0) && myrobot.getTime() > 0) {
				//ageVisitCounts(.9);
				myrobot.out.println("Aging VisitCount complete");
			}
		}
	}
	/*
	protected void ageVisitCounts(double ageRate) {
		Enumeration e = enemyGuessFactorVisitCounts
		double [][][][][]gf;
		gf = (double[][][][][])enemyGuessFactorVisitCounts.get(enemyName);
		for(int i=0;i<DynaBotConstants.GAMESTAGES;i++) {
			for(int j=0;j<DynaBotConstants.NUM_DIST_SEG;j++) {
				for(int k=0;k<DynaBotConstants.VELOCITY_INDEXES;k++) {
					for(int m=0;m<DynaBotConstants.VELOCITY_INDEXES;m++) {
						for(int n=0;n<DynaBotConstants.GUESSFACTORBINS;n++) {
							gf[i][j][k][m][n] *= ageRate;
						}
					}
				}
			}
		}
	}
	*/
	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
        double lateralVelocity = myrobot.getVelocity()*Math.sin(e.getBearingRadians());
        double absBearing = e.getBearingRadians() + myrobot.getHeadingRadians();

        surfDirections.add(0,  new Integer((lateralVelocity >= 0) ? 1 : -1));
        surfAbsBearings.add(0, new Double(absBearing + Math.PI));

		movementList[currentMovementIndex].onScannedRobot(e);				
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		double damageTaken = MyUtils.getBulletDamage(e.getPower());
		int j = MyUtils.getGameStage(myrobot.getOthers());
				
		totalDamageTaken[currentMovementIndex][j] += MyUtils.getBulletDamage(e.getBullet().getPower());
		totalDamageTaken[currentMovementIndex][DynaBotConstants.GAMESTAGE_ALLSTAGES] += MyUtils.getBulletDamage(e.getBullet().getPower());
				
		movementList[currentMovementIndex].onHitByBullet(e);
		
		// Update enemyGuessFactorVisitCounts
		EnemyWave ew = myrobot.theBattleManager.getClosestSurfableWave(myrobot.location);
		if(ew == null) myrobot.out.println("No wave found close to " + (int)myrobot.location.getX() + "," + (int)myrobot.location.getY());
		
		String enemyName = e.getName();
		
		// Assume enemy GF Gun segments: - DistSeg X GuessFactorBins 
		double [][]visitCounts;
		if(enemyGuessFactorVisitCounts.containsKey(enemyName)) {
			visitCounts = (double[][])enemyGuessFactorVisitCounts.get(enemyName);
		} else {
			visitCounts = new double[DynaBotConstants.NUM_DIST_SEG][DynaBotConstants.GUESSFACTORBINS];
			for(int i=0;i<DynaBotConstants.NUM_DIST_SEG;i++) {
				visitCounts[i][DynaBotConstants.GUESSFACTORMIDDLE_BIN] += 5;  // Default avoid HOT
			}			
			enemyGuessFactorVisitCounts.put(enemyName, visitCounts);
		}
		
		if(ew != null) {
			double fireDist   = ew.fireLocation.distance(ew.fireTargetLocation);
			int distSeg = MyUtils.getDistanceBin(fireDist);
			int gfIndex = ew.getFactorIndex(myrobot.location);
			//myrobot.out.println("Enemywave hit: " + gfIndex);
			// Update GuessFactors
			for(int i=0;i<DynaBotConstants.GUESSFACTORBINS;i++) {
            	// for the spot bin that we were hit on, add 1;
	            // for the bins next to it, add 1 / 2;
    	        // the next one, add 1 / 5; and so on...
	    	    visitCounts[distSeg][i] += 5.0 / (Math.pow(gfIndex - i, 2) + 1);
			}
	
			enemyGuessFactorVisitCounts.put(enemyName, visitCounts);
		}
		Random rdm = new Random();
		if(rdm.nextBoolean()) {
			pickBestMovementExcluding(-1);
		}
	}
	
	public void onBulletHitBullet(BulletHitBulletEvent e) {
		// Update enemyGuessFactorVisitCounts
		Bullet b = e.getHitBullet();
		String enemyName = b.getName();
		Point2D.Double impactLocation = new Point2D.Double(b.getX(), b.getY());
		EnemyWave ew = myrobot.theBattleManager.getClosestSurfableWave(impactLocation);
		if(ew == null) myrobot.out.println("MM.BulletHitBullet No wave found close to " + (int)myrobot.location.getX() + "," + (int)myrobot.location.getY());
		
		// Assume enemy GF Gun segments: - DistSeg X GuessFactorBins 
		double [][]visitCounts;
		if(enemyGuessFactorVisitCounts.containsKey(enemyName)) {
			visitCounts = (double[][])enemyGuessFactorVisitCounts.get(enemyName);
		} else {
			visitCounts = new double[DynaBotConstants.NUM_DIST_SEG][DynaBotConstants.GUESSFACTORBINS];
			for(int i=0;i<DynaBotConstants.NUM_DIST_SEG;i++) {
				visitCounts[i][DynaBotConstants.GUESSFACTORMIDDLE_BIN] += 5;  // Default avoid HOT
			}			
			enemyGuessFactorVisitCounts.put(enemyName, visitCounts);
		}
		
		if(ew != null) {
			double fireDist   = ew.fireLocation.distance(ew.fireTargetLocation);
			int distSeg = MyUtils.getDistanceBin(fireDist);
			int gfIndex = ew.getFactorIndex(impactLocation);
			//myrobot.out.println("Enemywave hit: " + gfIndex);
			// Update GuessFactors
			for(int i=0;i<DynaBotConstants.GUESSFACTORBINS;i++) {
            	// for the spot bin that we were hit on, add 1;
	            // for the bins next to it, add 1 / 2;
    	        // the next one, add 1 / 5; and so on...
	    	    visitCounts[distSeg][i] += 5.0 / (Math.pow(gfIndex - i, 2) + 1);
			}
	
			enemyGuessFactorVisitCounts.put(enemyName, visitCounts);
		}		
	}

	public void onDeath(DeathEvent e) {
	}

	public void onHitRobot(HitRobotEvent e) {
		movementList[currentMovementIndex].onHitRobot(e);		
	}

	public void onHitWall(HitWallEvent e) {
		myrobot.out.println("Hit wall");
		movementList[currentMovementIndex].onHitWall(e);
	}

	public void onPaint(Graphics2D g) {
		movementList[currentMovementIndex].onPaint(g);
	}

	public void onRobotDeath(RobotDeathEvent e) {
		pickBestMovementExcluding(-1);
	}

	public void onWin(WinEvent e) {
	}

	public void enemyFired(double shotPower, String enemyName, Point2D.Double enemyShotFromLoc) {
	}	

	/********************************************************************************
	 *                        For my WaveSurfing                                    *
	 *******************************************************************************/
	
	public void enemyWaveHitMe(String enemyName, EnemyWave ew) {
		// Assume enemy GF Gun segments: - DistSeg X GuessFactorBins 
		double [][]visitCounts;
		if(enemyGuessFactorVisitCounts.containsKey(enemyName)) {
			visitCounts = (double[][])enemyGuessFactorVisitCounts.get(enemyName);
		} else {
			visitCounts = new double[DynaBotConstants.NUM_DIST_SEG][DynaBotConstants.GUESSFACTORBINS];
			for(int i=0;i<DynaBotConstants.NUM_DIST_SEG;i++) {
				visitCounts[i][DynaBotConstants.GUESSFACTORMIDDLE_BIN] += 5;  // Default avoid HOT
			}
			enemyGuessFactorVisitCounts.put(enemyName, visitCounts);
		}
		
		double fireDist   = ew.fireLocation.distance(ew.fireTargetLocation);
		int distSeg = MyUtils.getDistanceBin(fireDist);
		int gfIndex = ew.getFactorIndex(myrobot.location);
		//myrobot.out.println("Enemywave hit: " + gfIndex);
		// Update GuessFactors
		for(int i=0;i<DynaBotConstants.GUESSFACTORBINS;i++) {
            // for the spot bin that we were hit on, add 1;
            // for the bins next to it, add 1 / 2;
            // the next one, add 1 / 5; and so on...
	        visitCounts[distSeg][i] += 1.0 / (Math.pow(gfIndex - i, 2) + 1);
		}
	
		enemyGuessFactorVisitCounts.put(enemyName, visitCounts);
	}

}