package sgp;
import robocode.*;
import java.util.*;
import java.awt.Color;

/**
 * DefenseStrategy - a class by Simon Parker
 */
public class EnemyBullet
{
	private Coordinate startingPosition = null;
	private double startingTime = -1;
	private double power = 0.1;
	private double bulletHeading_deg;

	private double BULLET_TIME_INFLUENCE = 100;
	private double MAX_DISTANCE = 150;

	public EnemyBullet(Coordinate startPos, double startTime, double bulletPower, double heading_deg)
	{
		BULLET_TIME_INFLUENCE = JollyNinja.getInstance().parameters.enemyBulletInfluenceTime.getValue();
		MAX_DISTANCE = JollyNinja.getInstance().parameters.enemyBulletMaxDistance.getValue();

		startingPosition = new Coordinate(startPos);
		startingTime = startTime;
		power = bulletPower;
		bulletHeading_deg = heading_deg;
	}

	public double getVelocity()
	{
		return 20 - 3 * power;
	}

	public Coordinate getPosition(double time)
	{
		return new Coordinate
		(
			startingPosition.x + getVelocity() * Math.sin(Math.toRadians(bulletHeading_deg)) * (time - startingTime),
			startingPosition.y + getVelocity() * Math.cos(Math.toRadians(bulletHeading_deg)) * (time - startingTime)
		);
	}

	public double getHeading_deg()
	{
		return bulletHeading_deg;
	}

	public double getAvoidanceGoodness(Coordinate robotPosition, double time)
	{
		Coordinate p0 = getPosition(time);
		Coordinate p1 = getPosition(time + BULLET_TIME_INFLUENCE);

		double distance = robotPosition.distanceFrom(p0, p1);

		if (distance > MAX_DISTANCE) distance = MAX_DISTANCE;

		return distance;
	}

	public boolean isThreatening(Coordinate robotPosition, double time)
	{
	/*
	 * not sure about this code
	 * 
		Coordinate p0 = getPosition(time);
		Coordinate p1 = getPosition(time + 1);

		Coordinate dBullet = p1.minus(p0);
		Coordinate dRobot = robotPosition.minus(p0);

		return (dRobot.dotProduct(dBullet) > 0.0);
	*/
	
		// if distance of the bullet from the starting position of the bullet 
		// is greater than the current distance of the robot from the starting 
		// position of the robot then the bullet can no longer hit us.
		
		double bulletDistance = startingPosition.distanceFrom(getPosition(time));
		double robotDistance = startingPosition.distanceFrom(robotPosition);
		
		return (bulletDistance < robotDistance);

	}

}