
package sgp;
import robocode.*;

public class ScannedEventBuffer
{
	ScanEvent[] eventArray = null;
	int nextIndex = 0;

	/**
	 * Constructor for ScannedEventBuffer.
	 */
	public ScannedEventBuffer()
	{
		this(500);
	}
	
	public ScannedEventBuffer(int bufferSize)
	{
		eventArray = new ScanEvent[bufferSize];
		nextIndex = 0;
	}
	
	public void add(Coordinate targetPosition, double relativeHeading_deg, double velocity, double distance,  double time)
	{
		eventArray[nextIndex] = new ScanEvent(targetPosition, relativeHeading_deg, velocity, distance,  Environment.getHeading(), time);
		nextIndex++;
		if (nextIndex >= eventArray.length) nextIndex = 0;
	}
	
	public int getClosestMatchIndex
	(
		double distance, double relativeHeading, double velocity, double advanceTime
	)
	{
		int bestIndex = 0;
		double bestErrorMagnitude = -1;
		double comparedErrorMagnitude = -1;
		
		for (int i = 0; i < eventArray.length; i++)
		{
			if (eventArray[i] == null) break;
			if (eventArray[i].time > (Environment.getTime() - advanceTime)) continue;
			
			comparedErrorMagnitude = eventArray[i].getError(distance, relativeHeading, velocity);
			if ((comparedErrorMagnitude < bestErrorMagnitude) || (bestErrorMagnitude < 0))
			{
				bestIndex = i;
				bestErrorMagnitude = comparedErrorMagnitude;
			}
		}
		return bestIndex;
	}
	
	public ScanEvent getEvent(int closestMatchIndex, double advanceTime)
	{
		int i = closestMatchIndex;
				
		while (true)
		{
			if (eventArray == null) 
			{
				return null;
			}
			if (eventArray[i] == null) 
			{
				return null;
			}
			if (eventArray[i].time < eventArray[closestMatchIndex].time) break;
			if (eventArray[i].time >= (eventArray[closestMatchIndex].time + advanceTime)) break;

			i++;
			if (i >= eventArray.length) i = 0;
		}
		
		return eventArray[i];
	}
	
}
