package tm;

import java.util.*;
import java.io.*;
import robocode.*;

/********************************************************************
* SelecterYK.java -- XgeWZN^
*                    for [
*
* Date:		2002/Nov/13
*			2002/Dec/18
* Author:	Matunaga Takateru@RISE, Eng, Kagawa Univ.
*
*******************************************************************/
public class SelecterYK {
	ArrayList moveList = new ArrayList();
	ArrayList gunList = new ArrayList();
	ArrayList moveName = new ArrayList();
	ArrayList gunName = new ArrayList();
	
	MyRobot my;
	
	static int[][] damageTable = new int[1][1];			//_[W
	static int[][] timeTable = new int[1][1];
	static int[][] hitTable = new int[1][1];			//^_[W
	static int[][] fireTable = new int[1][1];			//fire
	static int[][] winTable = new int[1][1];
	static int[][] roundTable = new int[1][1];
	static double[][] bulletPowerTable = new double[1][1];
	
	int hitTableM, hitTableF;							//ŋߗp
	int damageTableM, damageTableF;
	double bulletPowerTableM, bulletPowerTableF;

	int moveIndex = 0;
	int gunIndex = 0;
	int lastMoveIndex = 1;
	static boolean initTable = false;
	int useMoveCount = 0, useMoveMax = 0;
	Random rand = new Random(System.currentTimeMillis());
	int DO_ROUND = 5;										//vƂŏEh
	static double scoreM, scoreF;
	double totalScoreM, totalScoreF;
	static int totalRound;
	
	//---------------------------------------------------------
	// constructor
	//
	//
	//---------------------------------------------------------
	public SelecterYK(MyRobot my) {
		this.my = my;
	}
	
	//---------------------------------------------------------
	// init()
	//
	//
	//---------------------------------------------------------
	void init() {
		DO_ROUND = (int)(my.getNumRounds() * 0.2 + 0.5);
		if (DO_ROUND > 20) DO_ROUND = 20;
	}

	//---------------------------------------------------------
	// loadfile()
	//
	//
	//---------------------------------------------------------
	void loadfile(String filename) {
		File file = my.getDataFile(filename);
		
		if (!file.exists()) {
			M.print("File not found!!! -- " + file);
			return;	
		}
		
		try {
			BufferedReader reader = new BufferedReader(new FileReader(file));
			String line;
			
			line = reader.readLine();
			totalRound = Integer.parseInt(line);
			line = reader.readLine();
			scoreM = Double.parseDouble(line);
			line = reader.readLine();
			scoreF = Double.parseDouble(line);
						
			reader.close();
		} catch (Exception e) {
			M.print("Exception!! -- " + e);
		}
	}
		
	//-------------------------------------------
	// savefile()
	//
	//-------------------------------------------
	void savefile(String filename) {
		File file = my.getDataFile(filename);
		
		selectYK2();		//scorevZ
		int rou = totalRound + my.getNumRounds();
		if (rou > 1000) rou = 1000;
		
		try {
 			PrintWriter writer = new PrintWriter(new BufferedWriter(new RobocodeFileWriter(file)));
			writer.println(rou);
			writer.println(totalScoreM);
			writer.println(totalScoreF);
			writer.close();
		} catch (IOException e) {
			System.out.println("Exception!! -- " + e);	
		}
	}
	
	//---------------------------------------------------------
	//
	//
	//
	//---------------------------------------------------------
	void setMelee() {
		initTable = false;
	}
			
	//---------------------------------------------------------
	//
	//
	//
	//---------------------------------------------------------
	private void addMove(Move m, String name) {
		moveList.add(m);
		moveName.add(name);
	}
	
	//---------------------------------------------------------
	//
	//
	//
	//---------------------------------------------------------
	private void addGun(Gun1on1 g, String name) {
		gunList.add(g);
		gunName.add(name);
	}

	//------------------------------------------------------------------
	// addMoveAngGun() -- for [
	//
	//
	//------------------------------------------------------------------
	void addMoveAndGun(Move m1, Move m2, Move m3, Gun1on1 g1, Gun1on1 g2) {
		addMove(m1, "Crazy ");
		addMove(m2, "Middle");
		addMove(m3, "Away  ");
		addGun(g1, "G102C22i");
		addGun(g2, "G102Ci");
	}
	
	//---------------------------------------------------------
	//
	//
	//
	//---------------------------------------------------------
	void addEnd() {
		if (!initTable) {
			initTable = true;
			damageTable = new int[moveList.size()][gunList.size()];
			timeTable = new int[moveList.size()][gunList.size()];
			hitTable = new int[moveList.size()][gunList.size()];
			fireTable = new int[moveList.size()][gunList.size()];
			winTable = new int[moveList.size()][gunList.size()];
			roundTable = new int[moveList.size()][gunList.size()];
			bulletPowerTable = new double[moveList.size()][gunList.size()];
		}
	}
	
	//---------------------------------------------------------
	// damage()
	//
	//
	//---------------------------------------------------------
	void damage(double bulletPower) {
		damageTable[moveIndex][gunIndex] += (int)(4 * bulletPower + (bulletPower > 1 ? 2 * (bulletPower - 1) : 0) + 0.5);

		if (moveIndex == 1) {
			damageTableM += (int)(4 * bulletPower + (bulletPower > 1 ? 2 * (bulletPower - 1) : 0) + 0.5);
		} else if (moveIndex == 2) {
			damageTableF += (int)(4 * bulletPower + (bulletPower > 1 ? 2 * (bulletPower - 1) : 0) + 0.5);		
		}
	}
	
	//---------------------------------------------------------
	//
	//
	//
	//---------------------------------------------------------
	void hit(double bulletPower) {
		hitTable[moveIndex][gunIndex] += (int)(4 * bulletPower + (bulletPower > 1 ? 2 * (bulletPower - 1) : 0) + 0.5);

		if (moveIndex == 1) {
			hitTableM += (int)(4 * bulletPower + (bulletPower > 1 ? 2 * (bulletPower - 1) : 0) + 0.5);
		} else if (moveIndex == 2) {
			hitTableF += (int)(4 * bulletPower + (bulletPower > 1 ? 2 * (bulletPower - 1) : 0) + 0.5);		
		}
	}
	
	//---------------------------------------------------------
	//
	//
	//
	//---------------------------------------------------------
	void fire(double bulletPower) {
		fireTable[moveIndex][gunIndex] += 1;
		bulletPowerTable[moveIndex][gunIndex] += bulletPower;
		
		if (moveIndex == 1) {
			bulletPowerTableM += bulletPower;
		} else if (moveIndex == 2) {
			bulletPowerTableF += bulletPower;
		}
	}

	//---------------------------------------------------------
	//
	//
	//
	//---------------------------------------------------------
	void addTime(long t) {
		timeTable[moveIndex][gunIndex] += (int)t;	
	}

	//---------------------------------------------------------
	//
	//
	//
	//---------------------------------------------------------
	void win() {
		winTable[moveIndex][gunIndex] += 1;
	}
	
	//---------------------------------------------------------
	//
	//
	//
	//---------------------------------------------------------
	void addRound() {
		roundTable[moveIndex][gunIndex] += 1;
	}
	
	//------------------------------------------------------------------
	// selectYK() -- [p Move Gun Ԃ
	//
	// F
	//
	//------------------------------------------------------------------
	MoveAndGun selectYK() {
		double rateM, rateF, rate;
		MoveAndGun mg = null;
		
			
		if (moveIndex == 0) {
			moveIndex = lastMoveIndex;
			mg = new MoveAndGun();
			mg.move = (Move)moveList.get(moveIndex);
			mg.gun = (Gun1on1)gunList.get(gunIndex);
		
			return mg;
		}
		
		
		double rateMTotal, rateFTotal, rateMCurr, rateFCurr;
		
		rateMTotal = (double)(hitTable[1][0] + 30) / (damageTable[1][0] + bulletPowerTable[1][0] + 100);
		rateFTotal = (double)(hitTable[2][1] + 30) / (damageTable[2][1] + bulletPowerTable[2][1] + 100);
		rateMCurr = (double)(hitTableM + 30) / (damageTableM + bulletPowerTableM + 100);
		rateFCurr = (double)(hitTableF + 30) / (damageTableF + bulletPowerTableF + 100);
		
		rate = (rateMTotal * 2 + rateMCurr) / (rateFTotal * 2 + rateFCurr);
		

		//Move change
		useMoveCount++;
		if (useMoveCount > useMoveMax) {							
			useMoveCount = 0;

			if (moveIndex == 1) {
				hitTableF = 0;
				damageTableF = 0;
				bulletPowerTableF = 0;
				
				moveIndex = 2;
				gunIndex = 1;
				useMoveMax = (int)(5  + 10 * ((1 / rate) - 1) + rand.nextInt(1) + 0.5);
				if (useMoveMax > 15) useMoveMax = 15;
				else if (useMoveMax < 1) useMoveMax = 1;
				mg = new MoveAndGun();
				mg.move = (Move)moveList.get(moveIndex);
				mg.gun = (Gun1on1)gunList.get(gunIndex);
				return mg;
			} else {
				hitTableM = 0;
				damageTableM = 0;
				bulletPowerTableM = 0;

				moveIndex = 1;
				gunIndex = 0;
				useMoveMax = (int)(5 + 10 * (rate - 1) + rand.nextInt(1) + 0.5);
				if (useMoveMax > 15) useMoveMax = 15;
				else if (useMoveMax < 1) useMoveMax = 1;
				mg = new MoveAndGun();
				mg.move = (Move)moveList.get(moveIndex);
				mg.gun = (Gun1on1)gunList.get(gunIndex);	
				return mg;
			}
		}
		
		return null;
	}
	
	//------------------------------------------------------------------
	// selectYK2() -- [p Move Gun Ԃ
	//                EhƂɑIꍇ
	//
	//
	//------------------------------------------------------------------
	MoveAndGun selectYK2() {
		double partScoreM, partScoreF;
		MoveAndGun mg = null;
		
		//ŏ
		if (my.rounds == 1) {
			if (Math.random() < 0.5) {
				// moveMid
				moveIndex = 1;
				gunIndex = 0;
				mg = new MoveAndGun();
				mg.move = (Move)moveList.get(moveIndex);
				mg.gun = (Gun1on1)gunList.get(gunIndex);	
				return mg;				
			} else {
				// moveFar Ԃ
				moveIndex = 2;
				gunIndex = 1;
				mg = new MoveAndGun();
				mg.move = (Move)moveList.get(moveIndex);
				mg.gun = (Gun1on1)gunList.get(gunIndex);
				return mg;				
			}
		}
		
		//ŏEhɒBĂȂꍇ
		if (roundTable[1][0] < roundTable[2][1]) {
			if (roundTable[1][0] < DO_ROUND) {
				// moveMid Ԃ
				moveIndex = 1;
				gunIndex = 0;
				mg = new MoveAndGun();
				mg.move = (Move)moveList.get(moveIndex);
				mg.gun = (Gun1on1)gunList.get(gunIndex);	
				return mg;
			}
		} else {
			if (roundTable[2][1] < DO_ROUND) {
				// moveFar Ԃ
				moveIndex = 2;
				gunIndex = 1;
				mg = new MoveAndGun();
				mg.move = (Move)moveList.get(moveIndex);
				mg.gun = (Gun1on1)gunList.get(gunIndex);
				return mg;
			}
		}


		//07
		partScoreM = (double)winTable[1][0] / (roundTable[1][0] - winTable[1][0] + 1) + (double)hitTable[1][0] / (damageTable[1][0] + 1);
		partScoreF = (double)winTable[2][1] / (roundTable[2][1] - winTable[2][1] + 1) + (double)hitTable[2][1] / (damageTable[2][1] + 1);

		
		if (scoreM == 0 && scoreF == 0) {
			totalScoreM = partScoreM;
			totalScoreF = partScoreF;	
		} else {
			double ratio = (double)my.rounds / (my.rounds + totalRound);
			if (ratio < 0.1) ratio = 0.1;
			else if (ratio > 0.9) ratio = 0.9;
			totalScoreM = partScoreM * ratio + scoreM * (1 - ratio);
			totalScoreF = partScoreF * ratio + scoreF * (1 - ratio);
		}

		if (totalScoreM > totalScoreF) {
			// moveMid Ԃ
			moveIndex = 1;
			gunIndex = 0;
			mg = new MoveAndGun();
			mg.move = (Move)moveList.get(moveIndex);
			mg.gun = (Gun1on1)gunList.get(gunIndex);	
			return mg;		
		} else {
			// moveFar Ԃ
			moveIndex = 2;
			gunIndex = 1;
			mg = new MoveAndGun();
			mg.move = (Move)moveList.get(moveIndex);
			mg.gun = (Gun1on1)gunList.get(gunIndex);
			return mg;		
		}
	}
	
	//---------------------------------------------------------
	//
	//
	//
	//---------------------------------------------------------
	void printDamageTable() {
		printTable(damageTable, "Damage Table");	
	}
	
	//---------------------------------------------------------
	//
	//
	//
	//---------------------------------------------------------
	void printTimeTable() {
		printTable(timeTable, "Time Table");	
	}

	//---------------------------------------------------------
	//
	//
	//
	//---------------------------------------------------------
	void printHitTable() {
		printTable(hitTable, "Hit Table");	
	}

	//---------------------------------------------------------
	//
	//
	//
	//---------------------------------------------------------
	void printFireTable() {
		printTable(fireTable, "Fire Table");	
	}

	//---------------------------------------------------------
	//
	//
	//
	//---------------------------------------------------------
	void printWinTable() {
		printTable(winTable, "Win Table");	
	}

	//---------------------------------------------------------
	//
	//
	//
	//---------------------------------------------------------
	void printRoundTable() {
		printTable(roundTable, "Round Table");
	}

	//---------------------------------------------------------
	//
	//
	//
	//---------------------------------------------------------
	void printBulletPowerTable() {
		printTable(bulletPowerTable, "BulletPower Table");	
	}
		
	//---------------------------------------------------------
	//
	//
	//
	//---------------------------------------------------------				
	private void printTable(int[][] table, String name) {
		int i, j;
		M.print("----- " + name);
		
		for (i = 0; i < gunList.size(); i++) {
			System.out.print("   " + (String)gunName.get(i));
		}
		M.print("");
		M.print("-----------------------------------------------------");
		for (i = 0; i < moveList.size(); i++) {
			System.out.print(moveName.get(i) + "\t| ");
			for (j = 0; j < gunList.size(); j++) {
				System.out.print(table[i][j] + "\t");
			}
			M.print("");
		}
		M.print("");
	}

	//---------------------------------------------------------
	//
	//
	//
	//---------------------------------------------------------				
	private void printTable(double[][] table, String name) {
		int i, j;
		M.print("----- " + name);
		
		for (i = 0; i < gunList.size(); i++) {
			System.out.print("   " + (String)gunName.get(i));
		}
		M.print("");
		M.print("-----------------------------------------------------");
		for (i = 0; i < moveList.size(); i++) {
			System.out.print(moveName.get(i) + "\t| ");
			for (j = 0; j < gunList.size(); j++) {
				System.out.print((int)table[i][j] + "\t");
			}
			M.print("");
		}
		M.print("");
	}
}