package kawigi.spare.parts;
import robocode.*;
import kawigi.spare.util.*;
/**
 * RandomMovement - randomly moves in various directions
 */
public class RandomMovement extends MovementStrategy implements java.io.Serializable
{
	private transient double currentDirection;
	private transient long changeTime;
	private transient boolean back, moving;
	
	public RandomMovement(AdvancedRobot robot, TargetSelector targetter)
	{
		super(robot, targetter);
		back = false;
		changeTime = 0;
		moving = true;
	}
	
	public void onEvent(Event e)
	{
		if (e instanceof HitWallEvent)
			newDirection();
		else if (e instanceof HitRobotEvent)
			if (((HitRobotEvent)e).isMyFault())
				newDirection();
	}
	
	private void newDirection()
	{
		EnemyState closest = getClosestEnemy();
		EnemyState target = getTarget();
		int time = (int)(Math.random()*20)+10;
		if (closest != null)
			time = (int)(closest.getDistance(robot.getX(), robot.getY())/14);
		do
			if (target != null)
				currentDirection = Math.atan2(Math.random()*6-3, Math.random()*2-1)+target.getAbsoluteBearing(robot.getX(), robot.getY());
			else
				currentDirection = Math.random()*Math.PI*2-Math.PI;
		while (willHitWall());
		time = Math.max(time, 30);
		changeTime = robot.getTime() + time;
		moving = (Math.random() < .95);
	}
	
	public void setAction()
	{
		if (robot.getTime() > changeTime || willHitWall())
			newDirection();
		turn(currentDirection-robot.getHeadingRadians());
		if (moving)
			if (back)
				robot.setBack(40);
			else
				robot.setAhead(40);
		back = false;
	}
	
	public void turn(double angle)
	{
		while (angle < -Math.PI)
			angle += Math.PI*2;
		while (angle > Math.PI)
			angle -= Math.PI*2;
		if (angle < -Math.PI/2)
		{
			back = true;
			angle += Math.PI;
		}
		else if (angle > Math.PI/2)
		{
			back = true;
			angle -= Math.PI;
		}
		if (angle > 0)
			robot.setTurnRightRadians(angle);
		else
			robot.setTurnLeftRadians(-angle);
	}
	
	public boolean willHitWall()
	{
		double projX = Math.sin(currentDirection)*robot.getWidth();
		double projY = Math.cos(currentDirection)*robot.getWidth();
		if (back)
		{
			projX = robot.getX() - projX;
			projY = robot.getY() - projY;
		}
		else
		{
			projX += robot.getX();
			projY += robot.getY();
		}
		return (projX < robot.getWidth() || projY < robot.getWidth() || projX > robot.getBattleFieldWidth()-robot.getWidth() || projY > robot.getBattleFieldHeight()-robot.getWidth());
	}
}
