package kawigi.spare.parts;
import robocode.*;
import kawigi.spare.util.*;
/**
 * RandomRangeGun - picks a random aiming in the range of those an opposing robot could reach
 */
public class RandomRangeGun extends Gun implements java.io.Serializable
{
	
	public RandomRangeGun(AdvancedRobot robot)
	{
		super(robot);
	}
	
	public void onEvent(Event e)
	{
	}
	
	public ChooserBullet getVirtualBullet(EnemyState target)
	{
		if (target == null)
			return null;
		double power;
		if (robot.getEnergy() >= 15 || target.getEnergy() == 0)
			power = 3;
		else
			power = .2*robot.getEnergy();
		double bulletv = 20-3*power;
		double vel = Math.max(Math.abs(target.getVelocity()), target.getRecentAverageVelocity());
		double[] angles = new double[6];
		angles[0] = getAngle2(0, bulletv, vel, target.getHeading(), target.getX(), target.getY());
		angles[1] = getAngle2(0, bulletv, -vel, target.getHeading(), target.getX(), target.getY());
		angles[2] = getAngle2(Math.PI/36, bulletv, vel, target.getHeading(), target.getX(), target.getY());
		angles[3] = getAngle2(Math.PI/36, bulletv, -vel, target.getHeading(), target.getX(), target.getY());
		angles[4] = getAngle2(-Math.PI/36, bulletv, vel, target.getHeading(), target.getX(), target.getY());
		angles[5] = getAngle2(-Math.PI/36, bulletv, -vel, target.getHeading(), target.getX(), target.getY());
		double min = 100, max = -100;
		for (int i=0; i<6; i++)
		{
			if (min > angles[i])
				min = angles[i];
			if (max < angles[i])
				max = angles[i];
		}
		double theta = min + Math.random()*(max-min);
		return new ChooserBullet(target.getName(), robot.getX(), robot.getY(), theta, power, this, robot.getTime());
	}
	
	private double getAngle(double wamba, double bulletv, double vel, double heading, double ex, double ey)
	{
		double bulletdistance = 0;
		while(bulletdistance < Math.sqrt((ex-robot.getX())*(ex-robot.getX())+(ey-robot.getY())*(ey-robot.getY())))
		{
			bulletdistance += bulletv;
			ex += vel*Math.sin(heading);
			ey += vel*Math.cos(heading);
			heading += wamba;
			if (ex < 18 || ex > robot.getBattleFieldWidth()-18 || ey < 18 | ey > robot.getBattleFieldHeight()-18)
				break;	//hit the wall
		}
		double theta = Math.atan2(ex-robot.getX(), ey-robot.getY())-robot.getGunHeadingRadians();
		theta = ((theta + Math.PI)%(Math.PI*2)-Math.PI*2)%(Math.PI*2)+Math.PI;
		return theta;
	}
	
	private double getAngle2(double wamba, double bulletv, double vel, double heading, double ex, double ey)
	{
		double bulletdistance = 0;
		while(bulletdistance < Math.sqrt((ex-robot.getX())*(ex-robot.getX())+(ey-robot.getY())*(ey-robot.getY())))
		{
			bulletdistance += bulletv;
			ex += vel*Math.sin(heading);
			ey += vel*Math.cos(heading);
			heading += wamba;
			if (ex < 18 || ex > robot.getBattleFieldWidth()-18 || ey < 18 | ey > robot.getBattleFieldHeight()-18)
				break;	//hit the wall
		}
		double theta = Math.atan2(ex-robot.getX(), ey-robot.getY());
		return theta;
	}
}
