package wiki.mini;
import robocode.*;
import java.awt.Color;
import java.util.Vector;
import java.awt.geom.*;
import java.io.*;
import java.util.zip.*;
/**
 *+++++++++++++++++++++++++++Author Info++++++++++++++++++++++++++
 *--
 * @author:iiley (iiley@hotmail.com)
 * http://www.robochina.org
 * co-author - kawigi (kawigi@yajags.com)
 *++++++++++++++++++++++++++++Bot Info++++++++++++++++++++++++++++
 *-- Sedan 1.0 - A car with four doors.  What would happen if you combine the most outstanding movement ever
 *   put into a MiniBot with a gun from one of the few MiniBots that could give it a fight?  What happens is
 *   a MiniBot that beats SandboxDT 2.01 over 1000 rounds reasonably consistently.
 * Movement is borrowed from Cigaret 1.31, The aiming algorithm belongs to FloodMini 1.4.  If
 * ideas or code are borrowed from this source file, credit those two bots for the ideas.
 *+++++++++++++++++++++++++++++++++Open Source++++++++++++++++++++
 *--
 * This bot is open source. 
 * - Don't just copy-paste the code .
 * - Don't just copy-paste and then improve.(I don't want to fight modified versions of my own bot)
 * - Maybe some useful skill in this codes,if you use,Make your bot open source
 * - And preferably give credit.:)
 *
 * If you want to know more or suggest,
 * email me or post messages on www.robochina.org or www.robocoderepository's forums.
 * every messages will be pleasent.
 *--
 */
public class Sedan extends AdvancedRobot
{
    private static double preDiffAngle;           //what radians the gun need turn
	private static double power=0;                //fire power
	private static double enemyEnergy;            //enemy's energy
	private static double lastEnemyBulletPower;   //enemy's last bullet's power
	private static long   enemyLastFireTime;      //the time when enemy last fire
	private static int[][][][][] stats;
	private static String name;
	private double lastv;
	private static int direction = 1;
	private static Vector ovbullets;
	
	public void run( ) {
		ovbullets = new Vector();
		//Keeping the Cigaret white, but I thought I'd spice it up with some Flood blue.
		setColors(Color.white,Color.white,Color.blue);
		setAdjustGunForRobotTurn(true);
		turnRadarRight(Double.POSITIVE_INFINITY);
	} 

    // -------------------- function for event handle ---------------
    public void onBulletHit(BulletHitEvent e){
		enemyEnergy=e.getEnergy();
	}
    public void onHitByBullet(HitByBulletEvent e){
		enemyEnergy+=e.getPower()*3d;
	}
    public void onHitRobot(HitRobotEvent e){
		enemyEnergy-=0.6d;
	}

   	public void onScannedRobot( ScannedRobotEvent e ) {
	
		if (name == null)
		{
			name = e.getName();
			try
			{
				ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(getDataFile(name))));
				stats = (int[][][][][])in.readObject();
				in.close();
			}
			catch (Exception ex)
			{
				// wall, accl, latv, distance, guessfactors 
				stats = new int[2][3][3][10][31];
			}
		}
		
	    int i;
        long time=getTime();
		double moveAngle,L,disAngle,moveDistance,moveDirection,edistance,absBearing;
		Point2D.Double enemyPos,myPos,centerPos,nextP=null;
		enemyPos=nextPoint(myPos=new Point2D.Double(getX(),getY()),
			absBearing=robocode.util.Utils.normalRelativeAngle(e.getBearingRadians()+getHeadingRadians()),
            moveDistance=edistance=e.getDistance());
        centerPos=new Point2D.Double(getBattleFieldWidth()/2,getBattleFieldHeight()/2);
		// Radar turn grabed from David Alves.
		//setTurnRadarRightRadians(Math.sin(absBearing - getRadarHeadingRadians()));

		//--------------movement---------------------
		double energyChange=enemyEnergy-e.getEnergy();
        enemyEnergy=e.getEnergy();
		if(Math.abs(energyChange-1.55)<1.46){
			lastEnemyBulletPower=energyChange;
			enemyLastFireTime=time;
		}
		//boolean isRam=time-enemyLastFireTime>50;

		if(Math.abs(getDistanceRemaining())<53d){// || isRam){
            if(Math.abs(energyChange-1.55)<1.46  || edistance<200d){
				double xieAngle=Math.abs((absBearing+Math.PI*2)%(Math.PI/2d));
				boolean isCloseToCenter=myPos.distance(centerPos)<centerPos.distance(0d,0d)/2d;
				boolean isVerticle=xieAngle<Math.PI/8d || xieAngle>Math.PI*7d/8d || isCloseToCenter;
				disAngle=2d*Math.asin(4d/(20d-lastEnemyBulletPower*3d));
				if(isVerticle){
			    	disAngle=Math.asin(8d/(20d-lastEnemyBulletPower*3d));
				}
				disAngle+=25d/edistance;
				moveDistance=Math.max(170d,moveDistance);
				do{
		    		moveAngle=Math.random()*disAngle*2-disAngle;
					L=moveDistance;
		    		if(isVerticle){
    			    	L/=Math.cos(moveAngle);
		    		}
					moveDistance-=10d;
				}while(distanceToWall(nextP=nextPoint(enemyPos,absBearing+moveAngle,-L))<24d);
			}else if(getDistanceRemaining()==0d){
				//keep around enemy,keep enemy be 90 angle bearing me.
		        nextP=nextPoint(enemyPos,absBearing+0.000001d,-edistance);
	    	}
			//if(isRam)
			//  	nextP=enemyPos;
			if(nextP!=null){
                //thanks to David Alves and Dummy for this small code to find which direction is shortest to our next destination
		    	//Thanx DrLoco of this usage
	    		setAhead(
	    		 (
		    		( 
		    		moveAngle = robocode.util.Utils.normalRelativeAngle(
				                  Math.atan2( nextP.x-myPos.x,nextP.y-myPos.y) - getHeadingRadians() 
				                  ) 
		    		) == ( moveDistance = Math.atan( Math.tan( moveAngle ) ) 
					) ? 1 : - 1 ) * myPos.distance(nextP) );	//move towards point
		    setTurnRightRadians( moveDistance );
			}
		}
    	setMaxVelocity( Math.abs(getTurnRemaining()) > 45 ? 0d : 8d );
		
		double latvel;
		int latv = (int)Math.abs((latvel = Math.sin(e.getHeadingRadians()-absBearing)*e.getVelocity())/3);
		int accl = (int)Math.round(Math.abs(lastv)-Math.abs(lastv = e.getVelocity()));
		if (accl != 0)
			accl = (accl < 0)? 1 : 2;
		
		if (latvel != 0)
			direction = (latvel < 0)?-1:1;
		
		int wallrel = ((new Rectangle2D.Double(18, 18, getBattleFieldWidth()-18, getBattleFieldHeight()-18).contains(nextPoint(enemyPos, e.getHeadingRadians(), (e.getVelocity() < 0) ? -80 : 80)))) ? 0 : 1;
		i=0;
		while (i < ovbullets.size())
		{
			MiniBullet b = (MiniBullet)ovbullets.elementAt(i);
			int ind;
			if ((ind = Math.min(30, b.updateEnemy(enemyPos.getX(), enemyPos.getY(), time))) >= 0)
			{
				stats[b.wallrel][b.accl][b.latspeed][b.dindex][ind]++;
				ovbullets.removeElementAt(i);
			}
			else
				i++;
		}
		int bestindex = 15;
		int dindex2;
		//latvel is now the bullet speed, denergy is now my bullet power:
		double power;
		int[] current = stats[wallrel][accl][latv][dindex2 = (int)(edistance/10/(latvel = 20-(power = Math.min(Math.min(enemyEnergy, getEnergy())/4, 3))*3))];
		i=0;
		if (enemyEnergy > 0)
			do
			{
				if (current[i] > current[bestindex])
					bestindex = i;
				i++;
			}
			while(i<31);
		double realdirection;
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absBearing-getGunHeadingRadians()+(realdirection = Math.asin(9/latvel)*direction)*(bestindex/15.0-1)));
		//if (!isRam)
			setFire(power);
		//turns out that initializing the bullet this way saves only 3 bytes less codesize as it took to make the 
		//bullet variable-speed and segment on projected bullet travel time instead of distance.  Pretty cool, huh?
		MiniBullet mb;
		ovbullets.addElement(mb = new MiniBullet());
		mb.dindex = dindex2;
		mb.accl = accl;
		mb.latspeed = latv;
		mb.wallrel = wallrel;
		mb.startgunheading = absBearing;
		mb.direction = realdirection;
		mb.startx = getX();
		mb.starty = getY();
		mb.lastx = enemyPos.getX();
		mb.lasty = enemyPos.getY();
		mb.firetime = mb.lasttime = time;
		mb.bulletspeed = latvel;
		setTurnRadarLeft(getRadarTurnRemaining());
    }
	public double distanceToWall(Point2D.Double p){
		return Math.min(Math.min(p.x,getBattleFieldWidth()-p.x),Math.min(p.y,getBattleFieldHeight()-p.y));
	}
	public static Point2D.Double nextPoint(Point2D.Double originPoint,double angle,double distance){
		return new Point2D.Double(originPoint.x+Math.sin(angle)*distance,originPoint.y+Math.cos(angle)*distance);
	}
	
	public void onWin(WinEvent e)
	{
		try
		{
			ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(new RobocodeFileOutputStream(getDataFile(name))));
			out.writeObject(stats);
			out.close();
		}
		catch (IOException ex)
		{
		}
	}
}
