
package sgp.nano;

import robocode.*;

public class FurryLeech extends AdvancedRobot
{
	private static double m_TurnAngle_rad;
	private static double m_AheadMovementDistance;
	private static double m_TangentVelocity;
	
	/**
	 * The behaviour
	 */
	public void run()
	{
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setAdjustRadarForRobotTurn(true);
		
		while (true)
		{		
			setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
			setAhead(m_AheadMovementDistance);			
			setTurnRightRadians(m_TurnAngle_rad);

			fire(3.0);
		}
	}

	public void onScannedRobot(ScannedRobotEvent event) 
	{
		double absBearing_rad = event.getBearingRadians() + getHeadingRadians();
		double relativeHeading = event.getHeadingRadians() - absBearing_rad;
		
		//double N = 30;
		m_TangentVelocity = (1.0 / 30) * event.getVelocity() * Math.sin(relativeHeading) + ((30 - 1) / 30) * m_TangentVelocity;

		setTurnGunRightRadians(Math.asin(Math.sin(absBearing_rad - getGunHeadingRadians() + Math.asin(m_TangentVelocity / (20-3*2.0)))));

		double eX = getBattleFieldWidth()  - 2 * getX() - event.getDistance() * Math.sin(absBearing_rad);
		double eY = getBattleFieldHeight() - 2 * getY() - event.getDistance() * Math.cos(absBearing_rad);
		
		double desiredHeading_rad;
		if (Math.abs(eX) > Math.abs(eY))
		{
			desiredHeading_rad = Math.PI / 2.0;
			m_AheadMovementDistance = Math.sin(getHeadingRadians()) * eX * 1000;
		}
		else
		{
			desiredHeading_rad = 0;
			m_AheadMovementDistance = Math.cos(getHeadingRadians()) * eY * 1000;
		}
		
		m_TurnAngle_rad = Math.asin(Math.sin(getHeadingRadians() - desiredHeading_rad));
				
	}
	
	

}
