package ags.muse.physics;

import ags.util.points.AbsolutePoint;
import ags.util.points.RelativePoint;
import robocode.Rules;

public class RobotSimV2 {
    private static final double DECEL = robocode.Rules.DECELERATION;
    private static final double ACCEL = robocode.Rules.ACCELERATION;
    private static final double ACCEL_DECEL_RATIO = ACCEL/DECEL;
    private static final double MAX_VEL = robocode.Rules.MAX_VELOCITY;
    private double x, y, velocity, heading;
    private double cacheheading = 0, cachesin = 0, cachecos = 1;

    public RobotSimV2(AbsolutePoint p, RelativePoint v) {
        this(p.x, p.y, v.magnitude, v.direction);
    }

    public RobotSimV2(double x, double y, double velocity, double heading) {
        this.x = x;
        this.y = y;
        this.velocity = velocity;
        this.heading = heading;
    }

    public void simTick(double intendedVelocity, double intendedTurn) {
        /* Calculate turning */
        if (intendedTurn != 0) {
            double maxTurn = Rules.getTurnRateRadians(Math.abs(velocity));
            double turn = Math.max(Math.min(intendedTurn, maxTurn), -maxTurn);
            heading += turn;
        }

        if (velocity != intendedVelocity) {
            // Flips so current velocity is positive
            int dir = (velocity > 0) ? 1 : -1;
            velocity *= dir;
            intendedVelocity *= dir;

            if (velocity > intendedVelocity) {
                // Decel
                velocity -= DECEL;
                if (velocity < 0) {
                    // If decelerated past zero, consider reduced acceleration
                    velocity *= ACCEL_DECEL_RATIO;
                }
                velocity = Math.max(Math.max(velocity, intendedVelocity), -MAX_VEL);
            } else if (velocity < intendedVelocity) {
                // Accel
                velocity = Math.min(Math.min((velocity + ACCEL), intendedVelocity), MAX_VEL);
            }

            // Flips back
            velocity *= dir;
        }

        if (heading != cacheheading) {
            cacheheading = heading;
            cachesin = Math.sin(heading);
            cachecos = Math.cos(heading);
        }

        x += velocity*cachesin;
        y += velocity*cachecos;
    }

    public double getX() {
        return x;
    }

    public double getY() {
        return y;
    }

    public double getVelocity() {
        return velocity;
    }

    public double getHeading() {
        return heading;
    }
}
