/*
 * Created on Aug 4, 2003
 *
 */
package jekl;

import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;
import java.awt.Color;
import java.text.*;
import jekl.utils.*;
import jekl.gunnery.*;
import jekl.movement.*;

/**
 * @author jbishop
 *
 */

public class DarkHallow extends AdvancedRobot implements Constants {
	public  static Rectangle2D.Double field;
	public  static int numHits = 0;
	private static int eShots, eHits, myWins, myShots, myHits, wallHits, hitsThisRound = 0;
	private static NumberFormat nf = NumberFormat.getInstance();
	public static double WIDTH, HEIGHT;
	private Point2D.Double targetLocation;
	public Enemy target;
	public Gun gun;
	public Move move;

    public void run() {
		setColors(Color.red, Color.lightGray, Color.black); 
	    field = new Rectangle2D.Double(EDGE, EDGE, (WIDTH = getBattleFieldWidth()) - 2 * EDGE, (HEIGHT = getBattleFieldHeight()) - 2 * EDGE);
		targetLocation = new Point2D.Double();
		gun = new WaveGun(this);
        move = new SurfMove(this);
        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);
		nf.setMaximumFractionDigits(3);
		hitsThisRound = 0;
		//setEventPriority("ScannedRobotEvent", 99);
        do {
            turnRadarRightRadians(Double.POSITIVE_INFINITY);
        } while (true);
    }

    public void printStats() {
		if (DEBUG) {
			System.out.println("\n");
			System.out.println("Win: " + nf.format((double)myWins / (getRoundNum() + 1) * 100D) + " (" + myWins + "/" + (getRoundNum() + 1) + ")");
			System.out.println("His hit: " + nf.format((double) eHits / eShots * 100D) + " Per Round: " + nf.format((double) eHits / (getRoundNum() + 1)));
			System.out.println("My Hit: " + nf.format((double) myHits / myShots * 100D) + " Per Round: " + nf.format((double) myHits / (getRoundNum() + 1)));
			System.out.println("Wall Hits: " + wallHits + " HTR: " + hitsThisRound);
			move.printHits();
			System.out.println("\n");
		}    	
    }
    
    public void onScannedRobot(ScannedRobotEvent e) {

		if (target == null || !target.getName().equalsIgnoreCase(e.getName())) {
			target = new Enemy(e.getName());
		}

		target.setEnergy(e.getEnergy());
        target.setVelocity(e.getVelocity());
        target.setHeading(e.getHeadingRadians());
        target.setDistance(e.getDistance());
        target.setAbsBearing(Utils.normalRelativeAngle(getHeadingRadians() + e.getBearingRadians()));
		targetLocation.setLocation(getX() + (Math.sin(target.getAbsBearing()) * target.getDistance()) , getY() + (Math.cos(target.getAbsBearing()) * target.getDistance()));
		target.setLocation(targetLocation);
		target.setLatVel(target.getVelocity() * Math.sin(target.getHeading() - target.getAbsBearing()));
		target.setClosingVelocity(target.getVelocity() * Math.cos(target.getHeading() - target.getAbsBearing()));
		target.setBearing(e.getBearingRadians());
		if (target.getLatVel() != 0) {
			target.setDirection((int)(Math.abs(target.getLatVel()) / target.getLatVel()));
		}
        //Radar
        setTurnRadarRightRadians(Math.sin(target.getAbsBearing() - getRadarHeadingRadians()) *  2);

		move.onScannedRobot(e);
		gun.onScannedRobot(e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
		target.setEnergy(target.getEnergy() + 3 * e.getBullet().getPower());
		eHits++;
		move.onHitByBullet(e);    	
	}
    
	public void onBulletHit(BulletHitEvent e) {
		myHits++;
		hitsThisRound++;
		double shotPower = e.getBullet().getPower();
		target.setEnergy(target.getEnergy() - 4 * shotPower + Math.max(2 * (shotPower - 1), 0));
   	}

	public void onHitRobot(HitRobotEvent e) {
		if (target != null) {
			target.setEnergy(target.getEnergy() - .6);
		}
	}
	
	public void onHitWallEvent(HitWallEvent e) {
		wallHits ++;
	}

	public void onWin(WinEvent e) {
		myWins++;
		printStats();
	}
	
	public void onDeath(DeathEvent e) {
		printStats();
	}

	public Enemy getTarget() {
		return target;
	}

	public void setHisShots() {
		eShots++;
	}
	
	public void incrementMyShots() {
		myShots++;
	}
	
	public Point2D.Double getDestination(Point2D.Double point, int direction, double distance) {
		return move.getDestination(point, direction, distance);
	}
	
	public double getHisHitPercentage() {
		return ((double)eHits / eShots);
	}
	
	public double getMyHitRate() {
		return (double) myHits / myShots * 100D;
	}
}