package shinh;

import robocode.*;

public class MoveReflection extends Move {
	private Enemy enemy_;

	private int ahead_;
	private double angle_;

	public String name() {
		return "reflection";
	}

	public MoveReflection() {
		init();
	}

	public void init() {
		ent = Entangled.me;

		enemy_ = null;
	}

	public boolean isValid() {
		if (enemy_ != null && enemy_.distance < 150) return false;
		if (ent.nearWall(60)) return false;
		return true;
	}

	private void setNext() {
		ahead_ = (int)((1.5 + Math.random()) * Const.REFLECT_ONE_TIME_MOVE);

		angle_ = Const.PI_2 + Const.PI_6 * Math.random();

		double rr = Util.getRoboRadian(enemy_.radian + angle_);
		double dr = distanceRateToWall(ent.getX(), ent.getY(), rr);
		double rl = Util.getRoboRadian(enemy_.radian - angle_);
		double dl = distanceRateToWall(ent.getX(), ent.getY(), rl);

		if (dr < 200 && dl < 200) {
			angle_ = Const.PI_2 - Const.PI_6 * Math.random();
			rr = Util.getRoboRadian(enemy_.radian + angle_);
			dr = distanceRateToWall(ent.getX(), ent.getY(), rr);
			rl = Util.getRoboRadian(enemy_.radian - angle_);
			dl = distanceRateToWall(ent.getX(), ent.getY(), rl);
		}

		if (dr > dl) {
			ahead_ = -ahead_;
		}
		else {
			angle_ = Const.PI - angle_;
		}

		if (Math.abs(Util.getNormalRadian(
						 ent.getHeadingRadians() - enemy_.radian - angle_))
			< Const.PI_2)
		{
			angle_ += Const.PI;
			ahead_ = -ahead_;
		}
	}

	public void update() {
		if (enemy_ == null) {
			if (ent.target != null) {
				enemy_ = ent.target;
				setNext();
			}
			else {
				return;
			}
		}

		ent.setTurnRightRadians(
			Util.getNormalRadian(
				ent.getHeadingRadians() - enemy_.radian - angle_));

		if (ent.bmgr.isEmpty()) return;

		while (!ent.bmgr.isEmpty() &&
			   ent.bmgr.getBullet(0).hitTurn < ent.getTime()) {
			ent.bmgr.remove(0);
		}

		if (ent.bmgr.isEmpty()) return;

		EnemyBullet eb = ent.bmgr.getBullet(0);
		if (Const.REFLECT_BULLET_DODGE2 >
			Util.distance2(eb.x, eb.y, ent.getX(), ent.getY()))
		{
			if (ent.getDistanceRemaining() == 0) {
				ent.setAhead(ahead_);
				setNext();
			}
			ent.bmgr.remove(0);
		}
	}

}

