package shinh;

import robocode.*;

public class RadarMelee2 implements Radar {
	private Entangled ent;

	private boolean right_ = false;
	private Enemy finding_ = null;

	public RadarMelee2() {
		ent = Entangled.me;

		ent.out.println("radar: for melee2");
	}

	public void update() {
		if (ent.getOthers() > ent.emgr.size()) {
			ent.setTurnRadarLeftRadians(100);
			return;
		}

		long turn = ent.getTime();

		if (finding_ != null) {
			if (finding_.turn + 15 > turn || finding_.energy == 0) {
				finding_ = null;
			}
		}

		if (finding_ == null) {
			for (int i = 0; i < ent.emgr.size(); i++) {
				if (ent.emgr.get(i).turn + 15 < turn) {
					finding_ = ent.emgr.get(i);
					right_ =
						(Util.getNormalRadian(
							finding_.radian-ent.getRadarHeadingRadians()) > 0);
				}
			}
		}

		if (finding_ != null) {
			if (right_) ent.setTurnRightRadians(100);
			else ent.setTurnLeftRadians(100);
		}
		else if (ent.target != null) {
			ent.target.recalcRadian();
			double r = ent.getRadarHeadingRadians() - ent.target.radian;
			if (r > Const.PI) {
				ent.setTurnRadarRightRadians(100);
			}
			else if (r > 0) {
				ent.setTurnRadarLeftRadians(100);
			}
			else if (r > -Const.PI) {
				ent.setTurnRadarRightRadians(100);
			}
			else {
				ent.setTurnRadarLeftRadians(100);
			}
		}
		else {
			ent.setTurnRadarLeftRadians(1000);
		}

	}

}

