/*
 * Enemy.java
 * TAKEchi Masashi
 * $Id: Enemy.java,v 1.4 2002/06/08 05:31:06 take Exp $
 */
package takeBot;

/**
 * @author TAKEchi Masashi
 * @version $Revision: 1.4 $
 */
public class Enemy {
    private String name;
    private double bearing;
    private double head;
    private long ctime; //game time that the scan was produced
    private double speed;
    private double x,y;
    private double distance;
    private double anglularVelocity;
    private Coordinate bulletStartingPoint = new Coordinate();
    private Coordinate targetStartingPoint = new Coordinate();
    private double myBulletPower;
    private Coordinate impactPoint = new Coordinate(0,0);
    private double impactTime;

    public double getAnglarVelocity() {
        return this.anglularVelocity;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getName() {
        return this.name;
    }
    public void setBearing(double bearing) {
        this.bearing = bearing;
    }
    public double getBearing() {
        return this.bearing;
    }
    public void setHead(double head) {
        this.anglularVelocity = head - this.head;
        this.head = head;
    }
    public double getHead() {
        return this.head;
    }
    public void setCtime(long ctime) {
        this.ctime = ctime;
    }
    public long getCtime() {
        return this.ctime;
    }
    public void setSpeed(double speed) {
        this.speed = speed;
    };
    public double getSpeed() {
        return this.speed;
    }
    public void setX(double x) {
        this.x = x;
    }
    public double getX() {
        return this.x;
    }
    public void setY(double y) {
        this.y = y;
    }
    public double getY() {
        return this.y;
    }
    public void setDistance(double distance) {
        this.distance = distance;
    }
    public double getDistance() {
        return this.distance;
    }
    public double guessX(long when)
    {
        long diff = when - this.ctime;
        return this.x + Math.sin(this.head) * this.speed * diff;
    }
    public double guessY(long when)
    {
        long diff = when - this.ctime;
        return this.y + Math.cos(this.head) * this.speed * diff;
    }
    public double guessX(double when)
    {
        double diff = when - this.ctime;
        return this.x + Math.sin(this.head) * this.speed * diff;
    }
    public double guessY(double when)
    {
        double diff = when - this.ctime;
        return this.y + Math.cos(this.head) * this.speed * diff;
    }

    public double getImpactTime(double xb, double yb, double bPower) {
        bulletStartingPoint.set(xb, yb);
        //targetStartingPoint.set(this.x, this.y);
        
        /*
        targetHeading = tHeading;
        targetVelocity = vt;
        */
        this.myBulletPower = bPower;
        double vb = 20 - 3 * this.myBulletPower;
        
        double dX ,dY;
        
        // Start with initial guesses at 10 and 20 ticks
        return calcImpactTime(10, 20, 0.01); 
    }

    public double getBulletHeading (
        // Initial bullet position x coordinate 
        double xb, 
        // Initial bullet position y coordinate
        double yb, 
        // Power of the bullet that we will be firing
        double bPower
        )
    {
        //this.angularVelocity_rad_per_sec = angularVelocity_per_sec;
        
        bulletStartingPoint.set(xb, yb);
        //targetStartingPoint.set(this.x, this.y);
        
        /*
        targetHeading = tHeading;
        targetVelocity = vt;
        */
        this.myBulletPower = bPower;
        double vb = 20 - 3 * this.myBulletPower;
        
        double dX ,dY;
        
        // Start with initial guesses at 10 and 20 ticks
        impactTime = calcImpactTime(10, 20, 0.01); 
        impactPoint = getEstimatedPosition(impactTime);
        
        dX = (impactPoint.x - bulletStartingPoint.x);
        dY = (impactPoint.y - bulletStartingPoint.y);
        
        distance = Math.sqrt(dX*dX+dY*dY);

        return Math.atan2(dX,dY) - Math.PI;
        /*
          bulletHeading = Math.atan2(dX,dY);
          angleThreshold = Math.atan(ROBOT_RADIUS/distance);
        */
    }
    
    protected Coordinate getEstimatedPosition(double time) {
        
        double x = this.x + 
            this.speed * time * Math.sin(this.head);
        double y = this.y + 
            this.speed * time * Math.cos(this.head);
        return new Coordinate(x,y);
    }
    
    private double f(double time) {
       
        double vb = 20 - 3 * this.myBulletPower;
        
        Coordinate targetPosition = getEstimatedPosition(time);
        double dX = (targetPosition.x - bulletStartingPoint.x);
        double dY = (targetPosition.y - bulletStartingPoint.y);
        
        return Math.sqrt(dX * dX + dY * dY) - vb * time;
    }
    
    private double calcImpactTime(double t0, 
                                 double t1, double accuracy) {
        
        double X = t1;
        double lastX = t0;
        int iterationCount = 0;
        double lastfX = f(lastX);
        
        while ((Math.abs(X - lastX) >= accuracy) && (iterationCount < 15)) {
            
            iterationCount++;
            double fX = f(X);
            
            if ((fX-lastfX) == 0.0) break;
            
            double nextX = X - fX*(X-lastX)/(fX-lastfX);
            lastX = X;
            X = nextX;
            lastfX = fX;
        }
        
        return X;
    }
}
