package suh.targeting;

import robocode.*;
import robocode.util.Utils;

public class Targeting {
    public AdvancedRobot self;
    public FireManager fireManager;
    public double power;
    public int hits; // for VBullet
    
    public Targeting(AdvancedRobot self, FireManager fireManager) {
	this.self = self;
	this.fireManager = fireManager;
    }
    
    public String getName() {
	return "Basic";
    }
    
    public double getAngle(ScannedRobotEvent e) { 
	return self.getRadarHeadingRadians();
    }
    
    public void init() { }
    public void run() { }
    public void onScannedRobot(ScannedRobotEvent e) {
	power = fireManager.getPower(e);
	self.setTurnGunRightRadians(Utils.normalRelativeAngle(getAngle(e) - self.getGunHeadingRadians()));
	self.setFire(power);
    }
}
