   package jk.team;

   import robocode.*;
   import robocode.util.*;
   import java.util.*;
   import java.awt.geom.*;
   import java.awt.*;

    public class Night extends TeamRobot{
    
      final static int ALLIES = 5;
      final static int DIST_SEGS = 6;
      final static int VEL_SEGS = 8;
      final static int OFFSET_SEGS = 6;
      final static int HIT_INDEX_SEGS = 5;
      final static int WALL_SEGS = 2;
      
      final static double MAX_DIST = 2000;
      final static int BINS = 41;
      
      // static int myAllies;
    
      static double direction = 1;
    
      static EnemyInfo currentTarget;
      static Hashtable enemies = new Hashtable();
      static Hashtable allyPoints = new Hashtable();
      static Point2D.Double myLocation;
      static Point2D.Double bestPoint;
      static Rectangle2D.Double  smallFieldRect;
      
      // static double lastScannedLatVel;//we can make this global because accel is only used in 1v1
   	         //DEBUG 
      // ArrayList points = new ArrayList();  
   	
       public void run(){
         setAllColors(Color.black);
       
         setAdjustRadarForGunTurn(true);
         // setAdjustRadarForRobotTurn(true);
         setAdjustGunForRobotTurn(true);
         // myAllies = 1;
         smallFieldRect = new Rectangle2D.Double(30,30,getBattleFieldWidth() - 60, getBattleFieldHeight() - 60);
         // reverseTime = 0;
         {
            Enumeration e = enemies.elements();
            while(e.hasMoreElements()){
               EnemyInfo eInfo = (EnemyInfo)e.nextElement();
               // eInfo.isAlive = true;
               eInfo.lastHitByTime = Integer.MIN_VALUE;
               eInfo.lastScanTime =0;
               // eInfo.startEnergy = 0;
            }
             
         }
      	
         	
         do{
            if(getRadarTurnRemaining() == 0)
               setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
               
         
            myLocation =  new Point2D.Double(getX(), getY());
            
            boolean shouldReverse = Math.signum(getVelocity() + 0.0000001) != direction;
            if(currentTarget != null && (Math.abs(getDistanceRemaining()) < 30 || shouldReverse)){
              
               double dist = Math.min(myLocation.distance(currentTarget.location),600);
               
               double bestDanger = Double.POSITIVE_INFINITY;
               double testAngle = 0;
            
               do{
                  Point2D.Double testPoint = project(myLocation,testAngle,dist/2);
                  Enumeration e = enemies.elements();
                  double testDanger = 0;/*10/Math.min(
                     Math.min(new Point2D.Double().distance(testPoint),
                     new Point2D.Double(smallFieldRect.getMaxX(),0).distance(testPoint)),
                     Math.min(new Point2D.Double(0,fieldRect.getMaxY()).distance(testPoint),
                     new Point2D.Double(fieldRect.getMaxX(),fieldRect.getMaxY()).distance(testPoint)));*/
                  do{
                     EnemyInfo tmp = (EnemyInfo)e.nextElement();
                     if(tmp.isAlive){
                        double thisDist = tmp.location.distance(testPoint);
                        double thisEnemyDanger = Math.sqrt(tmp.energy)/thisDist;
                        if(getEnergy() > tmp.energy && Math.abs(thisDist - 400) < Math.abs(myLocation.distance(tmp.location) - 400))
                           thisEnemyDanger/=6;
                        boolean closest = true;
                        
                        Enumeration a = allyPoints.elements();
                        while(a.hasMoreElements()){
                           Point2D.Double allyLocation = (Point2D.Double)a.nextElement();
                           if(tmp.location.distance(allyLocation) - 100 < thisDist)
                              closest = false;
                           double angle = absoluteAngle(allyLocation,tmp.location);
                           testDanger += 30/(new Line2D.Double(project(allyLocation,angle,-10000),project(tmp.location,angle,10000)).ptSegDist(testPoint) + 50);
                        		
                        }
                     	
                        double offset = Math.abs(Math.cos(absoluteAngle(myLocation,tmp.location) - testAngle));
                        if(closest ||  tmp.lastHitByTime > (int)getTime() - 100 || getOthers() - allyPoints.size() == 1)
                           thisEnemyDanger*=1+4*offset*offset;
                           
                        testDanger += thisEnemyDanger;
                     // 	*/
                     
                     }
                  }while(e.hasMoreElements());
               
                 
                  double headingChangeCos = Math.cos(testAngle - getHeadingRadians() + getVelocity()<0?Math.PI:0);
                  
                  if( headingChangeCos > 0.5 )
                     testDanger*=shouldReverse?20:0.05;
               
                      
                  if(testDanger < bestDanger && smallFieldRect.contains(testPoint)){
                     bestDanger = testDanger;
                     bestPoint  = testPoint;
                  }
               }while((testAngle+=Math.PI/50) <= Math.PI*2);
               
               
            }
            if(bestPoint != null){
               double a;
               setTurnRightRadians(Math.tan(a = absoluteAngle(myLocation,bestPoint) - getHeadingRadians()));
               setAhead(Math.cos(a)*myLocation.distance(bestPoint));
               try{   
                  double v1 = 0.5952*currentTarget.bulletVelocity/myLocation.distance(currentTarget.location);
                  if(Math.random() >  Math.pow(v1,v1))
                     direction = -direction;
               
                  broadcastMessage(new SerializablePoint2D(myLocation.x, myLocation.y));}
                   catch(Exception ex){
                     // ex.printStackTrace();
                  }
            }
            execute();
         }while(true);
         
      }
   
    
       public void onScannedRobot(ScannedRobotEvent e){   
         double absBearing = getHeadingRadians() + e.getBearingRadians();
         double eDistance = e.getDistance();
         String eName;
         
             
         if(!isTeammate(eName = e.getName())){
            int enemiesAlive = 0;
            Enumeration all = enemies.elements();
            while(all.hasMoreElements())
               if(((EnemyInfo)all.nextElement()).isAlive)
                  enemiesAlive++;
                  
            EnemyInfo eInfo;
            if((eInfo = (EnemyInfo)enemies.get(eName)) == null){
               enemies.put(eName,eInfo = new EnemyInfo());
            }
         
            eInfo.energy = e.getEnergy();
            eInfo.isAlive = true;
            eInfo.lastScanTime = (int)getTime();
               
            eInfo.location = project(myLocation, absBearing, eDistance);
            double offset = Math.sin(absBearing - e.getHeadingRadians());
            double latVel = e.getVelocity()*offset;
         	
            TwinDuelWave w = new TwinDuelWave();
            w.bot = eInfo;
            w.firePosition = myLocation;
            w.bulletPower = Math.min(Math.min(3,1000/e.getDistance()),Math.min(getEnergy()/8,eInfo.energy/4));
            w.fireDirection = Math.signum(latVel + 0.000000000000001)*Math.asin(8/(20 - 3*w.bulletPower));
            w.fireAbsBearing = absBearing;
            w.fireTime = (int)getTime();
         
            int wallIndex = 0;
         
            if(smallFieldRect.contains(project(myLocation,absBearing + w.fireDirection,eDistance)))
               wallIndex = 1;
            
            int velIndex = (int)(Math.abs(latVel))/2;
           //  int velIndex = (int)(Math.abs(e.getVelocity()))/2;
         
            
            int offsetIndex = (int)(Math.abs(offset)*(OFFSET_SEGS - 1));
            
            double smallestDist = eDistance;
            Enumeration a = allyPoints.elements();
            while(a.hasMoreElements()){
               double dist = ((Point2D.Double)a.nextElement()).distance(eInfo.location);
               if( dist < smallestDist)
                  smallestDist = dist;
            }
         	
            int distIndex = (int)(smallestDist/MAX_DIST*DIST_SEGS);
            
            eInfo.offsetIndex = offsetIndex;
            // double accel = Math.abs(latVel) - Math.abs(lastScannedLatVel);
            // int accelIndex = 1;
            // if(enemiesAlive == 1){
               // if(accel < -0.4)
                  // accelIndex = 0;
               // if(accel > 0.4)
                  // accelIndex = 2;
            // }
            
            w.bins = eInfo.stats[wallIndex][offsetIndex][velIndex][distIndex][allyPoints.size()][(eInfo.lastHitIndex*(HIT_INDEX_SEGS - 1))/BINS];
            addCustomEvent(w);
            // lastScannedLatVel = latVel;
         
            if(currentTarget == null ||
             (currentTarget.location.distance(myLocation) + currentTarget.energy + currentTarget.offsetIndex*(60/OFFSET_SEGS))*0.9
             >
              e.getDistance() +  eInfo.energy + offsetIndex*(60/OFFSET_SEGS))
               currentTarget = eInfo;
               
            if(currentTarget == eInfo){
            
               int maxBin = (BINS - 1)/2;
               int i = 0;
               do{
                  if(w.bins[i] > w.bins[maxBin])
                     maxBin = i;
               }while(++i < BINS);
               
               setTurnGunRightRadians(Utils.normalRelativeAngle(absBearing + w.fireDirection*(maxBin - (BINS - 1)/2)/((BINS - 1)/2) - getGunHeadingRadians()));
               if(getGunHeat() == 0 && Math.abs(getGunTurnRemainingRadians()) < 20/eDistance)// && (eDistance < 400 || getEnergy() > eInfo.energy))
                  setFire(w.bulletPower);
            }
         
         
                   
            if(getOthers() - allyPoints.size() == enemiesAlive){
               all = enemies.elements();
               double otherAngle = absBearing;
               int oldestScan = Integer.MAX_VALUE;
            
               do{
                  EnemyInfo tmp = (EnemyInfo)all.nextElement();
                  if(tmp.lastScanTime < oldestScan && tmp != eInfo && tmp.isAlive && !(eInfo == currentTarget && getGunHeat() < 1)){
                     otherAngle = absoluteAngle(myLocation,tmp.location);
                     oldestScan = tmp.lastScanTime;
                  }
               }while(all.hasMoreElements());
            
            
               setTurnRadarRightRadians(Utils.normalRelativeAngle(otherAngle - getRadarHeadingRadians())*Double.POSITIVE_INFINITY);
            }
         }
      }
   
       static  Point2D.Double project(Point2D.Double location, double angle, double distance){
         return new Point2D.Double(location.x + distance*Math.sin(angle), location.y + distance*Math.cos(angle));
      }
       static double absoluteAngle(Point2D source, Point2D target) {
         return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
      }
   
       public void onMessageReceived(MessageEvent e){
         SerializablePoint2D ally = (SerializablePoint2D)e.getMessage();
         allyPoints.put(e.getSender(),new Point2D.Double(ally.x,ally.y));
      }
   	
       public void onRobotDeath(RobotDeathEvent e){
         if(isTeammate(e.getName())){
            allyPoints.remove(e.getName());
            return;
         }
       
         EnemyInfo deadBot = (EnemyInfo)enemies.get(e.getName());
         deadBot.isAlive = false;
         if (currentTarget == deadBot)
            currentTarget = null;
      }
      
       public void onHitByBullet(HitByBulletEvent e){
         if(!isTeammate(e.getName())){
            EnemyInfo eInfo = (EnemyInfo)enemies.get(e.getName());
            eInfo.lastHitByTime = (int)getTime();
            eInfo.bulletVelocity = e.getVelocity();
         }
      }
   	
       class TwinDuelWave extends Condition{
         Point2D.Double firePosition;
         double fireAbsBearing, fireDirection, bulletPower;
         int fireTime;
         EnemyInfo bot;
         int[] bins;
      
      
          public boolean test(){
            if((getTime() - fireTime)*(20 - 3*bulletPower) > firePosition.distance(bot.location)){
               int index = (int)Math.round(Utils.normalRelativeAngle(absoluteAngle(firePosition,bot.location) - fireAbsBearing)/fireDirection*((BINS - 1)/2)) + (BINS - 1)/2;
               try{bins[index]++;}
                   catch(ArrayIndexOutOfBoundsException ex){}
               bot.lastHitIndex = index;
               removeCustomEvent(this);
            }
            return false;
         }
      }	
   
   
       class EnemyInfo{
         int lastScanTime;
         boolean isAlive = true;
         int lastHitByTime, lastHitIndex, offsetIndex;
         double energy, bulletVelocity;
         int[][][][][][][] stats = new int[WALL_SEGS][OFFSET_SEGS][VEL_SEGS][DIST_SEGS][ALLIES][HIT_INDEX_SEGS][BINS];
         Point2D.Double location = new Point2D.Double();
      }
   }
    class SerializablePoint2D  implements java.io.Serializable{
      double x;
      double y;
       SerializablePoint2D(double x, double y){
         this.x = x;
         this.y = y;
      }
   }
