package djc;
import robocode.*;
import java.awt.Color;
import java.util.Random;
import java.util.Hashtable;
import java.util.Enumeration;
import java.util.LinkedList;

/**
 * StrategyBot - Based on JollyNinja by Simon Parker
 *   This actually serves as a framework for
 *   Bot development.  My bot will extend this class.
 *
 * All code that is mine is available for anyone to use for
 * any purpose, so long as I am listed as a source.
 *
 */
public class StrategyBot extends AdvancedRobot
{
    /* ********************************************************************************** */
    /*                                   CONSTANTS                                        */
    /* ********************************************************************************** */
    public static final int RESET_AFTER_CONSECTUTIVE_LOSSES = 4;

    /* ********************************************************************************** */
    /*                                MEMBER VARIABLES                                    */
    /* ********************************************************************************** */
    /** I have low energy */
    public double LOW_ENERGY_THRESHHOLD = 25.0;
    /** I have low energy, only shoot weak shots. */
    public double MAX_LOW_ENERGY_GUN_POWER = .3;
    /** I have critically low energy */
    public double CRITICAL_ENERGY_THRESHHOLD = 10.0;
    /** I have critically low energy, only shoot weak shots. */
    public double MAX_CRITICAL_ENERGY_GUN_POWER = .1;
    public double USE_SQUARE = 101;
    public static Gun currentGun = null;
    public static GunManager gunManager = null;
    public static TacticalStrategy currentStrategy = null;
    public static TacticalStrategyManager strategyManager = null; // new TacticalStrategyManager(this);
    public Random random = new Random();
    public static Hashtable targetList = new Hashtable();
    public Target currentTarget = null;
    public int skippedTurns = 0;
    public int skippedTurnsResetForOtherDeath = 0;
    public Coordinate myPos = new Coordinate();
    public Hashtable inboundBulletList = new Hashtable();
    public Target myselfAsTarget;
    public static LinkedList activeBulletsFired = new LinkedList();
    public static int enemyFiredEvents = 0;
    public static int timesHitByEnemy = 0;
    public static boolean bOneVOne = false;
    public static double survivalBonus = 60;

    public void reset()
    {
	Coordinate.FIELD_WIDTH = getBattleFieldWidth();
	Coordinate.FIELD_HEIGHT = getBattleFieldHeight();

	if(myselfAsTarget == null)
	    myselfAsTarget = new Target("myself", this);

	if(strategyManager == null)
	    strategyManager = new TacticalStrategyManager(this);

	// Reset strategies
	strategyManager.reset();
	
	if(gunManager == null)
	    gunManager = new GunManager(this);

	// Reset strategies
	gunManager.reset();
	
	setAdjustRadarForGunTurn(true);
	setAdjustGunForRobotTurn(true);

	Enumeration e = targetList.elements();
	Target t;
	while(e.hasMoreElements()) {
	    t = (Target)e.nextElement();
	    t.reset();
	}
	
	inboundBulletList.clear();
	activeBulletsFired.clear();
    }

    /**
     * Moves the bot to a coordinate in a straight line
     *
     * @author Dan Cieslak
     */
    public void goTo(Coordinate c)
    {
	// Done in currentStrategy.startTurn now
	//Coordinate myPos = new Coordinate(getX(), getY());
	Coordinate cnew = Coordinate.limitToBattleField(c);
	double r = turnTo(myPos.headingTo(cnew));
	setAhead(r * myPos.distanceFrom(cnew));
    }

    /**
     * Turns the shortest angle possible to come to a heading, then returns the direction the
     * the bot needs to move in.
     */
    int turnTo(double angle) {
	double ang;
    	int dir;
	ang = MathHelper.normalizeBearing(getHeadingRadians() - angle);
	if (ang > Math.PI/2) {
	    ang -= Math.PI;
	    dir = -1;
	}
	else if (ang < -Math.PI/2) {
	    ang += Math.PI;
	    dir = -1;
	}
	else {
	    dir = 1;
	}
	setTurnLeftRadians(ang);
	return dir;
    }

    /**
     * run: Default behavior
     *
     * Derived from JollyNinja
     */
    public void run()
    {
	reset();
	if(getOthers() == 1) {
	    bOneVOne = true;
	}

	turnRadarRightRadians(Math.PI);  // Early recon

	while (true) {
	    try {
		currentStrategy.startTurn();       // any init that needs doing at the start of the turn
		currentStrategy.setMovement();     // sets the turning angle and the ahead/back movement
		currentStrategy.setScan();         // control the radar motion
		currentGun.setGunRotation();       // control the gun motion and fires if neccessary
		currentStrategy.endTurn();         // any cleanup for end of the turn
		execute();                         // finish the turn - only call execute in 1 place
	    } catch (Exception e) { e.printStackTrace(out);}
	}
    }

    /**
     * Override this method to check sending to disabled state
     */
    public void fire(double power, String targetMode)
    {
	fireBullet(power, targetMode);
    }

    /**
     * Override this method to check sending to disabled state
     */
    public Bullet fireBullet(double power, String targetMode)
    {
	if(getEnergy() < power) return null;
	Bullet b;
	b = super.fireBullet(power);
	AdvancedBullet ab = new AdvancedBullet(b, "NONE", targetMode);
	activeBulletsFired.add(ab);
	if(currentTarget != null) {
	    ab.targetName = currentTarget.name;
	    ab.fireRespPos = currentTarget.currentFirePos;  // Updated in ct.firedAtTarget - called after this method
	    double d = myPos.distanceFrom(currentTarget.cAimHere);
	    ab.expectedImpactTime = (int)(d / MathHelper.getShotVelocity(power));
	}

	if(getEnergy() < .1) {
	    strategyManager.setStrategy(strategyManager.DISABLED);
	}
	return b;
    }
    
    /*
     * All Event handlers derived from JollyNinja
     */

    /**
     * onHitByBullet: What to do when you're hit by a bullet
     */
    public void onHitByBullet(HitByBulletEvent e)
    {
	timesHitByEnemy++;
	currentStrategy.onHitByBullet(e);
	strategyManager.decideStrategyChange();
    }
    
    /**
     * onScannedRobot: What to do when you see another Robot
     */
    public void onScannedRobot(ScannedRobotEvent e)
    {
	currentStrategy.onScannedRobot(e);
	currentGun.onScannedRobot(e);
    }

    /**
     * onDeath: Some would say we don't do much when we die...
     */
    public void onDeath(DeathEvent e)
    {
	if(getRoundNum() - strategyManager.iLastTimeWon > RESET_AFTER_CONSECTUTIVE_LOSSES) {
	    if(bOneVOne) {
		strategyManager.resetStats();
	    }
	}

	currentStrategy.onDeath(e);
	printStats();
    }

    /**
     * onHitWall: This isn't NASCAR!
     */
    public void onHitWall(HitWallEvent e)
    {
	currentStrategy.onHitWall(e);
	strategyManager.decideStrategyChange();
    }

    /**
     * onHitRobot: All ahead, ramming speed!
     */
    public void onHitRobot(HitRobotEvent e)
    {
	currentStrategy.onHitRobot(e);
	strategyManager.decideStrategyChange();
    }

    /**
     * onRobotDeath: Mourn the passing of another bot
     */
    public void onRobotDeath(RobotDeathEvent e)
    {
	currentStrategy.onRobotDeath(e);
	strategyManager.decideStrategyChange();
	skippedTurnsResetForOtherDeath = 0;
    }

    /**
     * onBulletHit: Direct hit!
     */
    public void onBulletHit(BulletHitEvent e)
    {
	currentStrategy.onBulletHit(e);
    }

    /**
     * onSkippedTurn: What to do when you're turn is skipped
     */
    public void onSkippedTurn(SkippedTurnEvent e)
    {
	skippedTurns++;
	skippedTurnsResetForOtherDeath++;
    }

    /**
     * onWin: Mission successful
     */
    public void onWin(WinEvent e)
    {
	strategyManager.iLastTimeWon = getRoundNum();
	strategyManager.sLastWinningStrategy = currentStrategy.name;
	printStats();
    }

    /**
     * Display stats
     */
    public void printStats() 
    {
	Enumeration en = targetList.elements();
	Target t;
	int totalHits = 0;
	int totalShotsFired = 0;
	double damageInflicted = 0.0;
	double damageSustained = 0.0;

	while(en.hasMoreElements()) {
	    t = (Target)en.nextElement();
	    totalHits += (int)t.timesHit;
	    totalShotsFired += (int)t.firedAt;
	    damageInflicted += t.damageInflicted;
	    damageSustained += t.damageSustained;
	    out.println("For " + t.name + " fired " + (int)t.firedAt +
			" hit " + (int)t.timesHit + " hit rate " +
			(int)(100 * t.timesHit / Math.max(1.0, t.firedAt)) +
			" damageInflicted " + t.damageInflicted + 
			" damageSustained " + t.damageSustained);
	}
	out.println("Totals: fired " + totalShotsFired +
		    " hit " + totalHits + " hit rate " +
		    (int)(100 * totalHits / Math.max(1.0, totalShotsFired)) +
		    " damageInflicted " + damageInflicted + 
		    " damageSustained " + damageSustained);
	if(bOneVOne) {
	    out.println("enemyFires Detected " + enemyFiredEvents +
			" timesHit " + timesHitByEnemy + 
			" approx enemy hit rate " + 
			(int)(100 * (double)timesHitByEnemy / Math.max(1.0, (double)enemyFiredEvents)));
	}

	out.println("Skipped: " + skippedTurns + " times.");
    }
}
