package hamilton;

import robocode.*;
import java.util.*;

public class FieldManager
{
	AdvancedRobot r;
	TargetManager t;

	double WALL_CHARGE = 1000;
	double TARGET_CHARGE = 100;
	double BULLET_CHARGE = 10;
	double MIDDLE_CHARGE = 100;
	double RANDOM_CHARGE = 200;
	
	double WALL_EXPONENT = 2.5;
	double TARGET_EXPONENT = 2;
	double BULLET_EXPONENT = 2;
	double MIDDLE_EXPONENT = 2;
	double RANDOM_EXPONENT = 2;	

	HashSet charges;
	HashSet fieldCharges;
	HashSet targetCharges;
	HashSet bulletCharges;
	
	double height;
	double width;
	
	double randomBearing;
	int count;
	double threshold;
	Coordinate randomCoordinate;
	double initialOffset;
	double sign;
	double randomDistance;
	Random generator;
	
	public FieldManager(AdvancedRobot someR, TargetManager someT)
	{
		r = someR;
		t = someT;
		
		height = r.getBattleFieldHeight();
		width = r.getBattleFieldWidth();
		
		randomBearing = 0;
		count = 0;
		threshold = 10;
		randomCoordinate = new Coordinate (0, 0);
		randomDistance = 100;
		
		initialOffset = Math.random() * 600;
		sign = 1;
		generator = new Random();
	}

	public ForceVector getForceOnRobot(Coordinate someCoordinates)
	{		
		charges = new HashSet();
		ForceVector forceSum = new ForceVector(0, 0);
		
		// add field charges
		fieldCharges = new HashSet();
		PointCharge bottom = new PointCharge( new Coordinate(someCoordinates.getX(), 0), WALL_CHARGE, WALL_EXPONENT);
		PointCharge top = new PointCharge( new Coordinate(someCoordinates.getX(), height), WALL_CHARGE, WALL_EXPONENT);
		PointCharge left = new PointCharge( new Coordinate(0, someCoordinates.getY()), WALL_CHARGE, WALL_EXPONENT);
		PointCharge right = new PointCharge( new Coordinate(width, someCoordinates.getY()), WALL_CHARGE, WALL_EXPONENT);
		PointCharge middle = new PointCharge( new Coordinate(width / 2, height / 2), (MIDDLE_CHARGE * (r.getOthers() - 1)), MIDDLE_EXPONENT);
		
		fieldCharges.add(bottom);
		fieldCharges.add(top);
		fieldCharges.add(left);
		fieldCharges.add(right);
		fieldCharges.add(middle);
		
		// add target charges
		targetCharges = new HashSet();		
		Iterator targetIterator = t.getTargetIterator();
		
		while (targetIterator.hasNext())
		{
			Target someTarget = (Target)targetIterator.next();
			PointCharge someCharge = new PointCharge(someTarget.getCoordinates(), TARGET_CHARGE, TARGET_EXPONENT);
			targetCharges.add(someCharge);
		}

		// add bullet charges
		bulletCharges = new HashSet();
		Iterator bulletIterator = t.getEnemyBulletIterator();
		
		while (bulletIterator.hasNext())
		{
			EnemyBullet someBullet = (EnemyBullet)bulletIterator.next();
			bulletCharges.add(someBullet);
		}

		// calculate field force
		ForceVector fieldForceSum = new ForceVector(0, 0);
		Iterator fieldChargeIterator = fieldCharges.iterator();
		
		while (fieldChargeIterator.hasNext())
		{
			PointCharge someCharge = (PointCharge)fieldChargeIterator.next();
			ForceVector chargeForce = someCharge.getForceOn(someCoordinates);			
			fieldForceSum.add(chargeForce);
		}
		
		// calculate target force
		ForceVector targetForceSum = new ForceVector(0, 0);
		Iterator targetChargeIterator = targetCharges.iterator();
		
		while (targetChargeIterator.hasNext())
		{
			PointCharge someCharge = (PointCharge)targetChargeIterator.next();
			ForceVector chargeForce = someCharge.getForceOn(someCoordinates);			
			targetForceSum.add(chargeForce);
		}

		// calculate bullet force
		ForceVector bulletForceSum = new ForceVector(0, 0);
		Iterator bulletChargeIterator = bulletCharges.iterator();
		
		while (bulletChargeIterator.hasNext())
		{
			EnemyBullet someCharge = (EnemyBullet)bulletChargeIterator.next();
			ForceVector chargeForce = someCharge.getForceOn(someCoordinates);
			bulletForceSum.add(chargeForce);
		}

		// calculate random force
		double randomBearing = targetForceSum.getTheta() + (Math.PI / 2);
		
		
		if (count > threshold)
		{	
			double time = r.getTime() + initialOffset;
			double sin = (Math.sin(time / 80) + 1) / 2;
			
			double factor = sin * sign;
			sign *= -1;
			
			randomDistance = (50 * factor);
			
			if (randomDistance < 0) randomDistance -= (r.getWidth() / 2);
			else randomDistance += (r.getWidth() /2);
			
			// System.out.println("Time = " + time + " Sin = " + sin + " Factor = " + factor + " Distance = " + distance);

			count = 0;
			
			// System.out.println(generator.nextGaussian());
			
			threshold = (Math.random() * 40);
		}
		
		randomCoordinate = someCoordinates.getCoordinates(randomBearing, randomDistance);
		
		PointCharge randomCharge = new PointCharge(randomCoordinate, RANDOM_CHARGE, RANDOM_EXPONENT);
		
		ForceVector random = randomCharge.getForceOn(someCoordinates);
		
		count ++;
		
		// forceSum.add(targetForceSum);
		forceSum.add(fieldForceSum);
		// forceSum.add(bulletForceSum);
		forceSum.add(random);
		
		return forceSum;
	}	
}
