package hamilton;

import robocode.*;
import java.util.*;

public class GunManager
{
	AdvancedRobot r;
	TargetManager t;
	
	double energySpentShooting;
	double energyGainedShooting;
	double energyLostGettingHit;
	
	public GunManager(AdvancedRobot someR, TargetManager someT)
	{
		r = someR;
		t = someT;
		
		energySpentShooting = 0;
		energyGainedShooting = 0;
		energyLostGettingHit = 0;
	}
	
	public void doMelee()
	{
		if (t.hasTarget())
		{
			Coordinate robotCoordinates = new Coordinate(r.getX(), r.getY());
		
			Target currentTarget = chooseTarget();

			double targetDistance = robotCoordinates.distanceFrom(currentTarget.getCoordinates());		
			double targetAbsoluteBearing = robotCoordinates.absoluteBearingTo(currentTarget.getCoordinates());
			double targetHeading = currentTarget.getAbsoluteHeading();
			double targetRelativeHeading = Calculator.relativeAngle(targetHeading - targetAbsoluteBearing);
			double targetVelocity = currentTarget.getAbsoluteVelocity();
			
			AimingInfo currentInfo = new AimingInfo(r, robotCoordinates, currentTarget, targetDistance, targetAbsoluteBearing, targetHeading, targetRelativeHeading, targetVelocity);
		
			FiringSolution stationarySolution = StationaryAiming.getSolution(currentInfo);
			FiringSolution linearSolution = LinearAiming.getSolution(currentInfo);
			FiringSolution halfLinearSolution = HalfLinearAiming.getSolution(currentInfo);
			FiringSolution possibleAreaSolution = PossibleAreaAiming.getSolution(currentInfo);
			FiringSolution randomLinearSolution = RandomLinearAiming.getSolution(currentInfo);
			FiringSolution periodicSolution = PeriodicAiming.getSolution(currentInfo);
		
			// pick best aiming algorithm and use that one
			String bestName = currentTarget.getBestAlgorithm();
			// String bestName = "possibleArea";
			// String bestName = "periodic";
			
			FiringSolution best = stationarySolution;
			if (bestName.matches("linear")) best = linearSolution;
			if (bestName.matches("halfLinear")) best = halfLinearSolution;
			if (bestName.matches("possibleArea")) best = possibleAreaSolution;
			if (bestName.matches("randomLinear")) best = randomLinearSolution;
			if (bestName.matches("periodic")) best = periodicSolution;
			
			double gunTurnAmount = Calculator.relativeAngle(best.getBearing() - r.getGunHeadingRadians());
		
			r.setTurnGunRightRadians(gunTurnAmount);
		
			if ( (r.getGunHeat() == 0.0) && (gunTurnAmount < .349) && (r.getEnergy() > 0) && (best.isValid()) )
			{
				r.setFire(best.getFirepower());
				
				energySpentShooting += best.getFirepower();
				
				VirtualWave wave = new VirtualWave(r, currentTarget, r.getTime(), robotCoordinates, best.getFirepower());
				
				System.out.println(currentTarget.name + " = " + bestName);
				
				if (stationarySolution.isValid())
				{
					 VirtualBullet stationary = new VirtualBullet(r, currentTarget, "stationary", r.getTime(), stationarySolution.getBearing(), stationarySolution.getFirepower(), robotCoordinates);
				}
				if (linearSolution.isValid())
				{
					 VirtualBullet linear = new VirtualBullet(r, currentTarget, "linear", r.getTime(), linearSolution.getBearing(), linearSolution.getFirepower(), robotCoordinates);
				}
				if (halfLinearSolution.isValid())
				{
					VirtualBullet halfLinear = new VirtualBullet(r, currentTarget, "halfLinear", r.getTime(), halfLinearSolution.getBearing(), halfLinearSolution.getFirepower(), robotCoordinates);
				}

				if (possibleAreaSolution.isValid())
				{
					 VirtualBullet possibleArea = new VirtualBullet(r, currentTarget, "possibleArea", r.getTime(), possibleAreaSolution.getBearing(), possibleAreaSolution.getFirepower(), robotCoordinates);
				}
				
				if (randomLinearSolution.isValid())
				{
					 VirtualBullet possibleArea = new VirtualBullet(r, currentTarget, "randomLinear", r.getTime(), randomLinearSolution.getBearing(), randomLinearSolution.getFirepower(), robotCoordinates);
				}
				
				if (periodicSolution.isValid())
				{
					 VirtualBullet possibleArea = new VirtualBullet(r, currentTarget, "periodic", r.getTime(), possibleAreaSolution.getBearing(), periodicSolution.getFirepower(), robotCoordinates);
				}				

				if (currentTarget.stats.algorithmMap.containsKey(bestName))
				{
					Statistic s = (Statistic)currentTarget.stats.algorithmMap.get(bestName);
				
					// System.out.println(r.getTime() + " " + currentTarget.name + " = " + bestName + " = " + s.getMean() + ", " + best.isValid());
				}
				
				// System.out.println("Energy Spent = " + energySpentShooting + " Energy Gained = " + energyGainedShooting + " Energy Lost = " + energyLostGettingHit);

			}
		}
			
	}
		
	public Target chooseTarget()
	{
				
		Coordinate robotCoordinates = new Coordinate(r.getX(), r.getY());
		
		Iterator i = t.getTargetIterator();
		
		Target currentTarget = (Target) i.next();
		double currentTargetDistance = robotCoordinates.distanceFrom(currentTarget.getCoordinates());
		
		while (i.hasNext())
		{
			Target someOtherTarget = (Target)i.next();
			double someOtherTargetDistance = robotCoordinates.distanceFrom(someOtherTarget.getCoordinates());
			
			if (currentTargetDistance > someOtherTargetDistance)
			{
				currentTarget = someOtherTarget;
				currentTargetDistance = someOtherTargetDistance;
			}
		}
		
		return currentTarget;
	}
}
