package kvk.Bots;

/**
 *  Description of the Class
 *
 * @author     Ssin.le.Terrible
 * @created    17 fvrier 2004
 */
public class PatternMatcher {

	// **************************************************************************** //
	//                         STRING PATTERN MATCHING                              //
	// **************************************************************************** //
	/**
	 *  Recherche l'angle de tir le mieux adapt
	 *
	 * @param  firePower  Description of the Parameter
	 * @return            The patternShootTurnAngle value
	 */
	public double getPatternShootTurnAngle(double firePower) {
		double   robotSize              = BattleField.getRobotSize();                 //rayon d'un robot
		double   segmentSize            = robotSize;                                  //largeur d'un segment
		double   bulletSpeed            = Fct.bulletSpeed(firePower);                 //vitesse du boulet
		// Calcul du nombre de segments pour stocker les resultats
		int      segmentsNb             = (int)(2d * Fct.maxEscapeDistance(bulletSpeed, distance) / segmentSize) + 1;
		segmentsNb += ((segmentsNb % 2) == 0 ? 1 : 0);                                //Le nb doit tre impaire
		int[]    guessFactors           = new int[segmentsNb];                        //Stock les angles de tirs
		Arrays.fill(guessFactors, -1);                                                //Rempli avec -1
		double   segmentEscapeDistance  = (double)segmentsNb * segmentSize / 2d;      //distance maxi des segments
		double   segmentEscapeAngle     = Math.atan(segmentEscapeDistance / distance);//angle maxi des segments
		double   halfRobotEscapeAngle   = Math.atan(segmentSize / 2d / distance);     //demi largeur angulaire d'un segment

		// ********************************************
		// Boucle de recherche des squences
		// ********************************************
		int      patternMult            = 1;                                          //facteur multiplicatif de PATTERN_SIZE_MIN
		int      patternSize            = C.PATTERN_SIZE_MIN * patternMult;           // taille initiale de la squence cherche
		int      patternStep            = C.PATTERN_STEP;                             //nb de caractre reprsentant chaque mouvement
		int      moveSize               = (int)(distance * 2d / bulletSpeed);         // nombre de mouvements possible
		int      patternPos             = 0;                                          //position de la squence trouve
		double   shootAngle             = 0d;                                         //angle de tir
		boolean  shootAngleFound        = false;                                      //A-t-on trouv quelque chose ?

		if (deltaCoordString.length() > (moveSize + patternSize) * patternStep) {     //Test si l'historique est assez long
			String   toMatch  = deltaCoordString.substring(deltaCoordString.length() - patternSize * patternStep);//squence  chercher
			String   regex    = "";                                                      //regular expression

			//cration de la regular expression
			for (int i = 0; i < patternSize * patternStep; i++) {
				regex += "[";
				for (int j = toMatch.charAt(i) - 1; j <= toMatch.charAt(i) + 1; j++) {
					regex += "\\u" + Fct.padZeros(Integer.toHexString(j), 4);
				}
				regex += "]";
			}
			//myBot.print(true, "RegEx=" + regex);                                         //DEBUG

			//cration du Pattern de recherche
			Pattern  p        = Pattern.compile(regex);
			Matcher  m        = p.matcher(deltaCoordString.substring(0, deltaCoordString.length() - moveSize * patternStep));//Suppression de la fin de l'historique car il faut pouoir drouler les mouvements aprs la squence

			//Squences cherches
			while (m.find()) {                                                           //Tant que l'on trouve la squence
				patternPos = (m.end() - 1) / patternStep + 1;                               //calcul de la position dans moveList
				//myBot.print(true, "Psize=" + patternSize + " Ppos=" + patternPos + " Msize=" + moveList.getSize());//DEBUG

				//Recherche de l'angle de tir en droulant la suite de la squence
				double  bulletDistance  = bulletSpeed;                                      //distance entre le boulet et moi
				Point   myPosition      = new Point(myBot.getCoord());
				Point   botCoord        = new Point(bCoord);                                //coordonnes futures du Bot
				//Point   move            = new Point(heading, speed);                        //mouvements futurs du Bot
				double  botHeading      = heading;                                          //orientation du Bot
				double  botSpeed        = speed;                                            //vitesse du bot
				double  botDistance     = botCoord.distance(myPosition);                    //distance entre le Bot et moi
				Point   patternValue    = null;
				int     time            = 0;
				int     precision;                                                          //prcision du tir
				while (bulletDistance < botDistance + robotSize && time < moveSize) {
					bulletDistance += bulletSpeed;
					patternValue = moveList.get(patternPos + time++);
					botHeading += patternValue.getX();
					speed = patternValue.getY();
					botCoord = Fct.calcXY(botCoord, heading, speed);
					//move.plus(moveList.get(patternPos + time++));
					//move.getX()=heading, move.getY()=speed
					//botCoord = Fct.calcXY(botCoord, move.getX(), move.getY());
					botDistance = botCoord.distance(myPosition);

					//Ajout de l'angle de tir trouv
					precision = (int)(Math.abs(bulletDistance - botDistance) - robotSize);
					if (precision < 0) {
						shootAngle = Fct.bearing(myPosition, botCoord) - absBearing;              //angle de tir sur le Bot
						// Stockage de l'info si le bot est encore dans l'arne
						if (botCoord.isOnField() && Math.abs(shootAngle) < segmentEscapeAngle) {
							int  segmentIndex  = (int)((shootAngle + segmentEscapeAngle) * (double)segmentsNb / 2d / segmentEscapeAngle);
							guessFactors[segmentIndex] += patternMult * Math.abs((int)robotSize - precision);
							shootAngleFound = true;
							//myBot.print("   ShootAngle[" + segmentIndex + "/" + segmentsNb + "]=" + Math.toDegrees(shootAngle));//DEBUG
						}
					}
				}
			}
		}

		// ********************************************
		// Recherche de l'index d'angle de tir le plus probable
		// ********************************************
		shootAngle = -999;
		if (shootAngleFound) {
			int  bestIndex  = -1;
			int  maxScore   = 0;
			for (int i = 0; i < segmentsNb; i++) {
				if (guessFactors[i] > maxScore) {
					maxScore = guessFactors[i];
					bestIndex = i;
				}
			}
			//Calcul de l'angle avec l'index
			//shootAngle = 2d * (double)bestIndex * segmentEscapeAngle / (double)segmentsNb - segmentEscapeAngle + halfRobotEscapeAngle;
			shootAngle = Math.atan(((double)bestIndex - ((double)segmentsNb - 1d) / 2d) * segmentSize / distance);
			//myBot.print("   FinalShootAngle[" + bestIndex + "/" + segmentsNb + "]=" + Math.toDegrees(shootAngle));//DEBUG
		}
		return absBearing + shootAngle;
	}
}

