package usa.nano;

/*
nano and David Alves present:
                                                                            _,           _, 
                                                                         .' (        .-'./ 
 _______                                ______       ______            _/..._'.    .'.-'/  
 \      \    ____    _____    ____     /___   \     /   _  \      .-'`      ` '-./.'_.'   
 /   |   \ _/ __ \  /     \  /  _ \        \   |    \  \ \  \   ( o)   ))      ;= <_     
/    |    \\  ___/ |  Y Y  \(  <_> )     /    /_     \  \_\  \    '-.,\\__ __.-;`\'. '. 
\____|__  / \___  >|__|_|  / \____/     |_______| /\  \_______|        \) |`\ \)  '.'-.\
        \/      \/       \/                       \/                      \_/       '-._\
                                                                                         ` 


Nemo is the first bot to fit GuessFactor targeting into a nanobot! 
Codesize is 249 bytes with no colors. Co-written by nano and 
David Alves. Released under package usa since we're both from 
the USA and it just might end up competing in the robocode olympics.
*/

import robocode.*;
import robocode.util.*;

public class Nemo extends AdvancedRobot {
	static final int BULLET_POWER = 3;
	static final int BULLET_SPEED = 20 - 3 * BULLET_POWER;
	static final int NUM_FACTORS = 33;
	static final int SEGMENTS_VEL = 3;
	static final int SEGMENTS_DIST = 13;
	
	static int enemyVelocityAtShot;
	static double totalLatMovementSinceShot;
	static int[][][] theStats = new int[SEGMENTS_DIST][SEGMENTS_VEL][NUM_FACTORS];

	public void run() {
		// n: This is the same as the following (both are 3 bytes):
		//    turnRadarLeftRadians(Double.POSITIVE_INFINITY);
		do {
			turnRadarLeftRadians(1);
		} while (true);
	}

	public void onScannedRobot(ScannedRobotEvent event) {
		// n: In general, it is a bad idea to initialize variables, but
		//    highestIndex must be initialized.
		//    Initializing to 0 saves 1 byte.
		int highestIndex = 0;
		double absbearing;
		double direction;
		int velocity;
		
		// n: It's not as accurate as saving the enemy's distance at the time
		//    of the wave shot, but distance changes slowly, so it works.
		int[][] stats = theStats[(int)(event.getDistance() / 100)];
		
		// n: Math.cos!  I never would have thought of it, but it saves a byte
		//    instead of doing + Math.PI/2.  Kawigi says he thinks PEZ or
		//    Jamougha came up with it.  Thanks to whoever it was, and thanks
		//    to kawigi for the tip. ;)
		setTurnRightRadians(Math.cos(absbearing = event.getBearingRadians()));
		absbearing += getHeadingRadians();
		
		totalLatMovementSinceShot += (direction =
			(event.getVelocity() * Math.sin(event.getHeadingRadians() - absbearing) + 0.001));
		
		// n: Nano mirror movement!  I had a different version of this in
		//    Nemo 1.2, but this new version is thanks to kawigi and ThnikkaBot.
		setAhead(direction * 4);
		
		// n: The simplest radar tracking there is.  Slips often.
		setTurnRadarLeftRadians(getRadarTurnRemaining());

		// n: The smallest way I've found to get the highest index
		int i = NUM_FACTORS - 1;
		do {
			if (stats[velocity = (int)(Math.abs(direction) / 3)][i] > stats[velocity][highestIndex])
				highestIndex = i;
		} while (--i > 0);
		
		setTurnGunRightRadians(
			Utils.normalRelativeAngle(
				absbearing
					+ (direction / Math.abs(direction))
					* (highestIndex / (double)NUM_FACTORS)
					- getGunHeadingRadians()));
		
		// n: Check the last wave and fire a new one.
		//    This is a bit less accurate but much smaller than firing a
		//    wave only when we fire a bullet.  David says the modulus on
		//    getTime() is too inaccurate, but my tests show otherwise, and it's
		//    quite a bit smaller than using a counter :)
		// n: absbearing = distance??? I know, it's ugly.  It's always the last
		//    byte that's toughest.
		if (getTime() % ((int)(absbearing = event.getDistance()) / BULLET_SPEED) == 0) {
			try {
				// n: Positive guess-factors only so we don't have to save
				//    the direction at time of shot.  The reasoning here is that
				//    almost all bots spike in the positive anyway. :P
				stats[enemyVelocityAtShot][(int)(NUM_FACTORS
					* Math.abs(totalLatMovementSinceShot / absbearing))]++;
			} catch (Exception e) {
				// D: It saves codesize to catch exceptions rather than check for them.
			}
			
			enemyVelocityAtShot = velocity;
			totalLatMovementSinceShot = 0;
		}
		
		setFire(BULLET_POWER);
	}
}